@ECHO OFF
  IF /I "%1" == "START" GOTO START
  IF /I "%1" == "BASECONFIG" GOTO CONFIG
  IF /I "%1" == "CONFIG" GOTO CONFIG
  IF /I "%1" == "STARTNETWORK" GOTO STARTNETWORK
  IF /I "%1" == "GLOBALVAR" GOTO GLOBALVAR
  IF /I "%1" == "UPDATE_HWINFO" GOTO UPDATE_HWINFO
  IF /I "%1" == "SET_ENV" GOTO SET_ENV
  IF /I "%1" == "PATCHED_SETENV" GOTO PATCHED_SETENV
  IF /I "%1" == "WAIT" GOTO WAIT 
  IF /I "%1" == "COMMANDO" GOTO COMMANDO 
  IF /I "%1" == "GET_EWF_STATE" GOTO GET_EWF_STATE 


:USAGE
  ECHO.
  ECHO TOOLBOX Start parameter missing
  ECHO.
  ECHO Use: Toolbox START ^| CONFIG ^| STARTNETWORK ^| GLOBALVAR ^| SET_ENV ^|
  ECHO              UPDATE_HWINFO ^| BASECONFIG ^| PATCHED_SETENV  ^| 
  ECHO              WAIT ^<WAIT_TIME^> ^<WAIT_TEXT^>  
  ECHO.
  ECHO Usage:
  ECHO.
  ECHO    START  (Use CONFIG, STARTNETWORK, GLOBALVAR, SET_ENV, UPDATE_HWINFO)
  ECHO    BASECONFIG
  ECHO    CONFIG
  ECHO    STARTNETWORK
  ECHO    GLOBALVAR
  ECHO    UPDATE_HWINFO
  ECHO    SET_ENV
  ECHO    PATCHED_SETENV
  ECHO    WAIT ^<WAIT_TIME^> ^<WAIT_TEXT^> 
  ECHO.
  PING 127.0.0.1 -n 5 >NUL
GOTO :EOF

:START
  IF EXIST W:\NUL NET USE W: /D
  CALL :CONFIG
  CALL :STARTNETWORK
  CALL :GLOBALVAR
  CALL :SET_ENV
  CALL :UPDATE_HWINFO
GOTO :EOF

:CONFIG
  IF NOT DEFINED BMNEWPCDIR SET BMNEWPCDIR=W:\$BmNewPC.dir
  SET LOCAL_BMA_DIR=C:\BMA
  IF EXIST D:\NUL SET LOCAL_BMA_DIR=D:\BMA

REM *** Set the default commandline parameters FOR the Windows Script Host
rem  cscript //nologo //h:cscript //s

  IF EXIST %LOCAL_BMA_DIR%\TEMP\NUL SET LOCAL_BMA_DIR_TEMP=%LOCAL_BMA_DIR%\TEMP
  IF EXIST %LOCAL_BMA_DIR%\LOG\NUL SET LOCAL_BMA_DIR_LOG=%LOCAL_BMA_DIR%\LOG
  IF EXIST %LOCAL_BMA_DIR%\TOOLS\NUL (
    SET PATH=%PATH%;%LOCAL_BMA_DIR%\TOOLS
    SET LOCAL_BMA_DIR_TOOLS=%LOCAL_BMA_DIR%\TOOLS
    SET BMUTIL=bmutil32.exe
    SET BMFDISK=bmfdisk32.exe
    SET BMTOOL=bmtool.vbs
    SET BMPATCH=bmpatch32.exe
  )
  SET LOCAL_NETLOGFILE=%LOCAL_BMA_DIR_LOG%\toolbox_cmd.log
  SET TOOLBOX=%~dpnx0

REM *** Check IF the required BootManage Administrator tools are available
:CHECK_TOOLS
  ECHO.
  ECHO Checking FOR BootManage Administrator utilities ...
  ECHO "TOOLBOX.CMD: Checking FOR BootManage Administrator utilities ..." >> %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log

  FOR %%A IN (%BMUTIL% %BMFDISK% %BMTOOL% %BMPATCH%) DO IF NOT EXIST %LOCAL_BMA_DIR_TOOLS%\%%A GOTO ERR_TOOLS %%A
  ECHO   All required utilities are present
  ECHO "TOOLBOX.CMD: All required utilities are present" >> %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log
  SET BMTOOL=cscript //nologo bmtool.vbs


  ECHO Checking FOR Optional configuration parameters ...
  ECHO "TOOLBOX.CMD: Checking FOR optional configuration parameters ..." >> %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log
  REM *** Check optional base Variable file %LOCAL_BMA_DIR%\VAR.DAT all entries are added as environment variable
  IF NOT EXIST %LOCAL_BMA_DIR%\Var.dat (
     ECHO "No optional configuration found %LOCAL_BMA_DIR%\VAR.DAT"
     GOTO CHECK_CFG
  )
  ECHO @ECHO off > %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.script
  FOR /f "tokens=1*" %%c IN ('TYPE %LOCAL_BMA_DIR%\Var.dat ^| FIND "LOCALADMIN"') DO ECHO SET %%c=#@%%c@# >> %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.script
  COPY %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.script %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.CMD
  %BMPATCH% %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.script %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.CMD %LOCAL_BMA_DIR%\Var.dat
  CALL  %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.CMD
  DEL %LOCAL_BMA_DIR_TEMP%\OPTIONAL_DAT.CMD 
  IF /I "%RUNASCOMMAND%" EQU "1" GOTO :EOF
  
:CHECK_CFG
REM *** BASECONFIG skip 
  IF /I "%1" == "BASECONFIG" GOTO :EOF
  ECHO Obtaining BootManage Administrator configuration parameters ...
  ECHO "TOOLBOX.CMD: Obtaining BootManage Administrator configuration parameters ..." >> %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log

REM *** Check IF the BootManage Administrator reply structure is present
  %BMFDISK% -ht \\.\physicaldrive0
  IF %ERRORLEVEL% == 0 (
     GOTO :EOF
	 ) 
 
 REM *** Import the configuration parameters as environment variables
  FOR /f "delims=" %%A IN ('%BMUTIL% /asc -s caa ca8 t140 t141 t144 t145 t153 t154 t155 t156') DO %%A
  FOR /f "delims=" %%A IN ('%BMUTIL% -s t129 t130 t131 t150 t156 t158 t159 t160 t161 t166 t167') DO %%A
  FOR /f "delims=" %%A IN ('%BMUTIL% -s t175 t174') DO %%A

REM *** Check IF the administrator has requested debug mode via option #144
  IF NOT DEFINED DEBUG SET DEBUG=%t144%
  IF "%DEBUG%" EQU "1" (
    ECHO ON
	ECHO DEBUG = "1" >> %LOCAL_BMA_DIR%\var.dat
  )
  
  IF NOT DEFINED CLIENT_SERVER_LOGFILE SET CLIENT_SERVER_LOGFILE=%BMANEWPC%\log\%ca8%.log

REM *** Assign "friendly names" to required configuration parameters
  SET BMA_MAC12=%caa%
  SET BMA_MAC8=%ca8%
  SET BMA_USERNAME=%t140%
  SET BMA_PASSWORD=%t141%
  SET BMA_SERVER=%t153%
  SET BMA_SHARE=%t145%
  SET BMA_DOMAIN=%t154%
  SET BMA_WORKGROUP=%t155%
  SET BMA_PROJECT=%t156%

REM *** Check if all required configuration parameters are present
  IF NOT DEFINED BMA_MAC12 GOTO ERR_VAR
  IF NOT DEFINED BMA_MAC8 GOTO ERR_VAR
  IF NOT DEFINED BMA_USERNAME GOTO ERR_VAR
  IF NOT DEFINED BMA_PASSWORD GOTO ERR_VAR
  IF NOT DEFINED BMA_SERVER GOTO ERR_VAR
  IF NOT DEFINED BMA_SHARE GOTO ERR_VAR
GOTO :EOF

:STARTNETWORK    
REM *** In addition, either a workgroup or a domain name must be provided.
REM *** If none or both are given, we have an error condition
  IF NOT DEFINED LOCAL_BMA_DIR_TEMP CALL :CONFIG
  IF NOT DEFINED BMA_USERNAME GOTO START
  IF NOT DEFINED BMA_PASSWORD GOTO START
  IF NOT DEFINED BMA_SERVER GOTO START
  IF NOT DEFINED BMA_SHARE GOTO START
  IF DEFINED BMA_DOMAIN GOTO DOMAIN
  IF DEFINED BMA_WORKGROUP GOTO WORKGROUP
GOTO ERR_PARAM

  
REM *** Connect a network drive while logging on using domain credentials
:DOMAIN
  ECHO Performing a DOMAIN logon.
  %BMTOOL% /WAIT 5
  NET USE W: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%BMA_DOMAIN%\%BMA_USERNAME% /persistent:no 
  IF ERRORLEVEL 1 GOTO ERR_NET_DRIVE
  ECHO "TOOLBOX.CMD: DOMAIN - Network drive successfully connected" >> %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log
GOTO :EOF

  REM *** Connect a network drive while logging on using workgroup credentials
:WORKGROUP
  ECHO Performing a WORKGROUP logon.
  %BMTOOL% /WAIT 5
  NET USE W: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%BMA_USERNAME% /persistent:no
  PING 127.0.0.1 -n 5 > NUL
  IF EXIST W:\NUL GOTO CONNECTED
  NET USE W: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%COMPUTERNAME%\%BMA_USERNAME% /persistent:no
  PING 127.0.0.1 -n 5 > NUL
  IF EXIST W:\NUL GOTO CONNECTED
  NET USE W: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%BMA_WORKGROUP%\%BMA_USERNAME% /persistent:no
  PING 127.0.0.1 -n 5 > NUL
  IF EXIST W:\NUL GOTO CONNECTED
  GOTO ERR_NET_DRIVE

:CONNECTED  
  ECHO "TOOLBOX.CMD: WORKGROUP - Network drive successfully connected" >> %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log
  ECHO WORKGROUP - Network drive successfully connected.
  IF EXIST %CLIENT_SERVER_LOGFILE% TYPE %LOCAL_BMA_DIR_LOG%\toolbox_cmd.log >> %CLIENT_SERVER_LOGFILE%
GOTO :EOF

:GLOBALVAR
REM Get global variables
  IF NOT EXIST W:\NUL CALL :STARTNETWORK
  IF NOT EXIST W:\NUL GOTO ERR_NET_DRIVE
  IF NOT DEFINED LOCAL_BMA_DIR_TEMP CALL :CONFIG
  CALL :VARBUILD
  CALL :OPTBUILD
  COPY "%LOCAL_BMA_DIR_TEMP%\client_opt.var" + "%LOCAL_BMA_DIR_TEMP%\client_var.var" "%LOCAL_BMA_DIR_TEMP%\client.var"
  SET CLIENT_SERVER_VARFILE=%LOCAL_BMA_DIR_TEMP%\client.var
GOTO :EOF  
  
:VARBUILD
REM Building local var.dat
  IF NOT EXIST W:\NUL CALL :STARTNETWORK
  IF NOT EXIST W:\NUL GOTO ERR_NET_DRIVE
  IF NOT DEFINED LOCAL_BMA_DIR_TEMP CALL :CONFIG
  COPY "%BMNEWPCDIR%\CONFIG\%ca8%.var" "%LOCAL_BMA_DIR_TEMP%\client_var.var"
  IF NOT EXIST "%LOCAL_BMA_DIR_TEMP%\client_var.var" GOTO ERR_VAR_SRC

REM store localadmin PWD IN %LOCAL_BMA_DIR%\var.dat
  ECHO. > %LOCAL_BMA_DIR%\var.dat
  FOR /f "tokens=1*" %%c IN ('TYPE %LOCAL_BMA_DIR_TEMP%\client_var.var ^| FIND "LOCALADMIN"') DO ECHO %%c %%d>> %LOCAL_BMA_DIR%\var.dat
  IF "%DEBUG%" EQU "1" ECHO DEBUG = "1" >> %LOCAL_BMA_DIR%\var.dat
GOTO :EOF
  
:OPTBUILD  
REM ************************************************************************************************
REM *** Store OPT CONFIGuration IN one file 
REM ************************************************************************************************
  IF NOT EXIST W:\NUL CALL :STARTNETWORK
  IF NOT EXIST W:\NUL GOTO ERR_NET_DRIVE
  IF NOT DEFINED LOCAL_BMA_DIR_TEMP CALL :CONFIG
  SET CLIENT_VAR=%LOCAL_BMA_DIR_TEMP%\%ca8%_opt.var
  IF NOT EXIST "%CLIENT_VAR%" (
    IF EXIST "%CLIENT_VAR%" DEL "%CLIENT_VAR%"
REM File deleted? file rights ok? 
    IF EXIST "%CLIENT_VAR%" GOTO ERR_VAR
     ECHO. > "%CLIENT_VAR%"
    IF NOT EXIST "%CLIENT_VAR%" GOTO ERR_VAR
  )

REM *** Found disk space
  DEL "%CLIENT_VAR%"
  IF EXIST "%CLIENT_VAR%.TMP" DEL "%CLIENT_VAR%.TMP"

REM *** Build OPT structure
  ECHO. > "%CLIENT_VAR%.dat"
  FOR /L %%A IN (129,1,254) DO ECHO t%%A = ^"#@t%%A@#^">>"%CLIENT_VAR%.TMP"
  ECHO ca8 = ^"%ca8%^">>"%CLIENT_VAR%.TMP"
  ECHO caa = ^"%caa%^">>"%CLIENT_VAR%.TMP"
  ECHO BMA_MAC8 = ^"%BMA_MAC8%^">>"%CLIENT_VAR%.TMP"
  ECHO BMA_MAC12 = ^"%BMA_MAC12%^">>"%CLIENT_VAR%.TMP"
  COPY "%CLIENT_VAR%.TMP" "%CLIENT_VAR%" 
  %BMPATCH% "%CLIENT_VAR%.TMP" "%CLIENT_VAR%" "%CLIENT_VAR%.dat"

REM *** Update empty fields
  FOR /L %%A IN (129,1,254) DO ECHO t%%A = ^"^">>"%CLIENT_VAR%.dat"
  COPY "%CLIENT_VAR%" "%CLIENT_VAR%.TMP"
  %BMPATCH% "%CLIENT_VAR%" "%CLIENT_VAR%.TMP" "%CLIENT_VAR%.dat"
  
  COPY "%CLIENT_VAR%.TMP" "%LOCAL_BMA_DIR_TEMP%\client_opt.var"

REM *** Cleanup
  DEL "%CLIENT_VAR%.dat"  
  DEL "%CLIENT_VAR%.TMP"  
  DEL "%CLIENT_VAR%"  
  
GOTO :EOF  

REM ****************************************
REM Function : Updating hardware information
REM ****************************************
:UPDATE_HWINFO
  ECHO Updating hardware information
  IF NOT EXIST W:\NUL CALL :STARTNETWORK
  IF NOT EXIST W:\NUL GOTO ERR_NET_DRIVE
  IF NOT DEFINED LOCAL_BMA_DIR_TEMP CALL :CONFIG
  
REM *** Create the client's device information file IN the local 'temp' directory
  IF "%DEBUG%" EQU "1" %BMTOOL% /log %CLIENT_SERVER_LOGFILE% /L "TOOLBOX.CMD: Creating client device information file ..."
  ECHO   Creating client device information file ...
  ECHO. > %LOCAL_BMA_DIR_TEMP%\devices.chi

REM *** Get the client's device information and store it IN the client's device information file
  IF "%DEBUG%" EQU "1" %BMTOOL% /log %CLIENT_SERVER_LOGFILE% /L "TOOLBOX.CMD: Detecting device information file ..."
  ECHO   Detecting device information ...
  %BMTOOL% /devices >> %LOCAL_BMA_DIR_TEMP%\devices.chi 
  ECHO. >> %LOCAL_BMA_DIR_TEMP%\devices.chi

REM *** Combine device and parameter information files and store them IN the RECENT folder
  IF EXIST %BMNEWPCDIR%\recent\%ca8%.chi DEL %BMNEWPCDIR%\recent\%ca8%.chi 

REM *** Store the DHCP reply information IN the client information file
  SET DHCPFILE=%LOCAL_BMA_DIR_TEMP%\dhcp.chi
  IF EXIST %LOCAL_BMA_DIR_TEMP%\dhcp.chi DEL %LOCAL_BMA_DIR_TEMP%\dhcp.chi
  IF "%DEBUG%" EQU "1" %BMTOOL% /log %CLIENT_SERVER_LOGFILE% /L "TOOLBOX.CMD: Storing DHCP replay information ..."
  ECHO Storing DHCP reply information ...
  ECHO [BOOTP-DHCP] >> %DHCPFILE%
    %BMUTIL% -C
  IF ERRORLEVEL 1 (
    DEL %DHCPFILE%
  ) ELSE (
   %BMUTIL% -S >> %DHCPFILE%
    ECHO. >> %DHCPFILE%
  )
  IF EXIST %DHCPFILE% (
    COPY %DHCPFILE% + %LOCAL_BMA_DIR_TEMP%\devices.chi %LOCAL_BMA_DIR_TEMP%\%ca8%.chi  
  ) ELSE (
    COPY %LOCAL_BMA_DIR_TEMP%\devices.chi %LOCAL_BMA_DIR_TEMP%\%ca8%.chi
  )  
  ECHO Store inventory information 
  COPY %LOCAL_BMA_DIR_TEMP%\%ca8%.chi %BMNEWPCDIR%\recent\%ca8%.chi
  COPY %LOCAL_BMA_DIR_TEMP%\%ca8%.chi %CLIENT_SERVER_TEMP_LOG_DIR%\%ca8%.chi /Y
  SET DHCPFILE=
GOTO :EOF

REM ************************************
REM Function : set environment variables
REM ************************************
:SET_ENV
  IF NOT DEFINED LOCAL_BMA_DIR_TEMP CALL :CONFIG
  IF NOT DEFINED CLIENT_SERVER_VARFILE CALL :GLOBALVAR
  COPY %~dpnx0 %LOCAL_BMA_DIR_TEMP%\toolbox_patched.cmd
  %BMPATCH% "%~dpnx0" "%LOCAL_BMA_DIR_TEMP%\toolbox_patched.cmd" %CLIENT_SERVER_VARFILE%
  CALL %LOCAL_BMA_DIR_TEMP%\toolbox_patched.cmd PATCHED_SETENV
  DEL %LOCAL_BMA_DIR_TEMP%\toolbox_patched.cmd
GOTO :EOF
  
:PATCHED_SETENV
REM BASIC VARIABLES
REM DO NOT SET %t129% !!!!!
  SET t130=#@t130@#
  SET t131=#@t131@#
  SET t136=#@t136@#
  SET t144=#@t144@#
  SET t145=#@t145@#
  SET t149=#@t149@#
  SET t150=#@t150@#
  SET t151=#@t151@#
  SET t152=#@t152@#
  SET t153=#@t153@#
  SET t155=#@t155@#
  SET t156=#@t156@#
  SET t157=#@t157@#
  SET t158=#@t158@#
  SET t159=#@t159@#
  SET t160=#@t160@#
  SET t161=#@t161@#
  SET t166=#@t166@#
  SET t167=#@t167@#
  SET t194=#@t194@#
  SET t200=#@t200@#
  SET t201=#@t201@#
  SET ca8=#@ca8@#
  SET caa=#@caa@#
  SET BMA_MAC8=#@ca8@#
  SET BMA_MAC12=#@caa@#

REM Commonly used variables (add here when needed)
  SET PROJECT_BASEDIR=W:\%t156%
  SET BMNEWPCDIR=W:\$BmNewPC.dir
  SET DEBUG=%t144%

REM Client directories on server
  SET CLIENT_SERVER_TEMPDIR=%BMNEWPCDIR%\temp
  SET CLIENT_SERVER_LOG_DIR=%BMNEWPCDIR%\log
  SET CLIENT_SERVER_CONFIG_DIR=%BMNEWPCDIR%\config
  SET CLIENT_SERVER_RECENT_DIR=%BMNEWPCDIR%\recent
  SET CLIENT_SERVER_LOG_DIR_MAC8=%CLIENT_SERVER_LOG_DIR%\%ca8%
  SET CLIENT_SERVER_BIOS_LOG_DIR=%CLIENT_SERVER_LOG_DIR_MAC8%\BIOS
  SET CLIENT_SERVER_TEMP_LOG_DIR=%CLIENT_SERVER_LOG_DIR_MAC8%\TEMP
  SET CLIENT_SERVER_LOGFILES_DIR=%CLIENT_SERVER_LOG_DIR_MAC8%\logfiles
  SET CLIENT_SERVER_DEBUGFILES=%CLIENT_SERVER_LOG_DIR_MAC8%\debugfiles
  SET CLIENT_SERVER_SAVED=%CLIENT_SERVER_LOG_DIR_MAC8%\saved

REM Client logfiles on server
  IF NOT DEFINED CLIENT_SERVER_VARFILE SET CLIENT_SERVER_VARFILE=%CLIENT_SERVER_CONFIG_DIR%\%ca8%.var
  SET CLIENT_SERVER_LOGFILE=%CLIENT_SERVER_LOG_DIR%\%ca8%.log
  SET CLIENT_SERVER_STATUSFILE=%CLIENT_SERVER_LOG_DIR%\%ca8%.sta
  SET CLIENT_SERVER_RECENT_FILE=%CLIENT_SERVER_RECENT_DIR%\%ca8%.chi
  SET CLIENT_SERVER_BIOSDATA=%CLIENT_SERVER_BIOS_LOG_DIR%\BIOSDATA.VAR

REM Other Directories and files on server

  SET SWTASK=%CLIENT_SERVER_LOG_DIR_MAC8%\SWTASK
  SET SWTASK_DONE=%CLIENT_SERVER_LOG_DIR_MAC8%\SWTASK_FINISHED

  SET SOFTWAREDIR=W:\$Software\$Apps
  SET NETSOFTWAREDIR=W:\$Software\Scripte
  SET BIOSDIR=W:\$Software\BIOS

REM SET BMA DIR locally to C: or D:
  SET LOCAL_BMA_DIR=C:\BMA
  IF EXIST D:\NUL SET LOCAL_BMA_DIR=D:\BMA
  SET LOCAL_BMA_DIR_LOG=%LOCAL_BMA_DIR%\LOG
  SET LOCAL_BMA_DIR_TEMP=%LOCAL_BMA_DIR%\TEMP
  SET LOCAL_BMA_DIR_TOOLS=%LOCAL_BMA_DIR%\TOOLS
  SET LOCAL_BMA_DIR_SOFTWARE=%LOCAL_BMA_DIR%\SOFTWARE

  SET LOCAL_NETLOGFILE=%LOCAL_BMA_DIR_LOG%\toolbox_cmd.log

REM Additional variables (add here when needed)
  SET MACHINEOBJECTOU=#@MACHINEOBJECTOU@#
  SET SOFTWARE=#@SOFTWARE@#
  SET UI_LANGUAGE_W7=#@UI_LANGUAGE_W7@#
  SET @DriverHandle=#@@DriverHandle@#
  SET SOFTWARE_ADDITIONAL=#@SOFTWARE_ADDITIONAL@#
  SET ADD2DOMAINUSER=#@ADD2DOMAINUSER@#
  SET ADD2DOMAINPASSWORD=#@ADD2DOMAINPASSWORD@#
  SET DOMAINADMIN=#@DOMAINADMIN@#
  SET DOMAINADMINPASSWORD=#@DOMAINADMINPASSWORD@#
  SET DOMAINADMINDOMAIN=#@DOMAINADMINDOMAIN@#
  SET LOCALDOMAIN=#@LOCALDOMAIN@#
  SET Country=#@Country@#
  SET INPUT_LOCALE_W7=#@INPUT_LOCALE_W7@#
  SET SYSTEM_LOCALE_W7=#@SYSTEM_LOCALE_W7@#
  SET TIME_ZONE_W7=#@TIME_ZONE_W7@#
  SET USER_LOCALE_W7=#@USER_LOCALE_W7@#
  SET LOCALADMIN=#@LOCALADMIN@#
  SET LOCALADMINPASSWORD=#@LOCALADMINPASSWORD@#
  SET LOCALUSER=#@LOCALUSER@#
  SET LOCALUSERPASSWORD=#@LOCALUSERPASSWORD@#
  SET LOCALUSERCREATE=#@LOCALUSERCREATE@#
  SET LOCALWORKGROUP=#@LOCALWORKGROUP@#
GOTO :EOF

REM *************************
REM Function : get ewf state
REM *************************
:GET_EWF_STATE
   SET "EWF_STATE=UNKNOWN"
   SET "EWF_BOOT=UNKNOWN"
   for /F "tokens=*" %%a in ('cmd /c ewfmgr.exe c:') do call :SET_EWF_STAT %%a 
   echo Set EWF_STATE:%EWF_STATE%  BOOT:%EWF_BOOT%
   goto :EOF

:SET_EWF_STAT
   if /I "%1" equ "STATE" SET "EWF_STATE=%2"
   if /I "%1" equ "BOOT"  SET "EWF_BOOT=%3"
   goto :EOF

REM *************************
REM Function : wait
REM *************************
:WAIT 
  SET "WAIT_TIME=%~2"
  SET "WAIT_TEXT=%~3"
  IF NOT DEFINED LINE_BACK CALL :SET_SPECIAL
  FOR /L %%I IN (1,1,%WAIT_TIME%) DO (
    <NUL (SET/P Z= %WAIT_TEXT% ^|)
    PING 127.0.0.1 -n 2 >NUL
    <NUL (SET/P Z=%LINE_BACK%)
    <NUL (SET/P Z= %WAIT_TEXT% /)
    PING 127.0.0.1 -n 2 >NUL
    <NUL (SET/P Z=%LINE_BACK%)
    <NUL (SET/P Z= %WAIT_TEXT% -)
    PING 127.0.0.1 -n 2 >NUL
    <NUL (SET/P Z=%LINE_BACK%)
    <NUL (SET/P Z= %WAIT_TEXT% \)
    PING 127.0.0.1 -n 2 >NUL
    <NUL (SET/P Z=%LINE_BACK%)
  )
  <NUL (SET/P "WAIT_CLEAR=%DEL%                                                                      ")
  <NUL (SET/P Z=%LINE_BACK%)
GOTO :EOF

REM ************************************
REM Function : special character support
REM ************************************
:SET_SPECIAL
  FOR /F "usebackq" %%a IN (`copy /Z "%~dpf0" nul`) DO SET "CR=%%a"
  FOR /F "tokens=1 delims=# " %%a IN ('"PROMPT #$H# & ECHO ON & FOR %%b IN (1) DO REM"') DO SET "DEL=%%a"
  SET "LINE_BACK=%DEL%"
  FOR /F "tokens=1 delims=# " %%a IN ('"PROMPT #$H# & ECHO ON & FOR %%b IN (1) DO REM"') DO FOR /L %%i IN (1,1,80) DO CALL SET "LINE_BACK=%%a%%LINE_BACK%%"
GOTO :EOF

REM *************************
REM Function : Runas command
REM *************************
:COMMANDO
  SET RUNASCOMMAND=1
  SET ToDo1=%2
  SET ToDo2=%3
  SET ToDo3=%4
  SET ToDo4=%5
  SET ToDo5=%6
  SET ToDo6=%7
  SET ToDo7=%8
  SET ToDo8=%9
  CALL :CONFIG
  BmRunAs.exe -user %LOCALADMIN% -password %LOCALADMINPASSWORD% -cmd -workdir %LOCAL_BMA_DIR% -command %ToDo1% %ToDo2% %ToDo3% %ToDo4% %ToDo5% %ToDo6% %ToDo7% %ToDo8% %ToDo9%

GOTO :EOF

REM ************************************************************************************************
REM *** This is the error messages section
REM ************************************************************************************************

:ERR_VAR_SRC
  SET ERROR_TYPE=TOOLS
  SET ERROR_MSG="CONFIGuration file missing (%ca8%.var)"
  ECHO.
GOTO FATAL

:ERR_TOOLS
  SET ERROR_TYPE=TOOLS
  SET ERROR_MSG="One or more of the BootManage Administrator utilities are missing (%1)"
  ECHO.
GOTO FATAL


:ERR_PARAM
  SET ERROR_TYPE=PARAM
  SET ERROR_MSG="ERROR: At least one required configuration parameter is missing or invalid !"
  ECHO.
  ECHO.
  ECHO ERROR: At least one required configuration parameter is missing or invalid !
GOTO FATAL

:ERR_VAR
  SET ERROR_TYPE=VAR
  SET ERROR_MSG="ERROR: At least one required variable configuration is missing or invalid !"
  ECHO.
  ECHO.
  ECHO ERROR: At least one required variable configuration is missing or invalid !
GOTO FATAL

:ERR_NET_DRIVE
  SET ERROR_TYPE=NET
  SET ERROR_MSG="Network drive could NOT be connected to the installation server!"
  ECHO.
  ECHO.
  ECHO ERROR: Network drive could NOT be connected to the installation server!
  ECHO.
GOTO FATAL

:FATAL
  IF NOT DEFINED CLIENT_SERVER_STATUSFILE SET CLIENT_SERVER_STATUSFILE=NUL
  IF NOT DEFINED CLIENT_LOCKFILE SET CLIENT_LOCKFILE=NUL
  ECHO.
  ECHO An error has occurred!
  ECHO This script canNOT continue!
  ECHO Please contact your network administrator!"
  ECHO.
  ECHO ERROR - see client log > %CLIENT_STATUSFILE%

:FATAL_LOOP
  IF "%DO_RETRY%" equ "1" (
     %BMTOOL% /wait 20 /key /text %ERROR_MSG%"<BR><BR>Please contact your network administrator!<BR>Press <SPACE> to retry or <ENTER> to reboot"
  ) ELSE (
      %BMTOOL% /wait 20 /key /text %ERROR_MSG%"<BR><BR>This script canNOT continue!<BR>Please contact your network administrator!"
  )
GOTO FATAL_LOOP
