Option Explicit
'Version 2008-10-01

Dim cmdLine
Dim sBuffer
dim l

'/*******************************************************
'* Function Usage
'*******************************************************/
Function Usage()
    '  WScript.StdOut.WriteLine 
       WScript.StdOut.WriteLine "BootManage Utility BMTOOL32 Script Version 2.02" 
       WScript.StdOut.WriteLine "Copyright 1989-20013 (c) bootix Technology GmbH" 
       WScript.StdOut.WriteLine "" 
       WScript.StdOut.WriteLine "Usage: " 
       WScript.StdOut.WriteLine "       /text = show text" 
       WScript.StdOut.WriteLine "       /wait [number] = wait (default = 5 sec)" 
       WScript.StdOut.WriteLine "       /clear SrcFile /o DstFile = Clear all spaces betreen last char and crlf" 
       WScript.StdOut.WriteLine "       /key = cancel via Enter" 
       WScript.StdOut.WriteLine "       /shutdown [action] = Shutdown client 0=shutdown, 1=reboot, 2=power off" & vbCrLf
       WScript.StdOut.WriteLine ""
       WScript.StdOut.WriteLine "       /log logfilename /l [text] = add text to logfile" 
       WScript.StdOut.WriteLine "       /log logfilename /L [text] = add text to logfile with data and time" 
       WScript.StdOut.WriteLine "       /log logfilename /lf filename = Add file to logfile" 
       WScript.StdOut.WriteLine "       /log logfilename /Lf filename = Add file to logfile with date and time" 
       WScript.StdOut.WriteLine ""
       WScript.StdOut.WriteLine "       /inf [file name] [/get|/set] = show / edit files" 
       WScript.StdOut.WriteLine "         /get /sec [section name] /key [key] = show value of section, key." 
       WScript.StdOut.WriteLine "         /set /sec [section name] /key [key] /val [value] = set value." 
       WScript.StdOut.WriteLine "         /del /sec [section name] = delete section." 
       WScript.StdOut.WriteLine "         /getsec /sec [section name] /out [output format #@key@# #@value@#]= show section keys and values." 
       WScript.StdOut.WriteLine ""
       WScript.StdOut.WriteLine "       /Devices Show all devices" 
       WScript.StdOut.WriteLine "       /IsValueIP [IpAddress] = check valid ip" 
end function


'/*******************************************************
'*  BIOS_DATA
'*******************************************************/
Public Function ADDITIONAL_DATA() 
   dim StrComputer, OptCounter, OptStr
   dim objWMIService, OBJECTS, objItem
   strComputer = "."
   on error resume next   
   Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")     
   Set OBJECTS = objWMIService.ExecQuery("Select * from Win32_BaseBoard")     
   OptCounter = 0
   For Each objItem In OBJECTS   
        OptStr = OptStr & "_BaseBoard_" & OptCounter & vbcrlf
		WScript.StdOut.WriteLine "[_BaseBoard_" & OptCounter & "]"
		WScript.StdOut.WriteLine "DEVICEDESC=""BaseBoard"""
		WScript.StdOut.WriteLine "HARDWAREID=""\OPT\BASEBOARD\" & OptCounter & """"
		WScript.StdOut.WriteLine "CLASS=""System Details"""
		WScript.StdOut.WriteLine "Manufacturer = """ &  objItem.Manufacturer & """"
		WScript.StdOut.WriteLine "Produkt = """ & objItem.Product & """"
		WScript.StdOut.WriteLine "Version = """ & objItem.Version & """"
		WScript.StdOut.WriteLine "SerialNumber = """ & objItem.SerialNumber & """"
		WScript.StdOut.WriteBlankLines(1)
		OptCounter = OptCounter + 1
   Next  
   Set OBJECTS = objWMIService.ExecQuery("Select * from Win32_BIOS")        
   OptCounter = 0
   For Each objItem In OBJECTS        
        OptStr = OptStr & "_BIOS_" & OptCounter & vbcrlf
		WScript.StdOut.WriteLine "[_BIOS_" & OptCounter & "]"
		WScript.StdOut.WriteLine "DEVICEDESC=""BIOS"""
		WScript.StdOut.WriteLine "HARDWAREID=""\OPT\BIOS\" & OptCounter & """"
		WScript.StdOut.WriteLine "CLASS=""System Details"""
		WScript.StdOut.WriteLine "Manufacturer = """ & objItem.Manufacturer & """"
		WScript.StdOut.WriteLine "Name = """ & objItem.Name & """"
		WScript.StdOut.WriteLine "SerialNumber = """ & objItem.SerialNumber & """"
		WScript.StdOut.WriteLine "ReleaseDate = """ & DateStringToDate(objItem.ReleaseDate) & """"
		WScript.StdOut.WriteLine "SMBIOSVersion = """ & objItem.SMBIOSBIOSVersion & """"
		WScript.StdOut.WriteLine "SMBIOSMajorVersion = """ & objItem.SMBIOSMajorVersion & """"
		WScript.StdOut.WriteLine "SMBIOSMinorVersion = """ & objItem.SMBIOSMinorVersion & """"
		WScript.StdOut.WriteLine "Version = """ & objItem.Version & """"
		WScript.StdOut.WriteBlankLines(1)
		OptCounter = OptCounter + 1
   Next   
   Set OBJECTS = nothing
   Set OBJECTS = objWMIService.ExecQuery("Select * from Win32_ComputerSystem")        
   OptCounter = 0
   For Each objItem In OBJECTS
        OptStr = OptStr & "_ComputerSystem_" & OptCounter & vbcrlf
		WScript.StdOut.WriteLine "[_ComputerSystem_" & OptCounter & "]" 
		WScript.StdOut.WriteLine "DEVICEDESC=""ComputerSystem""" 
		WScript.StdOut.WriteLine "HARDWAREID=""\OPT\CS\" & OptCounter & """"
		WScript.StdOut.WriteLine "CLASS=""System Details""" 
        WScript.StdOut.WriteLine "Manufacturer = """ & objItem.Manufacturer & """"
        WScript.StdOut.WriteLine "Model = """ & objItem.Model & """"
        WScript.StdOut.WriteLine "SystemType = """ & objItem.SystemType & """"
        WScript.StdOut.WriteLine "WakeUpType = """ & objItem.WakeUpType & """"
        WScript.StdOut.WriteLine "BootROMSupported = """ & objItem.BootROMSupported & """" 
        WScript.StdOut.WriteLine "TotalPhysicalMemory = """ & objItem.TotalPhysicalMemory & """"
		WScript.StdOut.WriteLine "TotalPhysicalMemoryMB = """ & clng((objItem.TotalPhysicalMemory) /1048576)+1 & """"
		WScript.StdOut.WriteBlankLines(1)
 	    OptCounter = OptCounter + 1
   Next   
   Set OBJECTS = nothing
   Set OBJECTS = objWMIService.ExecQuery("Select * from Win32_ComputerSystemProduct")        
   OptCounter = 0
   For Each objItem In OBJECTS
        OptStr = OptStr & "_ComputerSystemProduct_" & OptCounter & vbcrlf
		WScript.StdOut.WriteLine "[_ComputerSystemProduct_" & OptCounter & "]" 
		WScript.StdOut.WriteLine "DEVICEDESC=""ComputerSystemProduct"""
		WScript.StdOut.WriteLine "HARDWAREID=""\OPT\CSP\" & OptCounter & """"
		WScript.StdOut.WriteLine "CLASS=""System Details""" 
		WScript.StdOut.WriteLine "ID = """ & objItem.IdentifyingNumber & """"
		WScript.StdOut.WriteLine "Name = """ & objItem.Name & """"
		WScript.StdOut.WriteLine "Vendor = """ & objItem.Vendor & """"
		WScript.StdOut.WriteLine "Version = """ & objItem.Version & """"
		WScript.StdOut.WriteLine "UUID = """ & objItem.UUID & """"
		WScript.StdOut.WriteBlankLines(1)
		OptCounter = OptCounter + 1
   Next

   Set OBJECTS = objWMIService.ExecQuery("Select * from Win32_DiskPartition",,48)
   OptCounter = 0
   For Each objItem In OBJECTS
        OptStr = OptStr & "_DiskPartition_" & OptCounter & vbcrlf
		WScript.StdOut.WriteLine "[_DiskPartition_" & OptCounter & "]" 
		WScript.StdOut.WriteLine "DEVICEDESC=""DiskPartition"""
		WScript.StdOut.WriteLine "HARDWAREID=""\OPT\DISKPART\" & objItem.DiskIndex & "\" & objItem.Index  & """"
		WScript.StdOut.WriteLine "CLASS=""System Details""" 
		WScript.StdOut.WriteLine "DeviceID = """ & objItem.DeviceID & """"
		WScript.StdOut.WriteLine "PrimaryPartition = """ & objItem.PrimaryPartition & """"
		WScript.StdOut.WriteLine "Bootable = """ & objItem.Bootable & """"
		WScript.StdOut.WriteLine "BootPartition = """ & objItem.BootPartition & """"
		WScript.StdOut.WriteLine "BlockSize = """ & objItem.BlockSize & """"
		WScript.StdOut.WriteLine "Description = """ & objItem.Description & """"
		WScript.StdOut.WriteLine "NumberOfBlocks = """ & objItem.NumberOfBlocks & """"
		WScript.StdOut.WriteLine "Size = """ & objItem.Size & """"
		WScript.StdOut.WriteLine "StartingOffset = """ & objItem.StartingOffset & """"
		WScript.StdOut.WriteLine "Type = """ & objItem.Type & """"
		OptCounter = OptCounter + 1
		WScript.StdOut.WriteBlankLines(1)
   Next
   Set OBJECTS = nothing
   ADDITIONAL_DATA = OptStr
End Function




'/*******************************************************
'*  IsValueIP
'*******************************************************/
Function IsValueIP(strSearchString)
 dim objRegEx
 Set objRegEx = CreateObject("VBScript.RegExp")
 objRegEx.Global = True   
 objRegEx.IgnoreCase = False
 objRegEx.Pattern = "[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*"
 if objRegEx.test(strSearchString) = -1 then 
   wscript.quit 0
 else
   wscript.quit 1
 end if
end Function

'/*******************************************************
'*  IsValueName
'*******************************************************/
Function IsValueName(strSearchString)
 dim objRegEx
 Set objRegEx = CreateObject("VBScript.RegExp")
 objRegEx.Global = True   
 objRegEx.IgnoreCase = False
 objRegEx.Pattern = "[A-Z][A-Z][0-9][0-9][0-9][0-9][A-Z][A-Z][A-Z][0-9][0-9]"
 if objRegEx.test(strSearchString) = -1 then 
   wscript.quit 0
 else
   wscript.quit 1
 end if
end Function


'/*******************************************************
'*  DateStringToDate
'*******************************************************/
Function DateStringToDate(bDate)
  If len(bDate) < 15 Then Exit Function
  DateStringToDate = CDate(Mid(bDate, 5, 2) & "/" & Mid(bDate, 7, 2) & _
                     "/" & Left(bDate, 4) & " " & Mid (bDate, 9, 2) & ":" & _
                     Mid(bDate, 11, 2) & ":" & Mid(bDate,13, 2))
End Function


'/*******************************************************
'* Function BUILD SCSI output from txtsetup.oem
'*******************************************************/
Function GetSection(SrcFileName, Section, sOutput)
   Dim WSHShell, fso, FileIn, FileOut
   dim FoundStatus, LineIn
   dim sSplit
   dim DstFileName
   dim sValue
   dim Key
   FoundStatus=0
'WScript.StdOut.WriteLine "Start :" & Section & " - " & srcFileName & " - " & sOutput
   Set WSHShell = WScript.CreateObject("WScript.Shell")
   Set fso      = WScript.CreateObject("Scripting.FileSystemObject")
   Set FileIn  = FSO.OpenTextFile(SrcFileName, 1 )                    ' Datei zum Lesen ffnen 
   Do While Not (FileIn.atEndOfStream)                                ' wenn Datei nicht zu ende ist, weiter machen
       LineIn = trim(FileIn.Readline)
'if FoundStatus > 0 then WScript.StdOut.WriteLine "Stat:" & FoundStatus & " LineIn: " & LineIn
       if FoundStatus > 0 then
         if len(LineIn) > 1 then 
            if left(LineIn,1) = "[" then 
                FoundStatus = 0
            else
               sSplit = Split(LineIn,"=")
               key = trim(sSplit(0))
               sValue=mid(LineIn,len(key) +1)
               sValue=mid(sValue,instr(1,sValue,"=") +1)
               if sOutput = "" then 
                 WScript.StdOut.WriteLine LineIn
               else
                 'WScript.StdOut.WriteLine "out:" & sOutput
                 sBuffer = Replace(sOutput, "#@KEY@#", key,1,-1, vbTextCompare)
                 sBuffer = Replace(sBuffer, "#@VALUE@#", sValue,1,-1, vbTextCompare)
                 WScript.StdOut.WriteLine sbuffer
               end if
               FoundStatus = 2
             end if
         end if   
       else
         if ucase(LineIn) = "[" & ucase(Section) & "]" then 
             FoundStatus = 1
         end if 
'if left(LineIn,1) = "[" then WScript.StdOut.WriteLine "Found:" & LineIn & " Status:" & FoundStatus

       end if   

       if FoundStatus = 2 then 
          FoundStatus = 3
       end if   
   Loop
   FileIn.Close
   Set FileIn  = nothing
   set fso = nothing
End Function



'/*******************************************************
'* Function GetRegEntry
'*******************************************************/
Function GetRegEntry(key)
  dim strValue
  dim wshShell
  Set WshShell = WScript.CreateObject("WScript.Shell")
  on error resume next
  strValue = WshShell.RegRead(key)
  if error.number = 0 then GetRegEntry = strValue
  Set WshShell = nothing
End Function


'/*******************************************************
'* Function Shutdown
'*******************************************************/
Function Shutdown(lBuffer)
  dim objWMIService, colOperatingSystems, objOperatingSystem
  Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate, (Shutdown)}!\\.\root\cimv2")
  Set colOperatingSystems = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
  For Each objOperatingSystem in colOperatingSystems
   objOperatingSystem.Reboot()
  Next
  Set objWMIService = nothing
  Set colOperatingSystems = nothing
end Function

'/*******************************************************
'* Function Str2Int
'*******************************************************/
Function Str2Int(strBuffer)
  if IsNumeric(strBuffer) = true then 
     str2Int = clng(strBuffer)
  Else
     str2Int = -1
  End If
End Function 

'/*******************************************************
'* Function DelInfEntry
'*******************************************************/
Function DelInfEntry(SrcFileName, Section, Key)
   Dim WSHShell, fso, FileIn, FileOut
   dim FoundStatus, LineIn
   dim sSplit
   dim DstFileName
   DstFileName = SrcFileName & "$_$"
   FoundStatus=0
   Set WSHShell = WScript.CreateObject("WScript.Shell")
   Set fso      = WScript.CreateObject("Scripting.FileSystemObject")
   Set FileOut = fso.OpenTextFile (DstFileName, 2, true)              ' Datei zum Screiben ffnen; 2: immer neu anlegen
   Set FileIn  = FSO.OpenTextFile(SrcFileName, 1 )                    ' Datei zum Lesen ffnen 
   Do While Not (FileIn.atEndOfStream)                                ' wenn Datei nicht zu ende ist, weiter machen
       LineIn = trim(FileIn.Readline)
'       WScript.StdOut.WriteLine "Stat:" & FoundStatus & " LineIn: " & LineIn
       if FoundStatus = 1 then
         if len(LineIn) > 1 then 
            if left(LineIn,1) = "[" then 
               FoundStatus = 0
 '              WScript.StdOut.WriteLine "Foundstatus: 0"  
            else
               sSplit = Split(LineIn,"=")
'               WScript.StdOut.WriteLine "Found:" & trim(sSplit(0))
               if ucase(trim(sSplit(0))) = ucase(key) then
                  LineIn=mid(LineIn,len(key) +1)
                  linein=mid(LineIn,instr(1,LineIn,"=") +1)
'                  WScript.StdOut.WriteLine LineIn
'                  WScript.StdOut.WriteLine "Key Found:" & LineIn
                  FoundStatus = 2
               end if
             end if
         end if   
       else
 '        WScript.StdOut.WriteLine ucase(LineIn) & " = " & "[" & ucase(Section) & "]"
         if ucase(LineIn) = "[" & ucase(Section) & "]" then 
            FoundStatus = 1
'            WScript.StdOut.WriteLine "Foundstatus: 1"  
         end if 
       end if   
       if FoundStatus = 2 then 
'          WScript.StdOut.WriteLine Key & "=" & Value
'          FileOut.WriteLine (Key & "=" & Value)
          FoundStatus = 1
       else
          FileOut.WriteLine (LineIn)
 '         WScript.StdOut.WriteLine LineIn
       end if   
   Loop
   FileIn.Close
   FileOut.Close
   Set FileIn  = nothing
   Set FileOut  = nothing
   fso.CopyFile DstFileName,SrcFileName,True
   fso.DeleteFile DstFileName
   set fso = nothing
End Function

'/*******************************************************
'* Function SetInfEntry
'*******************************************************/
Function SetInfEntry(SrcFileName, Section, Key, Value)
   Dim WSHShell, fso, FileIn, FileOut
   dim FoundStatus, LineIn
   dim sSplit
   dim DstFileName
   dim iReplaced
   DstFileName = SrcFileName & "$_$"
   FoundStatus=0
   iReplaced=0
   Set WSHShell = WScript.CreateObject("WScript.Shell")
   Set fso      = WScript.CreateObject("Scripting.FileSystemObject")
   Set FileOut = fso.OpenTextFile (DstFileName, 2, true)              ' Datei zum Screiben ffnen; 2: immer neu anlegen
   Set FileIn  = FSO.OpenTextFile(SrcFileName, 1 )                    ' Datei zum Lesen ffnen 
   Do While Not (FileIn.atEndOfStream)                                ' wenn Datei nicht zu ende ist, weiter machen
       LineIn = trim(FileIn.Readline)
'       WScript.StdOut.WriteLine "Stat:" & FoundStatus & " LineIn: " & LineIn
       if FoundStatus > 0 then
         if len(LineIn) > 1 then 
            if left(LineIn,1) = "[" then 
                if FoundStatus = 1 then
                   FileOut.WriteLine (Key & "=" & Value)
                end if
                FoundStatus = 0
 '              WScript.StdOut.WriteLine "Foundstatus: 0"  
            else
               sSplit = Split(LineIn,"=")
'               WScript.StdOut.WriteLine "Found:" & trim(sSplit(0))
               if ucase(trim(sSplit(0))) = ucase(key) then
                  LineIn=mid(LineIn,len(key) +1)
                  linein=mid(LineIn,instr(1,LineIn,"=") +1)
'                  WScript.StdOut.WriteLine LineIn
'                  WScript.StdOut.WriteLine "Key Found:" & LineIn
                  FoundStatus = 2
               end if
             end if
         end if   
       else
 '        WScript.StdOut.WriteLine ucase(LineIn) & " = " & "[" & ucase(Section) & "]"
         if ucase(LineIn) = "[" & ucase(Section) & "]" then 
            FoundStatus = 1
'            WScript.StdOut.WriteLine "Foundstatus: 1"  
         end if 
       end if   
       if FoundStatus = 2 then 
'          WScript.StdOut.WriteLine Key & "=" & Value
          FileOut.WriteLine (Key & "=" & Value)
          iReplaced = 1
          FoundStatus=1
       else
          FileOut.WriteLine (LineIn)
 '         WScript.StdOut.WriteLine LineIn
       end if   
   Loop
   
   if iReplaced=0 then
       if FoundStatus = 1 then
           FileOut.WriteLine (Key & "=" & Value)
       else
           FileOut.WriteLine ("[" & Section & "]")
           FileOut.WriteLine (Key & "=" & Value)
       end if    
   end if
   
   FileIn.Close
   FileOut.Close
   Set FileIn  = nothing
   Set FileOut  = nothing
   fso.CopyFile DstFileName,SrcFileName,True
   fso.DeleteFile DstFileName
   set fso = nothing
End Function

'/*******************************************************
'* Function GetInfEntry
'*******************************************************/
Function GetInfEntry(SrcFileName, Section, Key)
   Dim WSHShell, fso, FileIn, FileOut
   dim FoundStatus, LineIn
   dim sSplit
   dim DstFileName
   dim sValue
   DstFileName = SrcFileName & "$_$"
   FoundStatus=0
   Set WSHShell = WScript.CreateObject("WScript.Shell")
   Set fso      = WScript.CreateObject("Scripting.FileSystemObject")
 '  Set FileOut = fso.OpenTextFile (DstFileName, 2, true)              ' Datei zum Screiben ffnen; 2: immer neu anlegen
   Set FileIn  = FSO.OpenTextFile(SrcFileName, 1 )                    ' Datei zum Lesen ffnen 
   Do While Not (FileIn.atEndOfStream)                                ' wenn Datei nicht zu ende ist, weiter machen
       LineIn = trim(FileIn.Readline)
'       WScript.StdOut.WriteLine "Stat:" & FoundStatus & " LineIn: " & LineIn
       if FoundStatus > 0 then
         if len(LineIn) > 1 then 
            if left(LineIn,1) = "[" then 
                if FoundStatus = 1 then
 '                 FileOut.WriteLine (Key & "=" & Value)
                end if
                FoundStatus = 0
 '              WScript.StdOut.WriteLine "Foundstatus: 0"  
            else
               sSplit = Split(LineIn,"=")
'               WScript.StdOut.WriteLine "Found:" & trim(sSplit(0))
               if ucase(trim(sSplit(0))) = ucase(key) then
                  sValue=mid(LineIn,len(key) +1)
                  sValue=mid(sValue,instr(1,sValue,"=") +1)
 '                 WScript.StdOut.WriteLine "Key Found:" & sValue
                  FoundStatus = 2
               end if
             end if
         end if   
       else
 '        WScript.StdOut.WriteLine ucase(LineIn) & " = " & "[" & ucase(Section) & "]"
         if ucase(LineIn) = "[" & ucase(Section) & "]" then 
             FoundStatus = 1
'            WScript.StdOut.WriteLine "Foundstatus: 1"  
         end if 
       end if   

       if FoundStatus = 2 then 
'          WScript.StdOut.WriteLine Key & "=" & sValue
          GetInfEntry=sValue
          FoundStatus = 3
       else
 '         FileOut.WriteLine (LineIn)
'          WScript.StdOut.WriteLine LineIn
       end if   
   Loop
   FileIn.Close
'   FileOut.Close
   Set FileIn  = nothing
'   Set FileOut  = nothing
   set fso = nothing
End Function


'/*******************************************************
'* Function ClearSpacesBeforeCRLF
'*******************************************************/
Function ClearSpacesBeforeCRLF(SrcFileName, DstFileName)
   Dim WSHShell, fso, FileIn, FileOut
   Set WSHShell = WScript.CreateObject("WScript.Shell")
   Set fso      = WScript.CreateObject("Scripting.FileSystemObject")
   Set FileOut = fso.OpenTextFile (DstFileName, 2, true)              ' Datei zum Screiben ffnen; 2: immer neu anlegen
   Set FileIn  = FSO.OpenTextFile(SrcFileName, 1 )                    ' Datei zum Lesen ffnen 
   Do While Not (FileIn.atEndOfStream)                                ' wenn Datei nicht zu ende ist, weiter machen
       FileOut.WriteLine (RTrim(FileIn.Readline))
   Loop
   FileIn.Close
   FileOut.Close
   Set FileIn  = nothing
   Set FileOut  = nothing
End Function

'/*******************************************************
'* Function Get_Local_Time_For_Logfile
'*******************************************************/
Function Get_Local_Time_For_Logfile()
'  WScript.StdOut.WriteLine "Date:" & Month(Now) & "/" & Day(Now) & "/" & Year(Now) & " " & Hour(Now) & ":" & Minute(Now) & ":" & Second(Now) & " "
  Get_Local_Time_For_Logfile = Month(Now) & "/" & Day(Now) & "/" & Year(Now) & " " & Hour(Now) & ":" & Minute(Now) & ":" & Second(Now) & " "
End Function

'/*******************************************************
'* Function Append_File_to_Logfile
'*******************************************************/
Function Append_File_to_Logfile(LogFileName, FileName, AddDateTime)
   Dim WSHShell, fso, FileIn, FileOut
   Dim sLogDate
   sLogDate=""
   If AddDateTime = True Then sLogDate = Get_Local_Time_For_Logfile
   Set WSHShell = WScript.CreateObject("WScript.Shell")
   Set fso      = WScript.CreateObject("Scripting.FileSystemObject")
   Set FileOut = fso.OpenTextFile (LogFileName, 8, true)
   Set FileIn  = FSO.OpenTextFile(FileName, 1 )                    ' Datei zum Lesen ffnen 
   Do While Not (FileIn.atEndOfStream)                             ' wenn Datei nicht zu ende ist, weiter machen
       FileOut.WriteLine (sLogDate & FileIn.Readline)
   Loop
   FileIn.Close
   FileOut.Close
   Set FileIn  = nothing
   Set FileOut  = nothing
End Function


'/*******************************************************
'* Function AppendFile
'*******************************************************/
Function AppendFile(FileName, strBuffer)
  Dim fso, FileOut
  Set fso     = CreateObject("Scripting.FileSystemObject")
  Set FileOut = fso.OpenTextFile (FileName, 8, true)
      FileOut.WriteLine (strBuffer)
      FileOut.Close
  Set FileOut = Nothing
  Set fso     = Nothing
 End Function

'/*******************************************************
'* Function AppendText2File
'*******************************************************/

Function AppendText2File(sFileName,LogText,AddDateTime)
  ' AppendLogInformation 0 = nothing
  ' AppendLogInformation 1 = date
  Dim szDummy
  szDummy = ""
  If AddDateTime = True Then
     szDummy = Get_Local_Time_For_Logfile
     If InStr(1, LogText, vbCrLf) > 0 Then _
        LogText = Replace(LogText, vbCrLf, vbCrLf & szDummy)
  End If
  'WScript.StdOut.WriteLine "AppendFile:" & sFileName & " LogText:" & szDummy & LogText
  AppendFile sFileName, szDummy & LogText
End Function



   '/*******************************************************
   '*  Load command line into one string
   '*******************************************************/
dim args 
set args = WScript.Arguments
cmdLine = ""

if args.Count = 0 then
   usage
   WScript.Quit 1
end if

for l = 0 to args.Count - 1
   cmdLine = cmdLine & " " & args.Item(l)
next

set args = nothing

Sub OnKeyPress(Key, Press)
  If State = 0 Then
    MsgBox "Button " & " was released"
  Else 
    MsgBox "Button " & " was pressed"
  End If
End Sub



   '/*******************************************************
   '*  shutdown
   '*******************************************************/
   If InStr(1, LCase(cmdLine), "/shutdown") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/shutdown") + 9))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = Trim(sBuffer)
     End If
     If Str2Int(sBuffer) = -1 Or Str2Int(sBuffer) > 3 Then
'       WScript.StdOut.WriteLine "Shutdown: 0" 
        Shutdown 0
     Else
'       WScript.StdOut.WriteLine "Shutdown:" & sBuffer 
        Shutdown Str2Int(sBuffer)
     End If
     WScript.Quit 0
  End If


   '/*******************************************************
   '*  text
   '*******************************************************/
   dim sText
   If InStr(1, LCase(cmdLine), "/text") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/text") + 5))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
'     If bDebug = True Then WScript.StdOut.WriteLine "REM /TEXT found (" & sBuffer & ")" & vbCrLf

     sBuffer = Replace(sBuffer, "<br>", vbCrLf,1,-1, vbTextCompare)
     sText = Replace(sBuffer, Chr(34), "",1,-1, vbTextCompare)

'     WScript.Echo "Text:"  & sText
'     WScript.StdOut.WriteLine sText
   End If


   '/*******************************************************
   '*  Wait
   '*******************************************************/
   dim lWait 
   dim objShell
   dim iRetVal
   lWait = 0
   If InStr(1, LCase(cmdLine), "/wait") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/wait") + 5))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     End If
     If sBuffer = "" Then
         lWait = 5
     Else
         if IsNumeric(sBuffer) = True then
            lWait = cLng(sBuffer)
         else
            lWait = 0
            WScript.Echo "Wrong time value"
         End If   
     End If

   if sText <> "" then
     Set objShell = WScript.CreateObject("WScript.Shell")
     If InStr(1, LCase(cmdLine), "/key") <> 0 Then
       iRetVal = objShell.Popup(sText ,lWait,"BootManage Administrator ",vbOKOnly)
       Select Case iRetVal
         Case vbOk
'           WScript.StdOut.WriteLine "Ok was pressed."
           WScript.Quit 100
         case -1 
'           WScript.StdOut.WriteLine "Popup timed out."
         end select  
         WScript.Quit 0
     else
       objShell.Popup sText ,lWait,"BootManage Administrator ",vbOKOnly
       WScript.Quit 0
     End If
   else 
     WScript.Sleep (lwait * 1000)
     WScript.Quit 0
   End if
   End If
  
   '/*******************************************************
   '*  LogFile
   '*******************************************************/
   dim AddDate
   dim SourceFile
   dim LogFile
   dim LogText
   
   If InStr(1, LCase(cmdLine), "/log ") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/log ") + 5))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
     
     LogFile = sBuffer

   If Right(cmdLine, 2) = "/L" Then AddDate = True
   If InStr(1, LCase(cmdLine), "/l ") > 0 Then
     AddDate = False
     If Mid(cmdLine, InStr(1, LCase(cmdLine), "/l "), 3) = "/L " Then AddDate = True
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/l ") + 3))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
     If Left(sBuffer, 1) = Chr(34) Then sBuffer = Mid(sBuffer, 2)
     If Right(sBuffer, 1) = Chr(34) Then sBuffer = Mid(sBuffer, 1, Len(sBuffer) - 1)
     LogText = sBuffer
   End If
   
   
   If InStr(1, LCase(cmdLine), "/lf ") > 0 Then
     AddDate = False
     If Mid(cmdLine, InStr(1, LCase(cmdLine), "/lf "), 4) = "/Lf " Then AddDate = True
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/lf ") + 4))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
     SourceFile = sBuffer
   End If
   
   
   If SourceFile <> "" Then
'       WScript.StdOut.WriteLine "LogFile:" & LogFile & " SourceFile:" & SourceFile & " AddDate:" & cStr(AddDate)
      Call Append_File_to_Logfile(LogFile, SourceFile, AddDate)
   Else
'      WScript.StdOut.WriteLine "LogFile:" & LogFile & " LogText:" & LogText & " AddDate:" & cStr(AddDate)
      If LogText <> "" Then Call AppendText2File(LogFile, LogText, AddDate)
   End If

   WScript.Quit 0
   End If
   
   
   
   '/*******************************************************
   '*  clear spaces
   '*******************************************************/
   dim SrcFile
   dim DstFile
   If InStr(1, LCase(cmdLine), "/clear ") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/clear ") + 7))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
     SrcFile = Replace(sBuffer,Chr(34), "",1,-1,vbTextCompare)

     If InStr(1, LCase(cmdLine), "/o ") > 0 Then
         sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/o ") + 3))
         If InStr(1, LCase(sBuffer), "/") > 0 Then
            sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
         Else
            sBuffer = sBuffer
         End If
         DstFile = Replace(sBuffer,Chr(34),"",1,-1, vbTextCompare)
     End If

      If SrcFile = "" Or DstFile = "" Then 
          WScript.StdOut.WriteLine "Error: /Clear Parameter missing"
          WScript.StdOut.WriteLine "SrcFile:" & SrcFile & " DstFile:" & DstFile 
          WScript.Quit 1
       End If
'     WScript.StdOut.WriteLine "SrcFile:" & SrcFile & " DstFile:" & DstFile 
     Call ClearSpacesBeforeCRLF(SrcFile, DstFile)
     WScript.Quit 0
   End If




   '/*******************************************************
   '*  Inf Modificatons
   '*******************************************************/
    dim FileName
    dim sSection
    dim sKey
    dim sValue
    dim sOutput

     
   
     If InStr(1, LCase(cmdLine), "/inf ") > 0 Or Right(LCase(cmdLine), 4) = "/inf" Then
        sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/inf ") + 4))
        If InStr(1, LCase(sBuffer), "/") > 0 Then
           FileName = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
        Else
           FileName = sBuffer
        End If
     
        If InStr(1, LCase(cmdLine), "/sec ") > 0 Or Right(LCase(cmdLine), 4) = "/sec" Then
           sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/sec ") + 4))
           If InStr(1, LCase(sBuffer), "/") > 0 Then
              sSection = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
           Else
              sSection = sBuffer
           End If
        End If

        sOutput = ""
        If InStr(1, LCase(cmdLine), "/out ") > 0 Or Right(LCase(cmdLine), 4) = "/out" Then
           sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/out ") + 4))
           If InStr(1, LCase(sBuffer), "/") > 0 Then
              sOutput = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
           Else
              sOutput = sBuffer
           End If
        End If
     
        If InStr(1, LCase(cmdLine), "/key ") > 0 Or Right(LCase(cmdLine), 4) = "/key" Then
           sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/key ") + 4))
           If InStr(1, LCase(sBuffer), "/") > 0 Then
              sKey = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
           Else
              sKey = sBuffer
           End If
        End If
     
        If InStr(1, LCase(cmdLine), "/val ") > 0 Or Right(LCase(cmdLine), 4) = "/val" Then
           sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/val ") + 4))
           If InStr(1, LCase(sBuffer), "/") > 0 Then
              sValue = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
           Else
              sValue = sBuffer
           End If
        End If

        If InStr(1, LCase(cmdLine), "/getsec ") > 0 Or Right(LCase(cmdLine), 7) = "/getsec" Then
          'WScript.StdOut.WriteLine "Function INF /get FileName:" & FileName & " Section:" &  sSection & " Key:" & sKey & " Value:" & sValue
          WScript.StdOut.WriteLine GetSection(FileName,sSection, sOutput)
        End If
     
        If InStr(1, LCase(cmdLine), "/get ") > 0 Or Right(LCase(cmdLine), 4) = "/get" Then
          'WScript.StdOut.WriteLine "Function INF /get FileName:" & FileName & " Section:" &  sSection & " Key:" & sKey & " Value:" & sValue
          WScript.StdOut.WriteLine GetInfEntry(FileName,sSection, sKey)
        End If
     
        If InStr(1, LCase(cmdLine), "/set ") > 0 Or Right(LCase(cmdLine), 4) = "/set" Then
          'WScript.StdOut.WriteLine "Function INF /set FileName:" & FileName & " Section:" &  sSection & " Key:" & sKey & " Value:" & sValue
          SetInfEntry  FileName ,sSection, sKey, sValue
        End If
     
        If InStr(1, LCase(cmdLine), "/del ") > 0 Or Right(LCase(cmdLine), 4) = "/del" Then
          'WScript.StdOut.WriteLine "Function INF /del FileName:" & FileName & " Section:" &  sSection & " Key:" & sKey & " Value:" & sValue 
          DelInfEntry FileName,sSection, sKey
        End If
     WScript.Quit 0
     End If
   

   '/*******************************************************
   '*  IsValueIP
   '*******************************************************/
   If InStr(1, LCase(cmdLine), "/isvalueip") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/IsValueIP") + 5))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
     IsValueIP(sBuffer)
   End If

   '/*******************************************************
   '*  IsValueName
   '*******************************************************/
   If InStr(1, LCase(cmdLine), "/isvaluename") > 0 Then
     sBuffer = Trim(Mid(cmdLine, InStr(1, LCase(cmdLine), "/IsValueName") + 5))
     If InStr(1, LCase(sBuffer), "/") > 0 Then
       sBuffer = Trim(Mid(sBuffer, 1, InStr(1, LCase(sBuffer), "/") - 1))
     Else
       sBuffer = sBuffer
     End If
     IsValueName(sBuffer)
   End If

 
   '/*******************************************************
   '*  Devices
   '*******************************************************/
   If InStr(1, LCase(cmdLine), "/devices") > 0 Then
      Dim objWMIService, colItems, iDevNum, objItem
      Dim strKeyPath, strValueName, strClass, i, strDriver

      ' *** Get information about all Plug & Play devices
      Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
      Set colItems = objWMIService.ExecQuery("Select * from Win32_PnPEntity")

      ' *** Store PnP device information
      iDevNum = 0

      For Each objItem In colItems
          iDevNum = iDevNum + 1
          strClass = GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & objItem.ClassGuid & "\Class")
          strDriver = GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Enum\" & objItem.PNPDeviceID & "\Driver")
          WScript.StdOut.WriteLine("[PNP_ENTITY_" & iDevNum & "]")
          WScript.StdOut.WriteLine("DEVICEDESC=""" & objItem.Name & """")
          WScript.StdOut.WriteLine("HARDWAREID=""" & objItem.PNPDeviceID & """")
          WScript.StdOut.WriteLine("SERVICE=""" & objItem.Service & """")
          WScript.StdOut.WriteLine("CLASS=""" & strClass & """")
          WScript.StdOut.WriteLine("CLASSGUID=""" & objItem.ClassGuid & """")
          WScript.StdOut.WriteLine("DRIVER=""" & strDriver & """")
          WScript.StdOut.WriteLine("MFG=""" & objItem.Manufacturer & """")
          WScript.StdOut.WriteLine("LOCATION_INFORMATION=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Enum\" & objItem.PNPDeviceID & "\LocationInformation") & """")
          WScript.StdOut.WriteLine("PHYSICAL_DEVICE_OBJECT_NAME=""""")
          WScript.StdOut.WriteLine("ENUMERATOR_NAME=""""")
          WScript.StdOut.WriteLine("CONFIGFLAGS=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Enum\" & objItem.PNPDeviceID & "\ConfigFlags") & """")
          if strDriver <> "" then 
             WScript.StdOut.WriteLine("DRIVERDATE=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\DriverDate") & """")
             WScript.StdOut.WriteLine("DRIVERDESCRIPTION=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\DriverDesc") & """")
             WScript.StdOut.WriteLine("DRIVERVERSION=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\DriverVersion") & """")
             WScript.StdOut.WriteLine("INFPATH=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\InfPath") & """")
             WScript.StdOut.WriteLine("INFSECTION=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\InfSection") & """")
             WScript.StdOut.WriteLine("INFSECTIONEX=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\InfSectionEx") & """")
             WScript.StdOut.WriteLine("MATCHINGDEVICEID=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\MatchingDeviceID") & """")
             WScript.StdOut.WriteLine("PROVIDERNAME=""" & GetRegEntry("HKLM\SYSTEM\CurrentControlSet\Control\Class\" & strDriver & "\ProviderName") & """")
           else
             WScript.StdOut.WriteLine("DRIVERDATE=""""")
             WScript.StdOut.WriteLine("DRIVERDESCRIPTION=""""")
             WScript.StdOut.WriteLine("DRIVERVERSION=""""")
             WScript.StdOut.WriteLine("INFPATH=""""")
             WScript.StdOut.WriteLine("INFSECTION=""""")
             WScript.StdOut.WriteLine("INFSECTIONEX=""""")
             WScript.StdOut.WriteLine("MATCHINGDEVICEID=""""")
             WScript.StdOut.WriteLine("PROVIDERNAME=""""")
           end if  
	      WScript.StdOut.WriteBlankLines(1)
	    Next	
      WScript.StdOut.WriteBlankLines(1)
 
      dim sAdditional
      sAdditional = ADDITIONAL_DATA
	  
      WScript.StdOut.WriteBlankLines(1)
      WScript.StdOut.WriteLine("[DEVICES]")

      For i = 1 To iDevNum
         WScript.StdOut.WriteLine("PNP_ENTITY_" & i)
      Next
      WScript.StdOut.WriteLine sAdditional

		 

      Set objWMIService = nothing
      Set colItems = nothing
      WScript.Quit 0
   end if



  usage
