@echo off
rem ************************************************************************************************
rem *** BMA_WINPE_PROJECT.CMD v2.12 2013-08-29
rem ***
rem *** This is BMA_WINPE_PROJECT.CMD, the project specific control script for Windows PE driven
rem *** client installations. It is called from the BMA_WINPE_INIT.CMD script in the Windows PE
rem *** Boot Image. Each BMA project has an individual BMA_WINPE_PROJECT.CMD file.
rem ************************************************************************************************

  set OS_TYPE=x86
  SET COPYCMD=/Y

  rem STORE_LOCAL=true,false :: start setup.exe from a local copy of the operating system
  SET STORE_LOCAL=false
  REM set DEBUG=1

  rem set "PROJECT_BASEDIR=%~Dp0"
  rem set PROJECT_BASEDIR=%PROJECT_BASEDIR:~0,-1%
  
  if "%DEBUG%" EQU "1" echo on
  
rem ************************************************************************************************
rem *** Determine what Windows PE type we are running on
rem *** (Windows PE 32-Bit x86 / Windows PE 64-Bit x64 / BartPE 32-Bit x86)
rem ************************************************************************************************

  echo.
  echo Determining Windows PE type ...
  set WINPE_TYPE=
  if /i "%PROCESSOR_ARCHITECTURE%" equ "x86"   set WINPE_TYPE=WINPE32
  if /i "%PROCESSOR_ARCHITECTURE%" equ "AMD64" set WINPE_TYPE=WINPE64
  if exist %SystemRoot%\system32\bartpe.exe    set WINPE_TYPE=BARTPE32
  if not defined WINPE_TYPE goto ERR_WINPE_TYPE
  goto %WINPE_TYPE%
  goto END


rem *** We are running on Windows PE 32-Bit x86
:WINPE32
  echo   Windows PE 32-Bit x86 (WINPE32)
  set TOOLNAMES=bmcfg32.* bmpatch32.* bmddm32.* bmfdc32.* bmpcgrp32.* bmscan32.*

  set BMCFG=bmcfg32
  set BMPATCH=bmpatch32
  set BMDDM=bmddm32
  set BMDFC=bmdfc32
  set BMPCGRP=bmpcgrp32
  set BMSCAN=bmscan32

rem *** You may add Windows PE 32-Bit x86 specific stuff here
  goto CHECK_TOOLS


rem *** We are running on Windows PE 64-Bit x64
:WINPE64
  echo   Windows PE 64-Bit x64 (WINPE64)
  set TOOLNAMES=bmcfg64.* bmpatch64.* bmddm64.* bmfdc64.* bmpcgrp64.* bmscan64.*

  set BMCFG=bmcfg64
  set BMPATCH=bmpatch64
  set BMDDM=bmddm64
  set BMDFC=bmdfc64
  set BMPCGRP=bmpcgrp64
  set BMSCAN=bmscan64
rem *** You may add other Windows PE 64-Bit x64 specific stuff here
  goto CHECK_TOOLS


rem *** We are running on BartPE 32-Bit x86
:BARTPE32
  echo   BartPE 32-Bit x86 (BARTPE32)
  set TOOLNAMES=bmcfg32.* bmpatch32.* bmddm32.* bmfdc32.* bmpcgrp32.* bmscan32.*

  set BMCFG=bmcfg32
  set BMPATCH=bmpatch32
  set BMDDM=bmddm32
  set BMDFC=bmdfc32
  set BMPCGRP=bmpcgrp32
  set BMSCAN=bmscan32
rem *** You may add BartPE 32-Bit x86 specific stuff here



rem ************************************************************************************************
rem *** Check if the required BootManage Administrator tools are available
rem ************************************************************************************************

:CHECK_TOOLS
  echo.
  echo Checking for BootManage Administrator utilities ...
  for %%A in (%TOOLNAMES%) do (
    if defined DEBUG echo   %TOOLDIR%\%%A
    if not exist %PROJECT_BASEDIR%\tools\%%A goto ERR_TOOLS
  )
  echo   All required utilities are present
  set TOOLNAMES=

  rem create new logfile structure
  if not exist %BMNEWPCDIR%\log\%ca8%\nul mkdir %BMNEWPCDIR%\log\%ca8% 
  if not exist %BMNEWPCDIR%\log\%ca8%\temp\nul mkdir %BMNEWPCDIR%\log\%ca8%\temp
  if not exist %BMNEWPCDIR%\log\%ca8%\drv\nul mkdir %BMNEWPCDIR%\log\%ca8%\drv
  if not exist %BMNEWPCDIR%\log\%ca8%\logfiles\nul mkdir %BMNEWPCDIR%\log\%ca8%\logfiles

  if not defined CLIENT_LOGFILE set CLIENT_LOGFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.log
  if not defined CLIENT_LOCKFILE=CLIENT_LOCKFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.lck
  if not defined CLIENT_STATUSFILE=set CLIENT_STATUSFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.sta
  if not defined CLIENT_VARFILE set CLIENT_VARFILE=%BMNEWPCDIR%\config\%BMA_MAC8%.var

rem ************************************************************************************************
rem *** Windows unattended installation over Windows PE
rem ************************************************************************************************
  color 27

rem ************************************************************************************************
rem *** Check if this client is protected aginst reinstall. In this case,
rem *** the BMA_WINPE_PROJECT must stop the current installation.
rem ************************************************************************************************
 if exist %BMNEWPCDIR%\locked\%BMA_MAC12%.lck goto CLIENT_PROTECTED


rem ************************************************************************************************
rem *** Windows unattended installation over Windows PE
rem ************************************************************************************************

  echo.
  echo Starting Windows unattended installation over Windows PE ...
  %BMTOOL% /wait %DISPLAY_TIME% /text "Starting Windows unattended installation over Windows PE ..."
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Starting Windows unattended installation over Windows PE ..."
  echo Starting Windows unattended installation > %CLIENT_STATUSFILE%

  call :ShowDbGMsg

rem ************************************************************************************************
rem *** Convert required configuration parameters to environment variables
rem *** Avoid to simply import all available configuration parameters using %BMUTIL% -S
rem *** because this may cause 'set' errors with values that contain special characters
rem *** (pipe, less_than, greater_than, ampersant)
rem ***
rem *** The following parameters are required:
rem ***   t129  Boot loader condition string
rem ***   t158  System partition size
rem ***   t159  System partition file system type
rem ***   t161  Data partition size
rem ***   t167  Data partition file system type
rem ***
rem *** If you need to import additional parameters as environment variables, add them here!
rem *** Note that you can also use #@ tags within this script
rem ************************************************************************************************

  echo.
  echo Obtaining required configuration parameters ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Obtaining required configuration parameters ..."
  
  if exist %CLIENT_LOCKFILE% del %CLIENT_LOCKFILE%

rem *** Check if the BootManage Administrator reply structure is present
    %BMUTIL% -C
	if "%ERRORLEVEL%" neq "0" goto DHCP_DATA


rem *** Dump the in-memory configuration parameters to a temporary file
  if not defined t129 %BMUTIL% -s t129 > %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t158 %BMUTIL% -s t158 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t158 %BMUTIL% -s t154 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t159 %BMUTIL% -s t155 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t159 %BMUTIL% -s t158 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t159 %BMUTIL% -s t159 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t161 %BMUTIL% -s t161 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t167 %BMUTIL% -s t167 >> %TEMP%\%BMA_MAC12%_env.cmd


rem *** Import the configuration parameters as environment variables
  call %TEMP%\%BMA_MAC12%_env.cmd
  SET BMA_DOMAIN=%t154%
  SET BMA_WORKGROUP=%t155%
  goto CHK_OS_TYPE
  

:DHCP_DATA
  if not defined BMA_DOMAIN SET BMA_DOMAIN=%t154%
  if not defined BMA_WORKGROUP=SET BMA_WORKGROUP=%t155%
  if not defined CLIENT_VARFILE goto ERR_CLIENT_VAR
  type %BMNEWPCDIR%\config\%BMA_MAC8%.var >> %CLIENT_VARFILE%

:CHK_OS_TYPE

rem ************************************************************************************************
rem *** Make sure that the operating systen could be installed over the Windows PE boot image
rem ************************************************************************************************

  if "%OS_TYPE%" equ "x64" (
     if "%WINPE_TYPE%" neq "WINPE64" goto ERR_PE
  )


rem ************************************************************************************************
rem *** Cancel installation
rem ************************************************************************************************
  %BMTOOL% /wait 20 /text "Starting installation<BR>Press ENTER to abort<BR>" /key
  if errorlevel 100 (
     %BMTOOL% /wait 5 /text "Cancel installation" /key
     goto SetEndID
  )  


rem ************************************************************************************************
rem *** Make the OS base directory the current working directory
rem ************************************************************************************************

  cd /d %PROJECT_BASEDIR%

  set PATH=%PATH%;%PROJECT_BASEDIR%\tools

  call :ShowDbGMsg
  
rem ************************************************************************************************
rem *** Store OPT and VAR configuration in one file 
rem ************************************************************************************************
if defined CFG_SOURCE if "%CFG_SOURCE%" equ "TFTP" goto OEM_PRE_PE
set CLIENT_VAR=
if exist s:\NUL if not exist s:\CFG\. mkdir S:\CFG
set CLIENT_VAR=S:\CFG\%ca8%.var
if exist s:\CFG\nul (
    if exist %CLIENT_VAR% del %CLIENT_VAR%
    rem File deleted? file rights ok? 
    if exist %CLIENT_VAR% goto ERR_VAR
    echo. > %CLIENT_VAR%
)    

if not exist %CLIENT_VAR% set CLIENT_VAR=%TEMP%\%ca8%.var
if not exist %CLIENT_VAR% (
   if exist %CLIENT_VAR% del %CLIENT_VAR%
    rem File deleted? file rights ok? 
    if exist %CLIENT_VAR% goto ERR_VAR
    echo. > %CLIENT_VAR%
    if not exist %CLIENT_VAR% goto ERR_VAR
)

rem *** Found disk space
  del %CLIENT_VAR%
  if exist %CLIENT_VAR%.TMP del %CLIENT_VAR%.TMP

rem *** Build OPT structure
  echo. > %CLIENT_VAR%.dat
  for /L %%A in (129,1,254) do echo t%%A = ^"#@t%%A@#^">>%CLIENT_VAR%.TMP
  echo ca8 = ^"%ca8%^">>%CLIENT_VAR%.TMP
  echo caa = ^"%caa%^">>%CLIENT_VAR%.TMP
  echo BMA_MAC8 = ^"%BMA_MAC8%^">>%CLIENT_VAR%.TMP
  echo BMA_MAC12 = ^"%BMA_MAC12%^">>%CLIENT_VAR%.TMP
  copy %CLIENT_VAR%.TMP %CLIENT_VAR% 
  %BMPATCH% %CLIENT_VAR%.TMP %CLIENT_VAR% %CLIENT_VAR%.dat

rem *** Update empty fields
  for /L %%A in (129,1,254) do echo t%%A = ^"^">>%CLIENT_VAR%.dat
  copy %CLIENT_VAR% %CLIENT_VAR%.TMP
  %BMPATCH% %CLIENT_VAR% %CLIENT_VAR%.TMP %CLIENT_VARFILE%

rem *** Change Client VAR file
  copy %CLIENT_VARFILE% + %CLIENT_VAR%.tmp %CLIENT_VAR%
  SET CLIENT_VARFILE=%CLIENT_VAR%
  del %CLIENT_VAR%.dat
  del %CLIENT_VAR%.TMP
  set CLIENT_VAR=

  echo.
  echo The desired partitioning scheme is:
  %BMTOOL% /log %CLIENT_LOGFILE% /L "The desired partitioning scheme is:"

rem ************************************************************************************************
rem *** OEM_PRE_PE * Preinstall script run before harddrive is configured
rem *** NEED_REBOOT true, false * Need Reboot allow to reboot the client before setup
rem ************************************************************************************************
:OEM_PRE_PE
  set NEED_REBOOT=false
  if not exist %PROJECT_BASEDIR%\OEM_PRE_PE.CMD goto RUN_BMA_HARD_DRIVE
  copy %PROJECT_BASEDIR%\OEM_PRE_PE.CMD %TEMP%\OEM_PRE_PE_%ca8%.CMD
  %BMPATCH% %PROJECT_BASEDIR%\OEM_PRE_PE.CMD %TEMP%\OEM_PRE_PE_%ca8%.CMD %CLIENT_VARFILE%
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_PROJECT.CMD: Run OEM_PRE_PE script"
  call :ShowDbGMsg
  call %TEMP%\OEM_PRE_PE_%ca8%.CMD start
  if /i "%NEED_REBOOT%" equ "true" goto DO_REBOOT
  if /i "%NEED_REBOOT%" equ "true" goto :EOF

rem ************************************************************************************************
rem *** Create / check harddisk structure
rem ************************************************************************************************
:RUN_BMA_HARD_DRIVE
  %BMFDISK% -p \\.\physicaldrive0 > %BMNEWPCDIR%\log\%ca8%\Drive_C_BEFORE_BMFDISK.txt
  Set ERROR=0
  call BMA_HARD_DRIVE.CMD start
  if %ERROR% neq 0 goto FATAL

  if defined DEBUG (
    %BMTOOL% /wait 10 /key /text  [debug mode] Create / check harddisk structure finished. press OK to pause
  )  
  if defined DEBUG if "%ERRORLEVEL%" neq "0" pause

  mkdir c:\BMA
  if exist "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var" (
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var" c:\BMA\config.var
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var" c:\BMA\%ca8%.var
  )


  if exist  "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt" (
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt" c:\BMA\config.opt
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt" c:\BMA\%ca8%.opt
  )


rem ************************************************************************************************
rem *** Perform hardware detection in order to preselect Windows drivers
rem ************************************************************************************************

  Set ERROR=0
  call BMA_DRIVER.CMD start
  if %ERROR% neq 0 goto FATAL

  if defined DEBUG (
    %BMTOOL% /wait 10 /key /text  [debug mode] Perform hardware detection in order to preselect Windows drivers finished. press OK to pause
  )  
  if defined DEBUG if "%ERRORLEVEL%" neq "0" pause



rem ************************************************************************************************
rem *** Build the client's parameter and device information file
rem ************************************************************************************************

  if not exist "%CLIENT_VARFILE%" (
    echo.>c:\temp\empty.var
    SET CLIENT_VARFILE=c:\temp\empty.var
  )

  echo Updating client hardware information > %CLIENT_STATUSFILE%
  call :ShowDbGMsg

rem *** Create the client's parameter and device information files in the local 'temp' directory
  echo   Creating client parameter and device information files ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Creating client parameter and device information files ..."
  echo. > c:\temp\dhcp.chi
  echo. > c:\temp\devices.chi


rem *** Get the client's device information and store it in the client's device information file
  echo   Detecting device information ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Detecting device information ..."
  %BMTOOL% /devices >> c:\temp\devices.chi 
  echo. >> c:\temp\devices.chi

rem *** Store the DHCP reply information in the client's parameter information file
  echo   Storing DHCP reply information ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Storing DHCP reply information ..."
  echo [BOOTP-DHCP] >> c:\temp\dhcp.chi

  %BMUTIL% -C >nul
  if ERRORLEVEL 1 (
     echo set caa=%CAA% >> c:\temp\dhcp.chi
     echo set ca8=%CA8% >> c:\temp\dhcp.chi	
     echo set yip=%BMNET_IP_ADDRESS% >> c:\temp\dhcp.chi
     echo set smf=%BMNET_IP_MASK% >> c:\temp\dhcp.chi
     echo set gip=%BMNET_GATEWAY% >> c:\temp\dhcp.chi
     echo set gw0=%BMNET_GATEWAY% >> c:\temp\dhcp.chi
     echo set typ=0000 >> c:\temp\dhcp.chi
     echo set sip=%BMA_TFTP_SERVER% >> c:\temp\dhcp.chi
  ) else (
   %BMUTIL% -S >> c:\temp\dhcp.chi
  )
  echo. >> c:\temp\dhcp.chi
  
rem *** Combine device and parameter information files and store them in the RECENT folder
  copy c:\temp\dhcp.chi + c:\temp\devices.chi %BMNEWPCDIR%\recent\%BMA_MAC8%.chi  /Y



rem ************************************************************************************************
rem *** Build the unattend.txt file from its building blocks
rem ************************************************************************************************

 color 0e

%BMTOOL% /PCI /s >c:\temp\hw.cmd

copy .\cmdlines.cmd c:\temp\cmdlines.cmd >nul

if exist .\default.reg (
  copy .\default.reg  c:\temp\default.reg
  %BMPATCH% .\default.reg c:\temp\default.reg
  if exist default.reg %BMUTIL% -a .\default.reg c:\temp\default.reg
)

%BMTOOL% /log %BMNEWPCDIR%\log\%ca8%.log /L "INSTALL: setting cmdlines.cmd to run within setup"
%BMTOOL% /log %BMNEWPCDIR%\log\%ca8%.log /L "INSTALL: starting unattended installation"

  call :ShowDbGMsg

  if defined BMA_DOMAIN (
    if defined DEBUG echo   DOMAIN environment, using %PROJECT_BASEDIR%\unattend_domain.xml
    %BMTOOL% /log %CLIENT_LOGFILE% /L "  DOMAIN environment, using %PROJECT_BASEDIR%\unattend_domain.xml"
    set UNATTEND_XML=%PROJECT_BASEDIR%\unattend_domain.xml
  )

  if defined BMA_WORKGROUP (
    if defined DEBUG echo   WORKGROUP environment, using %PROJECT_BASEDIR%\unattend_workgroup.xml
    %BMTOOL% /log %CLIENT_LOGFILE% /L "  WORKGROUP environment, using %PROJECT_BASEDIR%\unattend_workgroup.xml"
    set UNATTEND_XML=%PROJECT_BASEDIR%\unattend_workgroup.xml
  )
  call :ShowDbGMsg

  copy %UNATTEND_XML% c:\temp\unattend.xml 
  %BMPATCH% %UNATTEND_XML% c:\temp\unattend.xml %CLIENT_VARFILE%

  call :ShowDbGMsg

rem ************************************************************************************************
rem *** Copy and patch the NETWORK.CMD file that is called from within CMDLINES.TXT
rem *** during the unattended Windows setup
rem ************************************************************************************************

  if defined DEBUG echo.
  if defined DEBUG echo Copying the network.cmd file that is called from within cmdlines.txt ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Copying the network.cmd file that is called from within cmdlines.txt ..."

  %BMPATCH% %PROJECT_BASEDIR%\network.cmd c:\temp\network.cmd %CLIENT_VARFILE%

    call :ShowDbGMsg

rem ***************************************************
rem OEM_PE.CMD
rem ***************************************************
  if exist %PROJECT_BASEDIR%\OEM_PE.CMD (
     copy %PROJECT_BASEDIR%\OEM_PE.CMD c:\temp\OEM_PE.CMD
     %BMPATCH% %PROJECT_BASEDIR%\OEM_PE.CMD c:\temp\OEM_PE.CMD %CLIENT_VARFILE%
     %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_PROJECT.CMD: Run OEM_PE script"
     call c:\temp\OEM_PE.CMD start
  )

    call :ShowDbGMsg

rem ***************************************************
rem OEM_WIN.CMD
rem ***************************************************
  if exist %PROJECT_BASEDIR%\OEM_WIN.CMD (
     copy %PROJECT_BASEDIR%\OEM_WIN.CMD c:\temp\OEM_WIN.CMD
     %BMPATCH% %PROJECT_BASEDIR%\OEM_WIN.CMD c:\temp\OEM_WIN.CMD %CLIENT_VARFILE%
  )

    call :ShowDbGMsg

rem ************************************************************************************************
rem *** Copy the BootManage Administrator tools to the local hard disk. These tools may be needed
rem *** during the installation phases that are controlled by the Windows Setup Installer, e.g.
rem *** 'cmdlines.txt' and 'GUIRunOnce'.
rem ************************************************************************************************
  rem copy %PROJECT_BASEDIR%\tools\%BMTOOL% c:\temp
  rem copy %PROJECT_BASEDIR%\tools\%BMTOOL%.* c:\temp
  copy %PROJECT_BASEDIR%\tools\BMTOOL*.* c:\temp >nul
  copy %PROJECT_BASEDIR%\tools\msvbvm60.dll c:\temp >nul
  rem delete old file structure
  if "%ca8%" neq "" if exist %BMNEWPCDIR%\log\%ca8%\. rd /S /Q %BMNEWPCDIR%\log\%ca8%\
  

  Echo physicaldrive 0 partition structure before setup > %BMNEWPCDIR%\log\%ca8%\logfiles\Drive_0_STAT1.LOG
  %BMFDISK% -p \\.\physicaldrive0 >> %BMNEWPCDIR%\log\%ca8%\logfiles\Drive_0_STAT1.LOG
  %BMFDISK% -jl >> %BMNEWPCDIR%\log\%ca8%\logfiles\Drive_0_STAT1.LOG
  dir c:\drv /s /b > %BMNEWPCDIR%\log\%ca8%\logfiles\DIR_DRV.LOG
  dir c:\*.* /s > %BMNEWPCDIR%\log\%ca8%\logfiles\DIR_C_STEP1.LOG


  call :ShowDbGMsg


rem ************************************************************************************************
rem *** Start Windows unattended installation via WINNT32.EXE
rem ************************************************************************************************
  if defined DEBUG (
    copy c:\temp\*.* %BMNEWPCDIR%\log\%ca8%\temp
    dir c:\drv /s /b > %BMNEWPCDIR%\log\%ca8%\drv_dir.txt
    dir c:\*.* /s > %BMNEWPCDIR%\log\%ca8%\Drive_C_dir.txt
    %BMFDISK% -p \\.\physicaldrive0 > %BMNEWPCDIR%\log\%ca8%\Drive_C_BMFDISK.txt
    
  )


  if defined DEBUG (
    %BMTOOL% /wait 5 /key /text  [debug mode] press OK to pause
  )  
  if defined DEBUG if "%ERRORLEVEL%" neq "0" pause

rem *** find source directory
  set SetupDir=unset
  if "%OS_TYPE%" equ "x64" (
      if exist netsetup\setup.exe set SetupDir=netsetup
  ) else (
   if "%OS_TYPE%" equ "x86" (
      if exist i386\setup.exe set SetupDir=i386
    ) else (
     if exist i386\setup.exe set SetupDir=i386
     if exist netsetup\setup.exe set SetupDir=netsetup
     )
    )
  )
if "%SetupDir%" equ "unset" goto ERR_SETUPEXE

rem *** Copy os files into local folder
  if /i "%STORE_LOCAL%" equ "true" (
    echo Build local repository ...
    mkdir c:\temp\%SetupDir%
    if defined DEBUG  xcopy %SetupDir%\*.* c:\temp\%SetupDir%\. /s /e 
    if not defined DEBUG  xcopy %SetupDir%\*.* c:\temp\%SetupDir%\. /s /e >nul
    if %ERRORLEVEL% neq 0 goto ERR_XOPY
    cd /d c:\temp
     %BMTOOL% /wait 5 /key /text Start setup from local repository
  )
  

rem *** Start setup.exe
  echo.
  echo Executing Windows Setup Installer ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Executing Windows Setup Installer ..."
  echo Executing Windows Setup Installer > %CLIENT_STATUSFILE%

  start /wait %SetupDir%\setup.exe /tempdrive:c: /unattend:c:\temp\unattend.xml /noreboot

  cd /d %PROJECT_BASEDIR%

  if defined DEBUG (
     md %BMNEWPCDIR%\log\%ca8%
     md %BMNEWPCDIR%\log\%ca8%\%t156%
     if exist c:\$WINDOWS.~BT\Sources\Panther\*.* copy c:\$WINDOWS.~BT\Sources\Panther\*.* %BMNEWPCDIR%\log\%ca8%\%t156%
  )



rem ************************************************************************************************
rem *** If you need to perform any custom additional tasks before Windows starts from the
rem *** hard disk and continues the installation process, do it here and now
rem ************************************************************************************************

  echo.
  echo Executing custom post installation tasks ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Executing custom post installation tasks ..."
  echo Executing custom post installation tasks > %CLIENT_STATUSFILE%

rem *** OEM_POST_PE * post installation tasks
  if exist %PROJECT_BASEDIR%\OEM_POST_PE.CMD (
     copy %PROJECT_BASEDIR%\OEM_POST_PE.CMD %TEMP%\OEM_POST_PE_%ca8%.CMD
     %BMPATCH% %PROJECT_BASEDIR%\OEM_POST_PE.CMD %TEMP%\OEM_POST_PE_%ca8%.CMD %CLIENT_VARFILE%
     %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_PROJECT.CMD: Run OEM_POST_PE script"
     call %TEMP%\OEM_POST_PE_%ca8%.CMD start
     if not defined DEBUG del %TEMP%\OEM_POST_PE_%ca8%.CMD
  )


  if defined DEBUG (
    start "DEBUG COMMAND SHELL" /min cmd /k
  )

   if defined DEBUG %BMTOOL% /text "Debug Mode<BR><BR>Press ENTER to pause" /wait 5 /key
   if defined DEBUG if "%ERRORLEVEL%" equ "100" pause


rem ************************************************************************************************
rem *** Set the status ID to indicate "next boot from local hard disk"
rem *** Then, reboot
rem ************************************************************************************************

:SetEndID
  Set ERROR=0
  cd /d %PROJECT_BASEDIR%
  call BMA_HARD_DRIVE.CMD SetEndID
  if %ERROR% neq 0 goto FATAL

rem  remove reply structure
  %BMFDISK% -hr \\.\PHYSICALDRIVE0 -f

  if defined DEBUG %BMTOOL% /text "Debug Mode<BR>Reboot system<BR>Press ENTER to pause" /wait 5 /key
  if defined DEBUG if "%ERRORLEVEL%" equ "100" pause

  rem if the client configuration file was stored on the server it mus be deleted
  if exist %TEMP%\%ca8%.var del %TEMP%\%ca8%.var

  %BMTOOL% /shutdown 1 /wait %DISPLAY_TIME% /text "Rebooting - Next boot occurs from local hard disk ..."  
  goto DO_REBOOT
  goto :EOF

rem ************************************************************************************************
rem *** Function section
rem ************************************************************************************************

:ShowDbGMsg
  if "%DEBUG%" NEQ "1" goto :EOF 
  %BMTOOL% /wait 5 /key /text "Debug Mode<BR><BR>Press ENTER to pause"
  if "%ERRORLEVEL%" equ "100" pause
  goto :EOF


rem ************************************************************************************************
rem *** This is the error messages section
rem ************************************************************************************************
:CLIENT_PROTECTED
  SET ERROR_TYPE=PROTECTED
  SET ERROR_MSG="This system is protected aginst reinstall."
  echo.
  echo.
  echo ERROR: Unable to start the installation process.
  echo        This system is protected aginst reinstall.
  echo        Please remove system protection first.
  echo.
  goto FATAL

:ERR_XOPY
  echo.
  echo.
  echo ERROR: Unable to copy operating system files!
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to copy operating system files!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to copy operating system files!"
  goto FATAL


:ERR_CLIENT_VAR
  echo.
  echo.
  echo ERROR: Unable to find client configration file!
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to find client configration file!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to find client configration file!"
  goto FATAL


:ERR_VAR
  echo.
  echo.
  echo ERROR: Unable to build client configration file!
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to build client configration file!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to build client configration file!"
  goto FATAL


:ERR_TOOLS
  SET ERROR_TYPE=TOOLS
  SET ERROR_MSG="One or more of the BootManage Administrator utilities are missing"
  echo.
  echo.
  echo ERROR: One or more of the BootManage Administrator utilities
  echo        are missing in this Windows PE boot image !
  echo.
  goto FATAL


:ERR_UNATTEND
  echo.
  echo.
  echo ERROR: Unable to create or modify the unattend.txt file!
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to create or modify the unattend.txt file!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to create or modify the unattend.txt file!"
  goto FATAL

:ERR_PE
  echo.
  echo.
  echo ERROR: The PE Version does not support the operating system installaton
  echo        PE Version: %WINPE_TYPE%  Type of operating system: %OS_TYPE%
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: The PE Version does not support the operating system installaton"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "       PE Version: %WINPE_TYPE%  Type of operating system: %OS_TYPE%"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: The PE Version does not support the operating system installaton<BR><BR>PE Version: %WINPE_TYPE%  Type of operating system: %OS_TYPE%"
  goto FATAL


:ERR_WINPE_TYPE
  SET ERROR_TYPE=PETYPE
  SET ERROR_MSG="ERROR: The Windows PE type of this boot image could not be detected !"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL

:ERR_SETUPEXE
  echo.
  echo.
  echo ERROR: The Setup file for the Operating system is missing: %1
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: The Setup file for the Operating system is missing: %1"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: The Setup file for the Operating system is missing:<BR><BR>%1"
  goto FATAL

:ERR_WIN
  echo.
  echo.
  echo ERROR: The Setup returns with error: %1
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: The Setup returns with error: %1"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: The Setup returns with error: %1"
  goto FATAL


:FATAL
  color 4f
  echo.
  echo This script cannot continue!
  echo Please contact your network administrator!
  echo.
  echo ERROR > %CLIENT_LOCKFILE%
  echo ERROR - see client log > %CLIENT_STATUSFILE%

:FATAL_LOOP
  %BMTOOL% /wait %DISPLAY_TIME% /text "An error has occurred!<BR><BR>This script cannot continue!<BR><BR>Please contact your network administrator!" /key
  if "%ERRORLEVEL%" equ "100" goto DO_REBOOT
  if exist %CLIENT_LOCKFILE% goto FATAL_LOOP

:DO_REBOOT
  %BMTOOL% /shutdown 1 /wait %DISPLAY_TIME% /text "Rebooting ..."
EXIT

:END
exit 