echo on
rem @echo off
if "%1" NEQ "" goto %1

rem ************************************************************************************************
rem *** BMA_WINPE_PROJECT.CMD for WIM image deployment v1.6 2012-01-18
rem ***
rem *** This is BMA_WINPE_PROJECT.CMD, the control script for Windows PE driven projects.
rem *** It is called from the BMA_WINPE_INIT.CMD script in the Windows PE Boot Image.
rem *** Each BMA project has an individual BMA_WINPE_PROJECT.CMD file.
rem ************************************************************************************************

  set OS_TYPE=x86
  SET COPYCMD=/Y
  REM SET DEBUG=1
  
rem ************************************************************************************************
rem *** Determine what Windows PE type we are running on
rem *** (Windows PE 32-Bit x86 / Windows PE 64-Bit x64 / BartPE 32-Bit x86)
rem ************************************************************************************************

  echo.
  echo Determining Windows PE type ...
  set WINPE_TYPE=
  if /i "%PROCESSOR_ARCHITECTURE%" equ "x86"   set WINPE_TYPE=WINPE32
  if /i "%PROCESSOR_ARCHITECTURE%" equ "AMD64" set WINPE_TYPE=WINPE64
  if exist %SystemRoot%\system32\bartpe.exe    set WINPE_TYPE=BARTPE32
  if not defined WINPE_TYPE goto ERR_WINPE_TYPE
  goto %WINPE_TYPE%
  goto END


rem *** We are running on Windows PE 32-Bit x86
:WINPE32
  echo   Windows PE 32-Bit x86 (WINPE32)
  set TOOLNAMES=bmcfg32.* bmpatch32.* bmddm32.* bmfdc32.* bmpcgrp32.* bmscan32.*

  set BMCFG=bmcfg32
  set BMPATCH=bmpatch32
  set BMDDM=bmddm32
  set BMDFC=bmdfc32
  set BMPCGRP=bmpcgrp32
  set BMSCAN=bmscan32

rem *** You may add Windows PE 32-Bit x86 specific stuff here
  goto CHECK_TOOLS


rem *** We are running on Windows PE 64-Bit x64
:WINPE64
  echo   Windows PE 64-Bit x64 (WINPE64)
  set TOOLNAMES=bmcfg64.* bmpatch64.* bmddm64.* bmfdc64.* bmpcgrp64.* bmscan64.*

  set BMCFG=bmcfg64
  set BMPATCH=bmpatch64
  set BMDDM=bmddm64
  set BMDFC=bmdfc64
  set BMPCGRP=bmpcgrp64
  set BMSCAN=bmscan64
rem *** You may add other Windows PE 64-Bit x64 specific stuff here
  goto CHECK_TOOLS


rem *** We are running on BartPE 32-Bit x86
:BARTPE32
  echo   BartPE 32-Bit x86 (BARTPE32)
  set TOOLNAMES=bmcfg32.* bmpatch32.* bmddm32.* bmfdc32.* bmpcgrp32.* bmscan32.*

  set BMCFG=bmcfg32
  set BMPATCH=bmpatch32
  set BMDDM=bmddm32
  set BMDFC=bmdfc32
  set BMPCGRP=bmpcgrp32
  set BMSCAN=bmscan32
rem *** You may add BartPE 32-Bit x86 specific stuff here



rem ************************************************************************************************
rem *** Check if the required BootManage Administrator tools are available
rem ************************************************************************************************

:CHECK_TOOLS
  echo.
  echo Checking for BootManage Administrator utilities ...
  for %%A in (%TOOLNAMES%) do (
    if defined DEBUG echo   %TOOLDIR%\%%A
    if not exist %PROJECT_BASEDIR%\tools\%%A goto ERR_TOOLS
  )
  echo   All required utilities are present
  set TOOLNAMES=

rem ************************************************************************************************
rem *** Set color to white characters on dark green background
rem ************************************************************************************************

  color 27


rem ************************************************************************************************
rem *** Installation over Windows PE
rem ************************************************************************************************

  echo.
  echo Starting OS deployment over Windows PE ...
  %BMTOOL% /wait %DISPLAY_TIME% /text "Starting OS deployment ..."
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Starting OS deployment ..."
  echo Starting OS deployment > %CLIENT_STATUSFILE%



rem ************************************************************************************************
rem *** Convert required configuration parameters to environment variables
rem *** Avoid to simply import all available configuration parameters using %BMUTIL% -S
rem *** because this may cause 'set' errors with values that contain special characters
rem *** (pipe, less_than, greater_than, ampersant)
rem ***
rem *** The following parameters are required:
rem ***   t129  Boot loader condition string
rem ***   t158  System partition size
rem ***   t159  System partition file system type
rem ***   t161  Data partition size
rem ***   t167  Data partition file system type
rem ***
rem *** If you need to import additional parameters as environment variables, add them here!
rem *** Note that you can also use #@ tags within this script
rem ************************************************************************************************

  echo.
  echo Obtaining required configuration parameters ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Obtaining required configuration parameters ..."

rem *** Dump the in-memory configuration parameters to a temporary file
  if not defined t129 %BMUTIL% -s t129 > %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t158 %BMUTIL% -s t158 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t159 %BMUTIL% -s t159 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t161 %BMUTIL% -s t161 >> %TEMP%\%BMA_MAC12%_env.cmd
  if not defined t167 %BMUTIL% -s t167 >> %TEMP%\%BMA_MAC12%_env.cmd

rem *** Import the configuration parameters as environment variables
  call %TEMP%\%BMA_MAC12%_env.cmd

  rem create new logfile structure
  if not exist %BMNEWPCDIR%\log\%ca8%\nul mkdir %BMNEWPCDIR%\log\%ca8% 
  if not exist %BMNEWPCDIR%\log\%ca8%\temp\nul mkdir %BMNEWPCDIR%\log\%ca8%\temp
  if not exist %BMNEWPCDIR%\log\%ca8%\drv\nul mkdir %BMNEWPCDIR%\log\%ca8%\drv
  if not exist %BMNEWPCDIR%\log\%ca8%\logfiles\nul mkdir %BMNEWPCDIR%\log\%ca8%\logfiles

  if not defined CLIENT_LOGFILE set CLIENT_LOGFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.log
  if not defined CLIENT_LOCKFILE=CLIENT_LOCKFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.lck
  if not defined CLIENT_STATUSFILE=set CLIENT_STATUSFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.sta
  if not defined CLIENT_VARFILE set CLIENT_VARFILE=%BMNEWPCDIR%\config\%BMA_MAC8%.var


rem ************************************************************************************************
rem *** Check if this client is protected aginst reinstall. In this case,
rem *** the BMA_WINPE_PROJECT must stop the current installation.
rem ************************************************************************************************
 if exist %BMNEWPCDIR%\locked\%BMA_MAC12%.lck goto CLIENT_PROTECTED


rem ************************************************************************************************
rem *** Store OPT and VAR configuration in one file 
rem ************************************************************************************************
  echo.
  echo Store OPT and VAR configuration in one file
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_PROJECT.CMD: Store OPT and VAR configuration in one file"

::if defined CFG_SOURCE if "%CFG_SOURCE%" equ "TFTP" goto OEM_PRE_PE


set CLIENT_VAR=%TEMP%\%ca8%.var
if not exist %CLIENT_VAR% (
   if exist %CLIENT_VAR% del %CLIENT_VAR%
    rem File deleted? file rights ok? 
    if exist %CLIENT_VAR% goto ERR_VAR
    echo. > %CLIENT_VAR%
    if not exist %CLIENT_VAR% goto ERR_VAR
)

rem *** Found disk space
  del %CLIENT_VAR%
  if exist %CLIENT_VAR%.TMP del %CLIENT_VAR%.TMP

rem *** Build OPT structure
  echo. > %CLIENT_VAR%.dat
  for /L %%A in (129,1,254) do echo t%%A = ^"#@t%%A@#^">>%CLIENT_VAR%.TMP
  echo ca8 = ^"%ca8%^">>%CLIENT_VAR%.TMP
  echo caa = ^"%caa%^">>%CLIENT_VAR%.TMP
  echo BMA_MAC8 = ^"%BMA_MAC8%^">>%CLIENT_VAR%.TMP
  echo BMA_MAC12 = ^"%BMA_MAC12%^">>%CLIENT_VAR%.TMP
  copy %CLIENT_VAR%.TMP %CLIENT_VAR% 
REM  %BMPATCH% %CLIENT_VAR%.TMP %CLIENT_VAR% %CLIENT_VAR%.dat
  %BMPATCH% %CLIENT_VAR%.TMP %CLIENT_VAR% %CLIENT_VARFILE%

rem *** Update empty fields
  for /L %%A in (129,1,254) do echo t%%A = ^"^">>%CLIENT_VAR%.dat
  copy %CLIENT_VAR% %CLIENT_VAR%.TMP
  %BMPATCH% %CLIENT_VAR% %CLIENT_VAR%.TMP %CLIENT_VAR%.dat

rem *** Change Client VAR file
  copy %CLIENT_VARFILE% + %CLIENT_VAR%.tmp %CLIENT_VAR%
  SET CLIENT_VARFILE=%CLIENT_VAR%
  del %CLIENT_VAR%.dat
  del %CLIENT_VAR%.TMP
  set CLIENT_VAR=

rem ************************************************************************************************
rem *** Make the OS base directory the current working directory
rem ************************************************************************************************

  cd /d %PROJECT_BASEDIR%
  set PATH=%PATH%;%PROJECT_BASEDIR%\tools

  echo.
  echo The desired partitioning scheme is:
  %BMTOOL% /log %CLIENT_LOGFILE% /L "The desired partitioning scheme is:"


rem ************************************************************************************************
rem *** Create / check harddisk structure
rem ************************************************************************************************

  Set ERROR=0
  call BMA_HARD_DRIVE.CMD start
  if %ERROR% neq 0 goto FATAL

  if defined DEBUG (
    %BMTOOL% /wait 10 /key /text  [debug mode] Create / check harddisk structure finished. press OK to pause
  )  
  if defined DEBUG if "%ERRORLEVEL%" neq "0" pause


rem ************************************************************************************************
rem *** Set default commandline parameters for OS deploying
rem *** 
rem ************************************************************************************************

  if not exist s:\NUL goto ERR_LOCAL_SETUP_PART

  echo Deploying Helper image - this will take some time ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Deploying Helperimage ..."
  echo Deploying helper image > %CLIENT_STATUSFILE%

  xcopy SERVICE_PART\*.* s:\. /s /e 
  if "%ERRORLEVEL%" GTR "0" goto ERR_XCOPY

rem ************************************************************************************************
rem *** Add bootsect NT60 to s:
rem ************************************************************************************************

::  set BOOTCODE=none
::  if exist c:\ntldr set BOOTCODE=nt52
::  if exist c:\bootmgr set BOOTCODE=nt60

set BOOTCODE=nt60
bootsect.exe /%BOOTCODE% S:


rem *********************************************************** 
rem *** add bootix scripts and tools to local Servcie partition
rem *********************************************************** 
  cd /d %PROJECT_BASEDIR%
  
  mkdir s:\BMA\
  copy %CLIENT_VARFILE% S:\BMA\config.var

  mkdir s:\BMA\tools
  xcopy tools\*.* s:\BMA\tools /s /e 


  if exist "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var" (
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var" c:\BMA\config.var
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var" c:\BMA\%ca8%.var
  )


  if exist  "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt" (
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt" c:\BMA\config.opt
    copy "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt" c:\BMA\%ca8%.opt
  )


:test
rem ************************************************************************************************
rem *** Copy and Patch all files stored in scripts
rem ************************************************************************************************
   echo Individualize scripts
   for /R scripts\ %%i in (*) do call :Patch_And_Copy %%i
   copy  s:\BMA\Startnet.cmd s:\minint\system32\startnet.cmd >NUL


rem ************************************************************************************************
rem *** Add Driver to s:
rem ************************************************************************************************
   call BMA_DRIVER.CMD start
   xcopy s:\drv\pnp s:\Drivers\. /s /e

rem ************************************************************************************************
rem *** set end id. Next reboot from local HD
rem ************************************************************************************************
  echo call BMA_HARD_DRIVE.cmd SetEndID
  call BMA_HARD_DRIVE.cmd SetEndID
rem  start /min cmd
  echo Next boot: local
  ::pause
  exit 0
  goto END

goto :EOF
rem *+++++++++++++++++++++++++++++++++
rem *++ Funktionen 
rem *+++++++++++++++++++++++++++++++++

rem ************************************************************************************************
rem ::  Copy and Patch all files stored in scripts
rem ::  File with Path: %1
rem ::  Drive:          %~d1
rem ::  Path only:      %~p1
rem ::  Drive and Path: %~dp1
rem ::  File extension: %~x1
rem ::  File name:      %~n1
rem ::  File and ext.:  %~nx1
rem ************************************************************************************************
:Patch_And_Copy
  copy "%1" "s:\bma\%~nx1" > NUL
  copy "%1" "s:\bma\%~nx1.raw" > NUL
  :: echo %bmpatch% "%1" "s:\bma\%~nx1" %CLIENT_VARFILE%
  %bmpatch% "%1" "s:\bma\%~nx1" %CLIENT_VARFILE%
  goto :EOF


rem ************************************************************************************************
rem *** This is the error messages section
rem ************************************************************************************************
:ERR_XCOPY
  echo.
  echo.
  echo ERROR: Unable to copy installation sources to drive S
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to copy installation sources to drive S"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to copy installation sources to drive S"
  goto FATAL

:ERR_LOCAL_SETUP_PART
  echo.
  echo.
  echo ERROR: Unable to find a local setup partition (Drive S)!
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to find a local setup partition (Drive S)!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to find a local setup partition (Drive S)!"
  goto FATAL


:ERR_ID_VALUES
  echo.
  echo.
  echo ERROR: Unable to determine start and end ID values for the status partition!
  echo.       Check configuration information!
  echo.
  echo        t129 = "%t129%"
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Unable to determine start and end ID values for the status partition!"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "       Check configuration information!"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "       t129 = '%t129%'"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Unable to determine start and end ID values for the status partition!"
  goto FATAL


rem ************************************************************************************************
rem *** This is the error messages section
rem ************************************************************************************************
:CLIENT_PROTECTED
  SET ERROR_TYPE=PROTECTED
  SET ERROR_MSG="This system is protected aginst reinstall."
  echo.
  echo.
  echo ERROR: Unable to start the installation process.
  echo        This system is protected aginst reinstall.
  echo        Please remove system protection first.
  echo.
  goto FATAL


:FATAL
  color 4f
  echo.
  echo This script cannot continue!
  echo Please contact your network administrator!
  echo.
  echo ERROR > %CLIENT_LOCKFILE%
  echo ERROR - see client log > %CLIENT_STATUSFILE%

:FATAL_LOOP
  %BMTOOL% /wait %DISPLAY_TIME% /text "An error has occurred!<BR><BR>This script cannot continue!<BR><BR>Please contact your network administrator!" /key
  if "%ERRORLEVEL%" equ "100" goto END
  if exist %CLIENT_LOCKFILE% goto FATAL_LOOP
  %BMTOOL% /shutdown 1 /wait %DISPLAY_TIME% /text "Rebooting ..."



:END

