@echo off
cd /D %~Dp0

set APP_PATH=%~dp0
:: cut last \
set APP_PATH=%APP_PATH:~0,-1%

::
:: Set Environment Parameter
SET "DIR_WAIK=c:\Program Files\Windows AIK"
SET "DIR_PETools=%DIR_WAIK%\Tools\PETools"
SET "DIR_PE_TEMP=c:\BMA_USB_PE\X86"
SET "DIR_PE_ISO=c:\BMA_USB_PE\ISO"
SET "DIR_PE_USB_TOOLS=%APP_PATH%"
SET "DIR_PE_ADD_DRIVER=%DIR_PE_USB_TOOLS%\ADD_DRIVER"
SET "DIR_PE_ADD_FILES=%DIR_PE_USB_TOOLS%\ADD_FILES"
SET "DIR_PE_ADD_USB_FILES=%DIR_PE_USB_TOOLS%\ADD_USB"

:: Check Temporary Directory
echo Check Temporary Directory
if exist "%DIR_PE_TEMP%\" goto ERR_DIRPE
echo Temporary directory did not exits... OK

:: Check PE Tool Directory
echo Seek AIK Tools 
if not exist "%DIR_PETools%\copype.cmd" goto ERR_AIK
echo Windows AIK folder exist... OK

:: Seek USB Device
echo Seek USB Destination
SET "USB_DETECT_DRIVE="
for /f "delims=" %%A in ('cscript //nologo INIT_USB_STICK.vbs') do %%A
if not defined USB_DETECT_DRIVE goto ERR_USB
ECHO Destination found (%USB_DETECT_DRIVE%)... OK

:: Build temporary file structure
echo Build temporary file structure

cd /D %DIR_PETools%

call "copype.cmd" x86 %DIR_PE_TEMP% >NUL

cd /D %APP_PATH%

if not exist "%DIR_PE_TEMP%\winpe.wim" goto ERR_IMG


:: Clean all mounted DISM resources
DISM /Cleanup-Wim

echo Mount PE-Image
Dism.exe /mount-wim /wimfile:"%DIR_PE_TEMP%\winpe.wim" /index:1 /mountdir:"%DIR_PE_TEMP%\mount"
if "%ERRORLEVEL%" neq "0" goto ERR_MOUNT
echo Image mounted... OK

echo Add WIM support into boot image
Dism /image:"%DIR_PE_TEMP%\mount" /Add-Package /PackagePath:"%DIR_PETools%\x86\WinPE_FPs\winpe-wmi.cab"
set ERR_RET=%ERRORLEVEL%
if "%ERR_RET%" neq "0" (
  echo Add WIM support return: %ERR_RET%
) else (
  echo Add WIM support... OK
)

Dism /image:"%DIR_PE_TEMP%\mount" /Add-Package /PackagePath:"%DIR_PETools%\x86\WinPE_FPs\en-us\winpe-wmi_en-us.cab"
set ERR_RET=%ERRORLEVEL%
if "%ERR_RET%" neq "0" (
  echo Add WIM language files return: %ERR_RET%
) else (
  echo Add WIM language files... OK
)

echo Add scripting support into boot image
Dism /image:"%DIR_PE_TEMP%\mount" /Add-Package /PackagePath:"%DIR_PETools%\x86\WinPE_FPs\winpe-scripting.cab"
set ERR_RET=%ERRORLEVEL%
if "%ERR_RET%" neq "0" (
  echo Add scripting support return: %ERR_RET%
) else (
  echo Add scripting support... OK
)

Dism /image:"%DIR_PE_TEMP%\mount" /Add-Package /PackagePath:"%DIR_PETools%\x86\WinPE_FPs\en-us\winpe-scripting_en-us.cab"
if "%ERR_RET%" neq "0" (
  echo Add scripting language files return: %ERR_RET%
) else (
  echo Add scripting language files... OK
)

echo Add driver into boot image
dism /image:"%DIR_PE_TEMP%\mount" /add-driver /driver:"%DIR_PE_ADD_DRIVER%" /recurse
set ERR_RET=%ERRORLEVEL%
if "%ERR_RET%" neq "0" (
  echo Add driver function return: %ERR_RET%
) else (
  echo Add driver... OK
)

echo Add additional files
xcopy "%DIR_PE_ADD_FILES%\*.*" "%DIR_PE_TEMP%\mount" /y /s /e >NUL
set ERR_RET=%ERRORLEVEL%
if "%ERR_RET%" neq "0" (
  echo Add additional files return: %ERR_RET%
) else (
  echo Add additional files... OK
)


echo Commit changes 
Dism /unmount-wim /Mountdir:"%DIR_PE_TEMP%\mount" /commit
if "%ERRORLEVEL%" neq "0" goto ERR_COMMIT
echo Image unmounted... OK

copy "%DIR_PE_TEMP%\winpe.wim" "%DIR_PE_TEMP%\ISO\sources\boot.wim" /Y
copy "%DIR_WAIK%\Tools\x86\imagex.exe" "%DIR_PE_TEMP%\ISO\" /Y

:: Copy Windows PE to USB stick
echo Copy Windows PE to USB stick
xcopy %DIR_PE_TEMP%\iso\*.* %USB_DETECT_DRIVE%\ /y /e /s 

:: Copy addtional files to USB stick
echo Copy addtional files to USB stick
xcopy %DIR_PE_ADD_USB_FILES%\*.* %USB_DETECT_DRIVE%\ /y /e /s 

echo Build ISO Image 
mkdir %DIR_PE_ISO%
oscdimg -n -b"%DIR_PE_TEMP%\etfsboot.com" "%DIR_PE_TEMP%\ISO" "%DIR_PE_ISO%\winpe-x86.iso"

if exist "%DIR_PE_ISO%\winpe-x86.iso" (
  echo. 
  echo *************************************************
  echo ISO file is present. ^"%DIR_PE_ISO%\winpe-x86.iso^"
  echo *************************************************
  echo.
)

echo Clean temporary directory
:: protect
if /I "%DIR_PE_TEMP%" EQU "C:\" goto :EOF
if /I "%DIR_PE_TEMP%" EQU "C:" goto :EOF
if /I "%DIR_PE_TEMP%" EQU "C:\WINDOWS" goto :EOF
if /I "%DIR_PE_TEMP%" EQU "C:\WINDOWS\" goto :EOF
rmdir /S /Q "%DIR_PE_TEMP%"

  echo.
  echo.
  echo USB installation finished.
  echo ==========================
  echo.

pause
goto :EOF


rem *********************
rem ******* ERROR Handler
rem *********************

:ERR_COMMIT
echo ERROR: Can't unmount WIM Image
echo    Please rebuild temporary files 
echo.
Dism /unmount-wim /Mountdir:"%DIR_PE_TEMP%\mount" /Discard
:: Clean all mounted DISM resources
DISM /Cleanup-Wim
pause
goto :EOF

:ERR_MOUNT
echo ERROR: Can't Mount WIM Image
echo    Please rebuild temporary files 
echo.
Dism /unmount-wim /Mountdir:"%DIR_PE_TEMP%\mount" /Discard
:: Clean all mounted DISM resources
DISM /Cleanup-Wim
pause
goto :EOF

:ERR_IMG
echo ERROR: WIM Image missing
echo    Please rebuild temporary files 
echo.
pause
goto :EOF

:ERR_USB
echo ERROR: No empty USB Device found.
echo    Please create a file named BMA_BOOT_STICK.TXT on the USB destination
echo    or delete all files on existing and well formated USB stick.
echo.
pause
goto :EOF

:ERR_AIK
echo ERROR: Windows AIK is missing
echo    Folder: %DIR_PETools% missing
echo.
pause
goto :EOF

:ERR_DIRPE
echo ERROR: Temporary PE Folder found
echo    Please delete %DIR_PE_TEMP% first.
echo.
pause
goto :EOF
