echo off
:: set APP_DIR to the directory of this script 
set "APP_PATH=%~Dp0"
:: remove last backslash from path
set "APP_PATH=%APP_PATH:~0,-1%"

:: Default Settings
SET "BMA_DEPLOY_USERNAME=BMA_DEPLOY"
SET "BMA_DEPLOY_PASSWORD=bootix!123"
SET "BMA_ADMIN_USERNAME=BMA_ADMIN"
SET "BMA_ADMIN_PASSWORD=bootix!123"
SET "BMA_OSDEPOT_SHARE=OSDEPOT"
SET "BMA_OSDEPOT_PATH=C:\OSDEPOT"
SET "BMA_TFTPBOOT_SHARE=TFTPBOOT"
SET "BMA_TFTPBOOT_PATH=C:\TFTPBOOT"
if /I "%1" EQU "LOAD_SETTINGS" goto :EOF

cls
echo.
echo ################################################
echo #
echo # Server Preperation
echo #
echo # Basic configuration for a BMA Depot Server
echo #
echo ################################################
echo.
pause

cls
echo.
echo ################################################
echo #
echo # Install File and Storage Services
echo #
echo ################################################
echo.
if exist %SystemRoot\system32\servermanagercmd.exe (
    echo Install File-Services please wait....
    echo. 
    start /wait servermanagercmd.exe -install File-Services -restart
    echo.
    echo File-Services installed
)

if not exist %SystemRoot\system32\servermanagercmd.exe (
  cls
  echo.
  echo ################################################
  echo #
  echo # Please start the Server Manager and 
  echo # Install File and Storage Services Manually
  echo #
  echo ################################################
  echo.
)

pause
cls
echo.
echo ################################################
echo #
echo # Creating Shares, Users and Groups
echo #
echo ################################################
echo #
echo # Deployment User for Helper Operating System
echo #   username: %BMA_DEPLOY_USERNAME%
echo #   password: %BMA_DEPLOY_PASSWORD%
echo #
echo # Share Names
echo #   DEPOT: %BMA_OSDEPOT_SHARE%
echo #   TFTPBOOT: %BMA_TFTPBOOT_SHARE%
echo #
echo ################################################
echo.
pause
echo Add Users...
net user "%BMA_DEPLOY_USERNAME%" "%BMA_DEPLOY_PASSWORD%" /add
net user "%BMA_ADMIN_USERNAME%" "%BMA_ADMIN_PASSWORD%" /add /y
net user "%BMA_DEPLOY_USERNAME%" /COMMENT:"Deployment User in Helper OS"
net user "%BMA_ADMIN_USERNAME%" /COMMENT:"Admin with access to OS-DEPOT"

echo Create Users Groups...
net localgroup BMA_Administrators /add
net localgroup BMA_Administrators /COMMENT:"Member of this group have access to local BMA"
net localgroup BMA_Administrators %BMA_ADMIN_USERNAME% /add
net localgroup BMA_Administrators Administrator /add

echo Set User Parameter Password Never Expires...
WMIC USERACCOUNT WHERE "Name='%BMA_DEPLOY_USERNAME%'" SET PasswordExpires=FALSE
WMIC USERACCOUNT WHERE "Name='%BMA_ADMIN_USERNAME%'" SET PasswordExpires=FALSE

echo Create Folder Structure...
mkdir %BMA_OSDEPOT_PATH%
mkdir %BMA_OSDEPOT_PATH%\$BmNewPC.dir
mkdir %BMA_TFTPBOOT_PATH%

echo Share Folders ....
net share %BMA_OSDEPOT_SHARE%=%BMA_OSDEPOT_PATH% /GRANT:%BMA_DEPLOY_USERNAME%,FULL /GRANT:BMA_Administrators,FULL /GRANT:Administrator,FULL /grant:Administrators,FULL
net share %BMA_TFTPBOOT_SHARE%=%BMA_TFTPBOOT_PATH% /GRANT:BMA_Administrators,FULL /GRANT:Administrator,FULL /grant:Administrators,FULL

echo Configure NTFS rights 
::icacls %BMA_TFTPBOOT_PATH% /grant %BMA_DEPLOY_USERNAME%:(CI)(OI)(M)
icacls %BMA_OSDEPOT_PATH% /grant %BMA_DEPLOY_USERNAME%:(CI)(OI)(M)
icacls %BMA_OSDEPOT_PATH%\$BmNewPC.dir /grant %BMA_DEPLOY_USERNAME%:(CI)(OI)(M)
icacls %BMA_TFTPBOOT_PATH% /grant %BMA_ADMIN_USERNAME%:(CI)(OI)(F)
icacls %BMA_OSDEPOT_PATH% /grant %BMA_ADMIN_USERNAME%:(CI)(OI)(F)

echo.
echo Finished....
pause

