option explicit
  Const DEBUG_LEVEL=0
  Const OPEN_FILE_APPENDING = 8
  DIM SCRIPT_NAME
  DIM APP_PATH
  DIM DATA_DIR
  DIM USB_DAT
  dim LOG_FILE
  Dim objFSO
  dim strComputer
  dim USB_DATA, USB_DRV
  dim objShell, objExec, ERROR_LOG_FILE
  
  Set objFSO = CreateObject("Scripting.FileSystemObject") 
  APP_PATH = objFSO.GetParentFolderName(wscript.ScriptFullName) 
  SCRIPT_NAME = ucase(wscript.ScriptName)
  LOG_FILE = APP_PATH & "\" & SCRIPT_NAME & "_DBG.log"
  ERROR_LOG_FILE = APP_PATH & "\" & SCRIPT_NAME & "_ERR.log"
  LOG_FILE = ""
  ERROR_LOG_FILE = ""
  strComputer = "."

  
Function ConfDevData(DiskPart)
  dim DISK, PART
  dim l, p
  ConfDevData = chr(0)
  l = instr(1,DiskPart,"#")
  p = instr(l,DiskPart,",")
  if l + p = 0 then exit function 
  DISK=mid(DiskPart,l+1,p-l-1)
  l = instr(p+1,DiskPart,"#")
  if l = 0 then exit function 
  PART=trim(mid(DiskPart,l+1))
  ConfDevData = DISK & chr(0) & PART
end Function  
  
  
Function SeekUSBDrive()
dim DiskPart, USB_DRIVE_NAME
dim wmiServices, wmiDiskDrives, wmiDiskDrive, wmiDiskPartitions, wmiDiskPartition
dim strEscapedDeviceID, wmiLogicalDisks,  wmiLogicalDisk
dim lStart
SeekUSBDrive = ""

Set wmiServices = GetObject("winmgmts:{impersonationLevel=Impersonate}!//" & strComputer)
Set wmiDiskDrives = wmiServices.ExecQuery("SELECT Caption, DeviceID FROM Win32_DiskDrive")
 
For Each wmiDiskDrive In wmiDiskDrives
    USB_DRIVE_NAME = wmiDiskDrive.Caption & " (" & wmiDiskDrive.DeviceID & ")"
    strEscapedDeviceID = Replace(wmiDiskDrive.DeviceID, "\", "\\", 1, -1, vbTextCompare)
    Set wmiDiskPartitions = wmiServices.ExecQuery ("ASSOCIATORS OF {Win32_DiskDrive.DeviceID=""" & strEscapedDeviceID & """} WHERE AssocClass = Win32_DiskDriveToDiskPartition")
    For Each wmiDiskPartition In wmiDiskPartitions
        DiskPart =  wmiDiskPartition.DeviceID
        'WScript.Echo "DiskPartID: " & wmiDiskPartition.DeviceID
        Set wmiLogicalDisks = wmiServices.ExecQuery ("ASSOCIATORS OF {Win32_DiskPartition.DeviceID=""" & wmiDiskPartition.DeviceID & """} WHERE AssocClass = Win32_LogicalDiskToPartition")
         For Each wmiLogicalDisk In wmiLogicalDisks
		  if objFSO.FileExists (wmiLogicalDisk.DeviceID & "\BMA_BOOT_STICK.TXT") then 
			SeekUSBDrive = USB_DRIVE_NAME & chr(0) & wmiLogicalDisk.DeviceID & chr(0) & ConfDevData(DiskPart)
		  end if	
        Next
    Next
Next
End Function

'/****************************************
'*  Folder Is Empty 
'*****************************************
Function FolderIsEmpty(FolderName) 
	Dim objFSO, objFolder
	Set objFSO = CreateObject("Scripting.FileSystemObject")

	If objFSO.FolderExists(FolderName) Then
		Set objFolder = objFSO.GetFolder(FolderName)
		If objFolder.Files.Count = 0 And objFolder.SubFolders.Count = 0 Then
			FolderIsEmpty = true
		Else
			FolderIsEmpty = false
		End If
	End If
end Function

'/*******************************************************
'* Function FileExist
'*******************************************************/
Function FileExist(FileName)
 DIM fso    
 Set fso = CreateObject("Scripting.FileSystemObject")
 If (fso.FileExists(FileName)) Then
   FileExist=true
 Else
   FileExist=false
 End If
end Function

'/*******************************************************
'* Function AppendFile
'*******************************************************/
Function AppendFile(FileName, strBuffer)
  Dim fso, FileOut
  Set fso     = CreateObject("Scripting.FileSystemObject")
  Set FileOut = fso.OpenTextFile (FileName, OPEN_FILE_APPENDING, true)
      FileOut.WriteLine (strBuffer)
      FileOut.Close
  Set FileOut = Nothing
  Set fso     = Nothing
 End Function

'/*******************************************************
'* Function Str2Int
'*******************************************************/
Function Str2Int(strBuffer)
  if IsNumeric(strBuffer) = true then 
     str2Int = clng(strBuffer)
  Else
     str2Int = -1
  End If
End Function 

'/*******************************************************
'* Function MakeDir
'*******************************************************/
Function MakeDir (strPath)
  Dim strParentPath, objFSO
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  On Error Resume Next
  strParentPath = objFSO.GetParentFolderName(strPath)

  If Not objFSO.FolderExists(strParentPath) Then MakeDir strParentPath
        If Not objFSO.FolderExists(strPath) Then objFSO.CreateFolder strPath
        On Error Goto 0
  MakeDir = objFSO.FolderExists(strPath)
End Function

'*****************************************************
' Optional Sort Array
'*****************************************************
Function SortArray(ArrayIn) 
  Dim oArrayList, iElement, oArrayDic
  Set oArrayDic = CreateObject("Scripting.Dictionary")
  Set oArrayList = CreateObject( "System.Collections.ArrayList" )
   For iElement = 0 To UBound(ArrayIn)
    oArrayList.Add ArrayIn(iElement)
   Next
  oArrayList.Sort
  set SortArray = oArrayList
  For iElement = 0 To UBound(ArrayIn)
    ArrayIn(iElement) = oArrayList(iElement)
  Next
 End Function 

'/*******************************************************
'* Function ConvertTime
'*******************************************************/
Function ConvertTime(DateTimeValue)
	' YYYY-MM-DDTHH:MM:SS 
	Dim strTime
	strTime = year(DateTimeValue) & "-"
	strTime = strTime & Right("0" & Month(DateTimeValue), 2) & "-"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2) & " "
	strTime = strTime & Right("0" & Hour(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Minute(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2)
	ConvertTime = strTime
End Function


'/*******************************************************
'* Function Error Out
'*******************************************************/
Function ErrorOut(sBuffer)
    if ERROR_LOG_FILE <> "" then AppendFile ERROR_LOG_FILE, ConvertTime(now()) & " ERROR: " & sBuffer 
	DebugOut "ERROR: " & sBuffer
End Function

'/*******************************************************
'* Function Debug Out
'*******************************************************/
Function DebugOut(sBuffer)
    if LOG_FILE <> "" then AppendFile LOG_FILE, ConvertTime(now()) & " " & sBuffer 
    if DEBUG_LEVEL = 0 then exit Function
    WScript.StdOut.WriteLine "::" & ConvertTime(now()) & " " & sBuffer 
End Function

'/*******************************************************
'* #1 Function Split File Name FileFolderAndExtension
'*******************************************************/
Public Function FileFolderAndExtension(ByVal sFilePath , retFolder , retFile , retExtension , retFileWithExtension ) 
  Dim i 
  sFilePath = Trim(sFilePath)
  i = InStrRev(sFilePath, "\")
  If i > 0 Then
    retFolder = Mid(sFilePath, 1, i)
    sFilePath = Mid(sFilePath, i + 1)
  End If
  i = InStrRev(sFilePath, ".")
  If i > 0 Then
     retExtension = Mid(sFilePath, i + 1)
     sFilePath = Mid(sFilePath, 1, i - 1)
  End If
  retFile = sFilePath
  if (retExtension <> "") then
    retFileWithExtension = retFile & "." & retExtension
  else
    retFileWithExtension = retFile
  end if
End Function

'/*******************************************************
'* #2 Function Split File Name FileWithoutExtension
'*******************************************************/
Public Function FileWithoutExtension(sFilePath ) 
   FileFolderAndExtension sFilePath, "", FileWithoutExtension, "", ""
End Function

'/*******************************************************
'* #3 Function Split File Name FileWithExtension
'*******************************************************/
Public Function FileWithExtension(sFilePath ) 
   FileFolderAndExtension sFilePath, "", "", "", FileWithExtension
End Function

'/*******************************************************
'* #4 Function Split File Name FileExtension
'*******************************************************/
Public Function FileExtension(sFilePath ) 
   FileFolderAndExtension sFilePath, "", "", FileExtension, ""
End Function

'/*******************************************************
'* #5 Function Split File Name FileFolder
'*******************************************************/
Public Function FileFolder(ByVal sFilePath ) 
  FileFolderAndExtension sFilePath, FileFolder, "", "", ""
End Function


'/*******************************************************
'* Execute Diskpart 
'/*******************************************************
Function ExecuteDiskPartCommand (strCommand)
    dim IgnoreThis
    objExec.StdIn.Write strCommand & VbCrLf
    Do While True
        IgnoreThis = objExec.StdOut.ReadLine & vbcrlf
        If InStr(IgnoreThis, "DISKPART>") <> 0 Then Exit Do
    Loop
    objExec.StdIn.Write VbCrLf
    ExecuteDiskPartCommand = ""
    Do While True
        ExecuteDiskPartCommand = ExecuteDiskPartCommand & objExec.StdOut.ReadLine & vbcrlf
        If InStr(ExecuteDiskPartCommand, "DISKPART>") <> 0 Then Exit Do
    Loop
End Function

Sub ExitDiskPart
    ' Run exit command to exit the tool
    objExec.StdIn.Write "exit" & VbCrLf
End Sub

Sub FormatUSB(SelDisk)
    dim strOutput
	set objShell = WScript.CreateObject("WScript.Shell")
	set objExec = objShell.Exec("diskpart.exe")
	strOutput = ExecuteDiskPartCommand("SEL DISK " & SelDisk)
	'DebugOut replace (strOutput, vbcrlf , "; ")
	strOutput = ExecuteDiskPartCommand("CLEAN")
	'DebugOut replace (strOutput, vbcrlf , "; ")
	strOutput = ExecuteDiskPartCommand("create partition primary")
	'DebugOut replace (strOutput, vbcrlf , "; ")
	strOutput = ExecuteDiskPartCommand("select partition 1")
	'DebugOut replace (strOutput, vbcrlf , "; ")
	strOutput = ExecuteDiskPartCommand("active")
	'DebugOut replace (strOutput, vbcrlf , "; ")
	strOutput = ExecuteDiskPartCommand("format quick fs=fat32 label=BMA_BOOT")
	'DebugOut replace (strOutput, vbcrlf , "; ")
	strOutput = ExecuteDiskPartCommand("assign")
	'DebugOut replace (strOutput, vbcrlf , "; ")
	ExitDiskPart
	DebugOut "OK"
	set objShell = nothing
	set objExec = nothing
end Sub


'/*******************************************************
'* Main
'*******************************************************/
  
USB_DATA = SeekUSBDrive
if USB_DATA <> "" then
  USB_DAT = Split(USB_DATA & chr(0), chr(0))
  DebugOut "USB Device Found: " & USB_DAT(0) 
  DebugOut "Drive: " & USB_DAT(1) & ", PhysicalDrive: " &  USB_DAT(2) & ", Partition: " & USB_DAT(3)
  DebugOut "Format USB Device..." 
  call FormatUSB(USB_DAT(2))
end if

DebugOut "Seek Empty USB Drive..." 
dim objWMIService
dim colDrives, objDrive
USB_DRV = "" 
Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
Set colDrives = objWMIService.ExecQuery ("Select * from Win32_LogicalDisk where VolumeName = 'BMA_BOOT'")
For Each objDrive in colDrives
     'WScript.Echo objDrive.VolumeName 
	 if FolderIsEmpty(objDrive.DeviceID & "\") = true then 
        DebugOut "Valid drive found: " & objDrive.DeviceID
  	    USB_DRV = objDrive.DeviceID 
	 else
       DebugOut "Drive not empty: " & objDrive.DeviceID
     end if 	 
Next
Set objWMIService = nothing
Set colDrives = nothing

if USB_DRV = "" then  
  ErrorOut "NO empty USB Device found! " 
  ErrorOut "Please create a file named BMA_BOOT_STICK.TXT on the USB destination."
  WScript.Echo "SET USB_DETECT_RET_ERROR=NO empty USB Device found!"
  WScript.Echo "SET USB_DETECT_RET_ERRNR=1"
  WScript.Quit 1
end if 

WScript.Echo "SET USB_DETECT_RET_ERRNR=0"
WScript.Echo "SET USB_DETECT_RET_ERROR=0"
WScript.Echo "SET USB_DETECT_DRIVE=" & USB_DRV


