@echo off
rem ************************************************************************************************
rem *** BMA_WINPE_INIT.CMD v1.9 2013-08-21_16:03
rem ***
rem *** BootManage Administrator initialization script for Windows PE
rem ***    determines the unterlying Windows PE type
rem ***    retrieves configuration parameters
rem ***    connects a network drive to the installation server
rem ***    registers new clients
rem ***    determines the assigned project
rem ***    executes the project specific script
rem ***
rem *** The BMA_WINPE_INIT.CMD script must be located (along with the BMA tools) in the SYSTEM32
rem *** directory of the Windows PE boot image, and executed from within Windows PE's STARTNET.CMD.
rem *** For BartPE, use the 'autorun' mechanism instead. In any case, make sure that this script is
rem *** executed as the last action of the WinPE / BartPE boot process.
rem ***
rem *** It is recommended not to make custom modifications to this file. However, if you must do
rem *** this, be sure that you do not disturb vital BootManage Administrator functions.
rem ************************************************************************************************



rem ************************************************************************************************
rem *** Set color to white characters on dark blue background
rem ************************************************************************************************
  color 17



rem ************************************************************************************************
rem *** Check if command processor extensions are enabled.
rem ************************************************************************************************

  set CMDTEST=0
  set /a CMDTEST += 1
  if "%CMDTEST%" neq "1" goto ERR_CMD_EXT
  set CMDTEST=



rem ************************************************************************************************
rem *** The following environment variables define global behaviour, and are also
rem *** used in subsequent scripts. We define default values for them here.
rem ************************************************************************************************

rem *** Debug mode: DEBUG (<undefined> = no debug, <any value> = enable debug mode)
  set DEBUG=

rem *** Message display time in seconds: DISPLAY_TIME (1, 2, 3, ...)
  set DISPLAY_TIME=5

rem *** Default values for the BootManage Administrator tools
rem *** These may be overwritten later in this script, e.g. for Windows PE 64-Bit systems
  set TOOLDIR=%SystemRoot%\system32
  SET BMA_TFTP_SERVER=unset
  SET SET CLIENT_VARFILE=
  SET BMNET_DHCP_OPTION_66=unset
  SET CFG_SOURCE=OPT

rem *** Default error message 
  set ERROR_MSG="An error has occurred!"
  set ERR_NR=0

rem ************************************************************************************************
rem *** Create temp folder on ramdrive
rem ************************************************************************************************
  SET TEMP_RAM=R:\temp
  if not exist %TEMP_RAM%\nul SET TEMP_RAM=X:\temp
  echo   Local temporary directory
  if not exist %TEMP_RAM%\nul mkdir %TEMP_RAM%
  set TESTFILE=%TEMP_RAM%\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE
  echo Log files directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_TESTFILE
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE

  SET BMA_TMPFILE=%TEMP_RAM%\CLIENT.DATA
  SET BMA_OPTFILE=%TEMP_RAM%\OPT.DAT
  if exist %BMA_TMPFILE% del %BMA_TMPFILE%
  if exist %BMA_OPTFILE% del %BMA_OPTFILE%


rem ************************************************************************************************
rem *** As network initialization seems to occur asynchronous to script execution, the network
rem *** interface might not be up and running yet when the factory command returns execution
rem *** control to this script. So, network related commands like connecting a network drive may
rem *** produce errors. The recommended solution by Microsoft is to simply sit and wait a couple
rem *** of seconds. (See the troubleshooting section of the Windows PE help file, winpe.chm)
rem *** So, let's simply add some delays to the following commands.
rem ************************************************************************************************



rem ************************************************************************************************
rem *** Determine what Windows PE type we are running on
rem *** (Windows PE 32-Bit x86 / Windows PE 64-Bit x64 / BartPE 32-Bit x86)
rem ************************************************************************************************

  echo.
  echo Determining Windows PE type ...
  set WINPE_TYPE=
  if /i "%PROCESSOR_ARCHITECTURE%" equ "x86"   set WINPE_TYPE=WINPE32
  if /i "%PROCESSOR_ARCHITECTURE%" equ "AMD64" set WINPE_TYPE=WINPE64
  if exist %SystemRoot%\system32\bartpe.exe    set WINPE_TYPE=BARTPE32
  if not defined WINPE_TYPE goto ERR_WINPE_TYPE
  goto %WINPE_TYPE%
  goto END



rem ************************************************************************************************
rem *** Depending on the Windows PE type we are running on, define the BootManage Administrator
rem *** tools that need to be present in the Windows PE boot image
rem ************************************************************************************************

rem *** We are running on Windows PE 32-Bit x86
:WINPE32
  echo   Windows PE 32-Bit x86 (WINPE32)
  set BMUTIL=bmutil32.exe
  set BMFDISK=bmfdisk32.exe
  set BMNET=bmnet32.exe
  set BMTOOL=bmtool.vbs
  set BMPATCH=bmpatch32.exe
rem *** You may add Windows PE 32-Bit x86 specific stuff here
  goto CHECK_TOOLS


rem *** We are running on Windows PE 64-Bit x64
:WINPE64
  echo   Windows PE 64-Bit x64 (WINPE64)
rem *** For Windows PE 64-Bit x64, 64-Bit versions of the BootManage tools are required
  set BMUTIL=bmutil64.exe
  set BMNET=bmnet64.exe
  set BMFDISK=bmfdisk64.exe
  set BMTOOL=bmtool.vbs
  set BMPATCH=bmpatch64.exe
rem *** You may add other Windows PE 64-Bit x64 specific stuff here
  goto CHECK_TOOLS


rem *** We are running on BartPE 32-Bit x86
:BARTPE32
  echo   BartPE 32-Bit x86 (BARTPE32)
  set BMUTIL=bmutil32.exe
  set BMNET=bmnet32.exe
  set BMFDISK=bmfdisk32.exe
  set BMTOOL=bmtool.vbs
  set BMPATCH=bmpatch32.exe
rem *** You may add BartPE 32-Bit x86 specific stuff here
  goto CHECK_TOOLS



rem ************************************************************************************************
rem *** Check if the required BootManage Administrator tools are available
rem ************************************************************************************************

:CHECK_TOOLS
  echo.
  echo Checking for BootManage Administrator utilities ...
  for %%A in (%BMUTIL% %BMFDISK% %BMTOOL% %BMNET% %BMPATCH%) do (
    if defined DEBUG echo   %TOOLDIR%\%%A
    if not exist %TOOLDIR%\%%A goto ERR_TOOLS
  )
  echo   All required utilities are present

rem ************************************************************************************************
rem *** Set the default commandline parameters for the Windows Script Host
rem ************************************************************************************************
  echo.
  echo Setting default Windows Script Host commandline parameters ...
  cscript //nologo //h:cscript //s

:IP_TEST
rem ************************************************************************************************
rem *** Test the internal network adapter
rem ************************************************************************************************
 echo.
 echo Checking network adapter ...
 %BMTOOL% /wait %DISPLAY_TIME% 
 ping 127.0.0.1 -n 2 >NUL
 if "%ERRORLEVEL%" neq "0" goto ERR_IP
 echo   OK


rem ************************************************************************************************
rem *** Check if the BootManage Administrator configuration information is available.
rem *** While displaying the "Checking for configuration parameters ..." message, allow the user to
rem *** enable debugging by pressing the 'd' key. This sets the DEBUG environment variable to '1'.
rem *** Debugging can also be enabled by the administrator through option #144.
rem ************************************************************************************************
  echo.
  echo Checking for configuration parameters ...
  %BMTOOL% /wait %DISPLAY_TIME% /text "Checking for configuration parameters ..." /key
  if "%ERRORLEVEL%" equ "100" set DEBUG=1

rem *** Check if the BootManage Administrator reply structure is present
    %BMUTIL% -C
	if "%ERRORLEVEL%" neq "0" goto GET_DATA_VIA_DHCP
	echo   OK
	rem *** Obtain the BootManage Administrator configuration parameters for this client
	echo.
  	echo Obtaining BootManage Administrator configuration parameters ...
	%BMTOOL% /wait %DISPLAY_TIME% /text "Obtaining BootManage Administrator configuration parameters ..."
    rem *** Import the configuration parameters as environment variables
	for /f "delims=" %%A in ('%BMUTIL% /asc -s caa ca8 t140 t141 t144 t145 t153 t154 t155 t156') do %%A
    for /f "delims=" %%A in ('%BMUTIL% -s t129 t130 t131 t150 t156 t158 t159 t160 t161 t166 t167') do %%A
    for /f "delims=" %%A in ('%BMUTIL% -s t175 t174') do %%A
    goto CheckDebug 
 
:GET_DATA_VIA_DHCP
rem use alternative way to get the reply structure
      SET CFG_SOURCE=TFTP
      echo Can't find BootManage Administrator reply structure
      echo Loading configuration parameter ...
      %BMTOOL% /wait %DISPLAY_TIME% /text "Loading configuration parameter ..." /key

      rem *** Check each network adapter
      for /f "tokens=1,2* delims=;" %%i in ('%BMNET% -L') do call:GETLANINFO %%i %%j %%k
      if "%BMA_TFTP_SERVER%" equ "unset" goto ERR_CONFIG
	  call:TFTPGET
	  if "%ERR_NR%" equ "0" goto CheckDebug
      echo %ERR_TEXT% ERROR(%ERR_NR%) 
      SET ERR_TEXT=Can't load client configuration
      set ERR_NR=1

:GET_LOCAL_DATA
rem use alternative local way to get the reply structure
      echo Use local way to get the reply structure
      if "_%OEM_DRIVE%" equ "_" GOTO ERR_CONFIG
      if /I "%OEM_DRIVE%" EQU "w" goto LOCAL_DATA
      echo SELECT VOLUME=%OEM_DRIVE%> %TEMP_RAM%\DISKPART_CHLETTER.SRC
      echo ASSIGN LETTER=W>> %TEMP_RAM%\DISKPART_CHLETTER.SRC
      diskpart /S %TEMP_RAM%\DISKPART_CHLETTER.SRC
      if "%ERRORLEVEL%" EQU "0" set OEM_DRIVE=W
      if /I "%OEM_DRIVE%" NEQ "w" goto ERR_CHN_DRV_LETTER

:LOCAL_DATA
      if not exist %OEM_DRIVE%:\$Software\BMASystem\DRV_WINPE_SYSTEMINIT.cmd goto ERR_STRUC
      ECHO use local registration.
      ping 127.0.0.1 -n 2 >NUL
      %OEM_DRIVE%:\$Software\BMASystem\DRV_WINPE_SYSTEMINIT.cmd      
      goto ERR_CONFIG
 
:CheckDebug
rem *** Check if the administrator has requested debug mode via option #144
  if defined t144 set DEBUG=%t144%

rem *** In debug mode, display options and values, and also launch a general-purpose command shell
  if defined DEBUG (
    start "DEBUG COMMAND SHELL" /min cmd /k
    echo   MAC addr [complete]   caa  = "%caa%"
    echo   MAC addr [last 8]     ca8  = "%ca8%"
    echo.
    echo   Username              t140 = "%t140%"
    echo   Password              t141 = [concealed]
    echo   Admin debug mode      t144 = "%t144%"
    echo   Install share         t145 = "%t145%"
    echo   Install server        t153 = "%t153%"
    echo   Domain name           t154 = "%t154%"
    echo   Workgroup name        t155 = "%t155%"
    echo.
    echo   Project directory     t156 = "%t156%"
    echo.
  )

  if defined DEBUG call :ShowDbGMsg

rem *** Assign "friendly names" to required configuration parameters
  set BMA_MAC12=%caa%
  set BMA_MAC8=%ca8%
  set BMA_USERNAME=%t140%
  set BMA_PASSWORD=%t141%
  set BMA_SERVER=%t153%
  set BMA_SHARE=%t145%
  set BMA_DOMAIN=%t154%
  set BMA_WORKGROUP=%t155%
  set BMA_PROJECT=%t156%

rem *** Check if all required configuration parameters are present
rem *** BMA_PROJECT is not a required parameter because it is empty for a new client on first boot
  if not defined BMA_MAC12 goto ERR_PARAM
  if not defined BMA_MAC8 goto ERR_PARAM
  if not defined BMA_USERNAME goto ERR_PARAM
  if not defined BMA_PASSWORD goto ERR_PARAM
  if not defined BMA_SERVER goto ERR_PARAM
  if not defined BMA_SHARE goto ERR_PARAM



rem *** In addition, either a workgroup or a domain name must be provided.
rem *** If none or both are given, we have an error condition
  if defined BMA_DOMAIN if not defined BMA_WORKGROUP goto DOMAIN
  if defined BMA_WORKGROUP if not defined BMA_DOMAIN goto WORKGROUP
  if defined DEBUG call :ShowDbGMsg
  goto ERR_PARAM


rem ************************************************************************************************
rem *** Connect a network drive while logging on using domain credentials
rem ************************************************************************************************

:DOMAIN
  echo.
  echo Performing a DOMAIN logon ...
  echo   Domain name is "%BMA_DOMAIN%"
  echo   Connecting network drive W: to "\\%BMA_SERVER%\%BMA_SHARE%" ...
  %BMTOOL% /wait %DISPLAY_TIME% /text "Performing a DOMAIN logon<BR><BR>Domain name is '%BMA_DOMAIN%'<BR><BR>Connecting network drive W: to '\\%BMA_SERVER%\%BMA_SHARE%' ..."
  net use w: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%BMA_DOMAIN%\%BMA_USERNAME% /persistent:no 
  if ERRORLEVEL 1 goto ERR_NET_DRIVE
  goto CHECK_DIR_STRUCT



rem ************************************************************************************************
rem *** Connect a network drive while logging on using workgroup credentials
rem ************************************************************************************************

:WORKGROUP
  echo.
  echo Performing a WORKGROUP logon ...
  echo   Workgroup name is "%BMA_WORKGROUP%"
  echo   Connecting network drive W: to "\\%BMA_SERVER%\%BMA_SHARE%" ...
  %BMTOOL% /wait %DISPLAY_TIME% /text "Performing a WORKGROUP logon<BR><BR>Workgroup name is '%BMA_WORKGROUP%'<BR><BR>Connecting network drive W: to '\\%BMA_SERVER%\%BMA_SHARE%' ..."
  net use w: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%BMA_WORKGROUP%\%BMA_USERNAME% /persistent:no 
  dir w: >NUL
  if ERRORLEVEL 1 net use w: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%COMPUTERNAME%\%BMA_USERNAME% /persistent:no 
  dir w: >NUL
  if ERRORLEVEL 1 net use w: \\%BMA_SERVER%\%BMA_SHARE% %BMA_PASSWORD% /user:%BMA_USERNAME% /persistent:no 
  dir w: >NUL
  if ERRORLEVEL 1 goto ERR_NET_DRIVE



rem ************************************************************************************************
rem *** Check the directory structure on the installation server
rem *** Clients need to have read/write access to the following directories:
rem ***   $bmnewpc.dir
rem ***   $bmnewpc.dir\log
rem ***   $bmnewpc.dir\temp
rem ***   $bmnewpc.dir\recent
rem ***   $bmnewpc.dir\config
rem ************************************************************************************************

:CHECK_DIR_STRUCT
  if defined DEBUG start "DEBUG COMMAND SHELL WITH NETWORK" /min cmd /k
  echo.
  echo Checking access to installation server ...
  if defined DEBUG CALL:ShowDbGMsg
  %BMTOOL% /wait %DISPLAY_TIME% /key

  set BMNEWPCDIR=w:\$bmnewpc.dir
  if defined DEBUG echo   BMNEWPCDIR = "%BMNEWPCDIR%"

  echo   Base directory
  if not exist %BMNEWPCDIR%\nul mkdir %BMNEWPCDIR%
  set TESTFILE=%BMNEWPCDIR%\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE
  echo Base directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_TESTFILE
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE


  echo   Log files directory
  if not exist %BMNEWPCDIR%\log\nul mkdir %BMNEWPCDIR%\log
  set TESTFILE=%BMNEWPCDIR%\log\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE
  echo Log files directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_TESTFILE
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE


rem *** Log, Lock, and Status files are all located in the log directory
  set CLIENT_LOGFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.log
  set CLIENT_LOCKFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.lck
  set CLIENT_STATUSFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.sta

rem *** From now on, we can write to the client's log, lock, and status files


rem *** If the client's log file does not already exist, create it
  if not exist %CLIENT_LOGFILE% %BMTOOL% /log %CLIENT_LOGFILE% /L "Log file started for client '%BMA_MAC12%'"

rem *** If the client's lock file exists (e.g. from a previous failure), delete it
  if exist %CLIENT_LOCKFILE% del %CLIENT_LOCKFILE%

rem *** Indicate the start of a new Windows PE based client boot
  %BMTOOL% /log %CLIENT_LOGFILE% /L "==================== %WINPE_TYPE% ===================="
  echo Windows PE booted > %CLIENT_STATUSFILE%


  echo   Temporary files directory
  if not exist %BMNEWPCDIR%\temp\nul mkdir %BMNEWPCDIR%\temp
  set TESTFILE=%BMNEWPCDIR%\temp\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE
  echo Temporary files directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_TESTFILE
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE

rem *** From now on, we can create temporary files
  set TEMP=%BMNEWPCDIR%\temp


  echo   Update files directory
  if not exist %BMNEWPCDIR%\recent\nul mkdir %BMNEWPCDIR%\recent
  set TESTFILE=%BMNEWPCDIR%\recent\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE
  echo Update files directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_TESTFILE
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE


  echo   Configuration files directory
  if not exist %BMNEWPCDIR%\config\nul mkdir %BMNEWPCDIR%\config
  set TESTFILE=%BMNEWPCDIR%\config\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE
  echo Configuration files directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_TESTFILE
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_TESTFILE


rem *** Installation server access to log, temp, recent and config directories is OK
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Installation server access OK"


rem *** The TESTFILE environment variable is no longer used
  set TESTFILE=

  if defined DEBUG call :ShowDbGMsg


rem ************************************************************************************************
rem *** Write all configuration parameters to a file for analyzing/debugging purposes
rem ************************************************************************************************

if defined DEBUG (
  echo.
  echo Logging configuration parameters ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Logging configuration parameters ..."
  rem *** Write the in-memory configuration parameters to a file
   if defined CLIENT_VARFILE (
      copy  %CLIENT_VARFILE% %BMNEWPCDIR%\log\%BMA_MAC8%.var
   ) else (
   %BMUTIL% -C
   %BMUTIL% -S > %BMNEWPCDIR%\log\%BMA_MAC8%.env
   )
)


rem ************************************************************************************************
rem *** Check if this client is already registered with the BootManage Administrator. In this case,
rem *** the BMA_PROJECT environment variable must point to the assigned project base directory.
rem ************************************************************************************************

  echo.
  echo Checking client registration status ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Checking client registration status ..."
  if not defined BMA_PROJECT goto NEW_CLIENT

  echo   This client ist already registered!
  %BMTOOL% /log %CLIENT_LOGFILE% /L "This client ist already registered!"

  set PROJECT_BASEDIR=w:\%BMA_PROJECT%



rem ************************************************************************************************
rem *** This client is already registered.
rem *** Copy, patch and execute the project specific batch file
rem ************************************************************************************************
:RUN_PROJECT_SCRIPT
  set PROJECT_SCRIPT=%PROJECT_BASEDIR%\bma_winpe_project.cmd
  echo.
  echo Assigned BMA project is "%BMA_PROJECT%"
  echo   BMA project base directory is "%PROJECT_BASEDIR%"
  echo   Project file is "%PROJECT_SCRIPT%"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Assigned BMA project is '%BMA_PROJECT%'"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  BMA project base directory is '%PROJECT_BASEDIR%'"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Project file is '%PROJECT_SCRIPT%'"
  if not exist %PROJECT_SCRIPT% goto ERR_NO_PROJECT

  set PATCHED_PROJECT_SCRIPT=%TEMP%\%BMA_MAC12%_project.cmd

  echo.
  echo   Copying and patching project file ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Copying and patching project file ..."
  if exist %PATCHED_PROJECT_SCRIPT% del %PATCHED_PROJECT_SCRIPT%
  copy %PROJECT_SCRIPT% %PATCHED_PROJECT_SCRIPT%
  if defined CLIENT_VARFILE %BMPATCH% %PROJECT_SCRIPT% %PATCHED_PROJECT_SCRIPT% %CLIENT_VARFILE%
  %BMUTIL% -C
  if "%ERRORLEVEL%" equ "0"  %BMUTIL% -a %PATCHED_PROJECT_SCRIPT%
  echo.
  echo   Executing patched project file ...
  if defined DEBUG call :ShowDbGMsg
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Executing patched project file ..."
  echo Executing project script > %CLIENT_STATUSFILE%
  %PATCHED_PROJECT_SCRIPT%
  goto END



rem ************************************************************************************************
rem *** Register the new client with the BMA
rem ************************************************************************************************

:NEW_CLIENT
  echo.
  echo Registering new client ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Registering new client ..."
  %BMTOOL% /wait %DISPLAY_TIME% /text "Registering new client ..."
  echo Registering new client > %CLIENT_STATUSFILE%
  set INFOFILE=%TEMP%\%BMA_MAC12%_hwinfo.ini

rem *** Create the client information file in the 'temp' directory on the installation server
  echo   Creating client information file ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Creating client information file ..."
  echo. > %INFOFILE%

rem *** Get the client's device information and store it in the client information file
  echo   Detecting device information ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Detecting device information ..."
  %BMTOOL% /devices >> %INFOFILE%
  echo. >> %INFOFILE%

rem *** Store the DHCP reply information in the client information file
  echo   Storing DHCP reply information ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Storing DHCP reply information ..."
  echo [BOOTP-DHCP] >> %INFOFILE%
    %BMUTIL% -C
  if ERRORLEVEL 1 (
     echo set caa=%CAA% >> %INFOFILE%
     echo set ca8=%CA8% >> %INFOFILE%	
     echo set yip=%BMNET_IP_ADDRESS% >> %INFOFILE%	
     echo set smf=%BMNET_IP_MASK% >> %INFOFILE%	
     echo set gip=%BMNET_GATEWAY% >> %INFOFILE%	
     echo set gw0=%BMNET_GATEWAY% >> %INFOFILE%
     echo set typ=0000 >> %INFOFILE%
     echo set sip=%BMA_TFTP_SERVER% >> %INFOFILE%	
  ) else (
   %BMUTIL% -S >> %INFOFILE%
  )
  echo. >> %INFOFILE%


rem *** Now that the client information file is complete, move it to the 'actual' BMA location
rem *** where it will be recognized and processed by the BMA console
  echo   Activating client information file ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "  Activating client information file ..."
  copy %INFOFILE% %BMNEWPCDIR%\%BMA_MAC8%.chi
  if not defined DEBUG del %INFOFILE%

rem *** Wait until the new client was accepted by the BMA console
rem *** This is the case when the client's information file vanishes
rem *** So, we just wait in a loop while periodically checking for the file
  echo.
  echo Waiting for administrator confirmation ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Waiting for administrator confirmation ..."
  echo Waiting for administrator confirmation > %CLIENT_STATUSFILE%

rem *** As long as the client hardware information file remains present,
rem *** the administrator has not yet accepted this PC.
:NEW_CLIENT_LOOP
  %BMTOOL%  /wait 10 /text "Waiting for administrator confirmation ...<BR><BR>This client's ID is: '%BMA_MAC8%'"
  if exist %BMNEWPCDIR%\%BMA_MAC8%.chi goto NEW_CLIENT_LOOP

  echo.
  echo The computer is enabled!
  %BMTOOL% /log %CLIENT_LOGFILE% /L "The computer is enabled!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "The computer is enabled!"



rem ************************************************************************************************
rem *** If the PC already has a status partition, set its ID value to f3
rem *** so that the PC is forced to start from the network at the next boot
rem *** Also, make sure that only a single status partition exists
rem ************************************************************************************************

  echo.
  echo Looking for existing status partition ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Looking for existing status partition ..."

rem *** In debug mode, display the partition table before alteration
  if defined DEBUG (
    echo   Partition table before alteration:
    %BMFDISK% -p \\.\physicaldrive0
  )
  if defined DEBUG call :ShowDbGMsg



  set COUNT=0

  set PART0=
  set PART1=
  set PART2=
  set PART3=

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 0 %%A
    if ERRORLEVEL 1 set PART0=1 && set /a COUNT += 1
  )

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 1 %%A
    if ERRORLEVEL 1 set PART1=1 && set /a COUNT += 1
  )

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 2 %%A
    if ERRORLEVEL 1 set PART2=1 && set /a COUNT += 1
  )

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 3 %%A
    if ERRORLEVEL 1 set PART3=1 && set /a COUNT += 1
  )

rem *** If more than one status partition was found, we have an error condition
  if "%COUNT%" gtr "1" goto ERR_MULTI_STATUS_PART

rem *** If we have a status partition, set its ID value to 'f3'
  if defined PART0 %BMFDISK% -o \\.\physicaldrive0 0 f3 -f
  if defined PART1 %BMFDISK% -o \\.\physicaldrive0 1 f3 -f
  if defined PART2 %BMFDISK% -o \\.\physicaldrive0 2 f3 -f
  if defined PART3 %BMFDISK% -o \\.\physicaldrive0 3 f3 -f

rem *** In debug mode, display the partition table after alteration
  if defined DEBUG (
    echo   Partition table after alteration:
    %BMFDISK% -p \\.\physicaldrive0
  )

    if defined DEBUG call :ShowDbGMsg



rem ************************************************************************************************
rem *** We need to reboot the client so that it can fetch its individual configuration
rem *** information from its option file during the TFTP phase
rem ************************************************************************************************

  echo.
  echo Rebooting ...
  if defined DEBUG call :ShowDbGMsg
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Rebooting ..."
  echo Rebooting > %CLIENT_STATUSFILE%
  %BMTOOL% /wait %DISPLAY_TIME% /text "Rebooting ..."
  exit

  goto :EOF
rem ************************************************************************************************
rem *** This is the function section
rem ************************************************************************************************

rem ************************************************************************************************
rem *** Check each network adapter
rem ************************************************************************************************
:GETLANINFO
    if "%BMA_TFTP_SERVER%" neq "unset" goto :EOF
    SET ADAPTERID=%1
	SET MAC=%2
	SET IP=%3
    rem *** Get Network abapter informations like DHCP Server, MAC addr etc
    echo Read network adapter configuration
    for /f "delims=" %%A in ('%BMNET% -a -f 2 -i %ADAPTERID%') do %%A
    set BMA_MAC12=%BMNET_ADAPTER_CAA%
    set BMA_MAC8=%BMNET_ADAPTER_CA8%
    set caa=%BMNET_ADAPTER_CAA%
    set ca8=%BMNET_ADAPTER_CA8%
	
    rem *** Seek for magic keywords in DHCP reply to get the current TFTP server
    echo Build major priority configuration structure
    for /L %%i in (129,1,133) do %BMNET% -o %%i -f 3 -i %ADAPTERID% >> %BMA_TMPFILE%
    for /F "delims=" %%i in ('find "#$BMA$#" "%BMA_TMPFILE%"') do set "LINEBUFF=%%i" & call :FilterLine 
	
    rem *** in case of none overwrite parameter read Boot-Server-Hostname TFTP server
    if "%BMA_TFTP_SERVER%" equ "unset" (
       echo No priority server found....
       echo Obtaining BootManage Administrator configuration server ...
       for /f "delims=" %%A in ('%BMNET% -o 66 -f 2 -i %ADAPTERID%') do %%A
     ) else (
  	   echo Priority server found....
     ) 

    if defined DEBUG CALL:ShowDbGMsg

	if "%BMA_TFTP_SERVER%" equ "unset" set BMA_TFTP_SERVER=%BMNET_DHCP_OPTION_66%
	:: if no TFTP Server defined stop process
	:: if "%BMA_TFTP_SERVER%" equ "unset"  goto ERRTFTP
	if "%BMA_TFTP_SERVER%" equ "unset"  goto :EOF 
	if "%BMA_TFTP_SERVER%" equ "(null)"  goto :EOF 
	if "%BMA_TFTP_SERVER%" equ ""  goto :EOF 
	Echo Check configuration server: %BMA_TFTP_SERVER%
    if defined DEBUG call :ShowDbGMsg
	goto :EOF

:: #########################
:: Load OPT file from Server 
:: #########################

:TFTPGET
rem *** Load individual OPT file (mac).OPT  
  echo Get client Configuration file
  SET OPTFILETYPE=1
  %BMNET% -t get %BMA_OPTFILE% %BMNET_ADAPTER_CA8%.OPT %BMA_TFTP_SERVER% >NUL
  if %ERRORLEVEL% equ 0 goto MACOPTOK
  echo Client configuration file does not exist.

:TFTPPXOPT  
rem *** Load global OPT file pxboot.OPT 
  echo Get default Configuration file
  SET OPTFILETYPE=2
  %BMNET% -t get %BMA_OPTFILE% pxboot.opt %BMA_TFTP_SERVER% >NUL
  if %ERRORLEVEL% neq 0 (
      Set ERROR_MSG=Default configuration file missing
	  set ERR_NR=20
	  set BMA_TFTP_SERVER=unset
	  goto :EOF
      )	  
  echo Default configuration file found

:MACOPTOK
  echo Read client configuration
  for /f "delims=" %%A in ('%BMNET% -n %BMA_OPTFILE% -f 2') do set "LINEBUFF=%%A" & call :ConvertLine 
  rem *** Assign "names" to required configuration parameters
  set BMA_MAC12=%BMNET_ADAPTER_CAA%
  set BMA_MAC8=%BMNET_ADAPTER_CA8%
  set caa=%BMNET_ADAPTER_CAA%
  set ca8=%BMNET_ADAPTER_CA8%
  rem redifine t129 
  for /f "delims=" %%A in ('find ^"B129^" %BMA_OPTFILE%') do set "LINEBUFF=%%A" & call :GETB129 



 
   if not defined t140 (
     echo T140 not defined
     if "%OPTFILETYPE%" equ "2" goto ERR_PARAM
     goto TFTPPXOPT
    )
  if not defined t141 (
     echo T141 not defined
   if "%OPTFILETYPE%" equ "2" goto ERR_PARAM
      goto TFTPPXOPT
    )	

:: build Client VARFILE on r:\MAC8.var
    if exist %TEMP_RAM%\%BMA_MAC8%.var del %TEMP_RAM%\%BMA_MAC8%.var
    %BMNET% -a -i %ADAPTERID% -f 1 > %TEMP_RAM%\%BMA_MAC8%.var
    if "%ERRORLEVEL%" neq "0" goto ERR_PARAM
    SET CLIENT_VARFILE=%TEMP_RAM%\%BMA_MAC8%.var
    echo caa=^"%BMNET_ADAPTER_CAA%^" >> %CLIENT_VARFILE%
    echo ca8=^"%BMNET_ADAPTER_CA8%^" >> %CLIENT_VARFILE%
    echo yip=^"%BMNET_IP_ADDRESS%^" >> %CLIENT_VARFILE%
    echo smf=^"%BMNET_IP_MASK%^" >> %CLIENT_VARFILE%
    echo gip=^"%BMNET_GATEWAY%^" >> %CLIENT_VARFILE%
    echo gw0=^"%BMNET_GATEWAY%^" >> %CLIENT_VARFILE%
    echo sip=^"%BMA_TFTP_SERVER%^" >> %CLIENT_VARFILE%
    echo typ=^"0000^" >> %CLIENT_VARFILE%
   :: %BMNET% -n %BMA_OPTFILE% -f 1 >> %CLIENT_VARFILE%
    for /f "delims=" %%A in ('%BMNET% -n %BMA_OPTFILE% -f 1') do set "LINEBUFF=%%A" & call :Conv2File
    GOTO:EOF


:FilterLine 
set StrData=%LINEBUFF:~0,8%
if "%StrData%" neq "#$BMA$#," goto :EOF
set "LINEBUFF=%LINEBUFF:#$BMA$#,=%"  
for /f "tokens=1-2* delims=," %%a in ("%LINEBUFF%") do call :CheckTFTPServer %%a %%b
goto :EOF

:CheckTFTPServer 
   if "%1" equ "BMA_TFTP_SERVER" (
     SET BMA_TFTP_SERVER=%2
   ) else (
     SET %1=%2
   )
   GOTO:EOF

:: Convert BMNET_OPTION_<number> to t<number>
:Conv2File
set "LINEBUFF=%LINEBUFF:BMNET_OPTION_=t%"
echo %LINEBUFF%  >> %CLIENT_VARFILE%
GOTO:EOF

:GETB129
set StrData=%LINEBUFF:~0,5%
if "%StrData%" neq "B129=" goto :EOF
set StrData=%LINEBUFF:~1%
set t%StrData%
set t129=[9]%t129%
goto :EOF
   
:: Convert BMNET_OPTION_<number> to t<number>
:ConvertLine 
set "LINEBUFF=%LINEBUFF:BMNET_OPTION_=t%"
%LINEBUFF%
GOTO:EOF

:ShowDbGMsg
  %BMTOOL% /wait 3 /key /text "Debug Mode<BR><BR>Press ENTER to pause"
  if "%ERRORLEVEL%" equ "100" pause
  goto :EOF


rem ************************************************************************************************
rem *** This is the error messages section
rem ************************************************************************************************


:ERRTFTP
  SET ERROR_TYPE=TFTP
  SET ERROR_MSG="TFTP server could not be found!"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL

  
:ERR_TFTP_OPT
  SET ERROR_TYPE=TFTP
  SET ERROR_MSG="ERROR: Can't load configuraiton file !"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL

:ERR_CMD_EXT
  SET ERROR_TYPE=CMD
  SET ERROR_MSG="ERROR: Command processor extensions are not enabled !"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL


:ERR_WINPE_TYPE
  SET ERROR_TYPE=PETYPE
  SET ERROR_MSG="ERROR: The Windows PE type of this boot image could not be detected !"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL


:ERR_TOOLS
  SET ERROR_TYPE=TOOLS
  SET ERROR_MSG="One or more of the BootManage Administrator utilities are missing"
  echo.
  echo.
  echo ERROR: One or more of the BootManage Administrator utilities
  echo        are missing in this Windows PE boot image !
  goto FATAL


:ERR_DISK
  SET ERROR_TYPE=DISK
  SET ERROR_MSG="ERROR: Can't find hard disk drive!"
  echo.
  echo.
  echo ERROR: Can't find hard disk drive!
  echo.
  echo Possible causes are:
  echo.
  echo        This Windows PE Boot Image does not contain a driver for the
  echo        system disk's mass storage controller. It may be necessary to add 
  echo        a third party mass storage driver to this Windows PE Boot Image.
  goto FATAL

:ERR_CHN_DRV_LETTER
  SET ERROR_TYPE=CONFIG
  SET ERROR_MSG="ERROR: Can't change local drive "
  echo.
  echo.
  echo ERROR:  Can't change local drive
  echo.
  echo Possible causes are:
  echo.
  echo        This Windows PE Boot Image was not used within
  echo        the context of the BootManage Administrator.
  echo.
  goto FATAL

:ERR_STRUC
  SET ERROR_TYPE=CONFIG
  SET ERROR_MSG="ERROR: Can't find BMA file structure on local drive "
  echo.
  echo.
  echo ERROR:  Can't find BMA file structure on local drive
  echo.
  echo Possible causes are:
  echo.
  echo        File missing 
  echo        %OEM_DRIVE%:\$Software\BMASystem\DRV_WINPE_SYSTEMINIT.cmd
  echo        This Windows PE Boot Image was not used within
  echo        the context of the BootManage Administrator.
  echo.
  goto FATAL


:ERR_CONFIG
  SET ERROR_TYPE=CONFIG
  SET ERROR_MSG="ERROR: BMA configuration parameters are not present!"
  echo.
  echo.
  echo ERROR: BootManage Administrator configuration parameters are not present !
  echo.
  echo Possible causes are:
  echo.
  echo        This Windows PE Boot Image was not used within
  echo        the context of the BootManage Administrator.
  echo.
  goto FATAL


:ERR_PARAM
  SET ERROR_TYPE=PARAM
  SET ERROR_MSG="ERROR: At least one required configuration parameter is missing or invalid !"
  echo.
  echo.
  echo ERROR: At least one required configuration parameter is missing or invalid !
  goto FATAL


:ERR_IP
  SET ERROR_TYPE=NET
  SET ERROR_MSG="ERROR: Unable to contact IP driver."
  echo.
  echo.
  echo ERROR: Unable to contact IP driver.
  echo.
  echo Possible causes are:
  echo.
  echo        This Windows PE Boot Image does not contain a driver for the
  echo        network adapter. It may be necessary to add a third party
  echo        network driver to this Windows PE Boot Image.
  echo.
  goto FATAL


:ERR_NET_DRIVE
  SET ERROR_TYPE=NET
  SET ERROR_MSG="Network drive could not be connected to the installation server!"
  echo.
  echo.
  echo ERROR: Network drive could not be connected to the installation server!
  echo.
  echo Possible causes are:
  echo.
  echo        The server name cannot be resolved into an IP address.
  echo.
  echo        The share does not exist on the installation server.
  echo.
  echo        The logon credentials are invalid, or the account does not exist
  echo        on the installation server respectively in the domain.
  echo.
  echo        Permission restrictions do not allow to access the share.
  echo.
  echo        This Windows PE Boot Image does not contain a driver for the
  echo        network adapter. It may be necessary to add a third party
  echo        network driver to this Windows PE Boot Image.
  goto FATAL


:ERR_TESTFILE
  SET ERROR_TYPE=TESTFILE
  SET ERROR_MSG="ERROR: Cannot create or access %TESTFILE%!"
  echo.
  echo.
  echo ERROR: Cannot create or access "%TESTFILE%"!
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Cannot create or access '%TESTFILE%'"
  goto FATAL


:ERR_NO_PROJECT
  SET ERROR_TYPE=PROJECT
  SET ERROR_MSG="ERROR: Project file %BMA_PROJECT% missing!"
  echo.
  echo.
  echo ERROR: Project file for BMA project "%BMA_PROJECT%" does not exist!
  %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Project file for BMA project '%BMA_PROJECT%' does not exist!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Project file for BMA project '%BMA_PROJECT%' does not exist!"
  goto FATAL


:ERR_MULTI_STATUS_PART
  SET ERROR_TYPE=MULTISTATUS
  SET ERROR_MSG="ERROR: Multiple status partitions were detected on this client!"
  if defined DEBUG  %BMFDISK% -p \\.\physicaldrive0
  echo.
  echo.
  echo ERROR: Multiple status partitions were detected on this client!
  if defined CLIENT_LOGFILE %BMTOOL% /log %CLIENT_LOGFILE% /L "ERROR: Multiple status partitions were detected on this client!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Multiple status partitions were detected on this client!"
  goto FATAL


:FATAL
  if not defined CLIENT_STATUSFILE set CLIENT_STATUSFILE=NUL
  if not defined CLIENT_LOCKFILE set CLIENT_LOCKFILE=NUL
  color 4f
  echo.
  echo An error has occurred!
  echo This script cannot continue!
  echo Please contact your network administrator!"
  echo.
  echo ERROR - see client log > %CLIENT_STATUSFILE%


rem *** If the CLIENT_LOCKFILE variable is defined, we can use the lock file loop mechanism
rem *** Otherwise, the lock file mechanism is not available, and we must exit to the commandline
  echo ERROR > %CLIENT_LOCKFILE%
  SET DO_RETRY=0
  if "%ERROR_TYPE%" equ "NET" SET DO_RETRY=1
  if "%ERROR_TYPE%" equ "TESTFILE" SET DO_RETRY=1
  if "%ERROR_TYPE%" equ "PROJECT" SET DO_RETRY=1


:FATAL_LOOP
  if "%DO_RETRY%" equ "1" (
     %BMTOOL% /wait 20 /key /text %ERROR_MSG%"<BR><BR>Please contact your network administrator!<BR>Press <SPACE> to retry or <ENTER> to reboot"
  ) else (
      %BMTOOL% /wait 20 /key /text %ERROR_MSG%"<BR><BR>This script cannot continue!<BR>Please contact your network administrator!"
  )

  if "%ERRORLEVEL%" equ "113" goto END
  if "%DO_RETRY%" equ "1" if "%ERRORLEVEL%" equ "32" (
     if "%ERROR_TYPE%" equ "NET" goto IP_TEST
     if "%ERROR_TYPE%" equ "TESTFILE" goto CHECK_DIR_STRUCT
     if "%ERROR_TYPE%" equ "PROJECT" goto RUN_PROJECT_SCRIPT
   )  

  rem *** Show Debug informations ***
  if "%ERRORLEVEL%" equ "100" (
     echo ************************************
     echo ******** Debug informations ********
     echo ************************************
     echo Check IP configuration
     ipconfig /all
     echo.
     echo Press a key to show the harddisk settings 
     pause >nul 
     echo Harddisk settings
     %BMFDISK% -p \\.\physicaldrive0
     echo.
     echo Press a key to show client parameter 
     pause >nul 
     echo Client Parameter
     %BMUTIL% -S
     echo Press a key continue
     pause > nul
     goto FATAL_LOOP
   )  
   
  if "%ERRORLEVEL%" neq "0" goto PC_SHUTDOWN

  if "%CLIENT_LOCKFILE%" neq "NUL" (
     if not exist %CLIENT_LOCKFILE% goto PC_SHUTDOWN
  ) 
  goto FATAL_LOOP



:PC_SHUTDOWN
  echo Rebooting ...
  if defined DEBUG %BMTOOL% /wait 3 /key /text "Debug Mode<BR><BR>Press ENTER to pause"
  if "%ERRORLEVEL%" equ "100" pause
  %BMTOOL% /shutdown 1 /wait %DISPLAY_TIME% /text "Rebooting ..."
  REM *** An EXIT statement causes WinPE to reboot the machine
  EXIT


:END
  set t141=
  set BMA_PASSWORD=
  echo.

:FIN
