@echo off
rem ************************************************************************************************
rem *** BMA_WINPE_SYSTEMINIT.CMD v1.0 2013-04-11_13:50
rem ***
rem *** BootManage Administrator optional initialization script for Windows PE
rem ***    determines the unterlying Windows PE type
rem ***    retrieves configuration parameters
rem ***    connects a network drive to the installation server
rem ***    registers new clients
rem ***    determines the assigned project
rem ***    executes the project specific script
rem ***
rem ***  existing Parameter 
rem ***	 TEMP_RAM
rem ***  BMA_MAC12
rem ***  BMNEWPCDIR
rem ***  BMA_MAC12=%caa%
rem ***  BMA_MAC8=%ca8%
rem ***  BMA_USERNAME=%t140%
rem ***  BMA_PASSWORD=%t141%
rem ***  BMA_SERVER=%t153%
rem ***  BMA_SHARE=%t145%
rem ***  BMA_DOMAIN=%t154%
rem ***  BMA_WORKGROUP=%t155%
rem ***  BMA_PROJECT=%t156%
rem ***
rem ************************************************************************************************
rem for failed start protection

rem Release old SYTEMBLOCKER use current 
  set "TFTPBOOT_SHARE=tftpboot"
  SET "TFTP_DIR=v:"

  IF NOT DEFINED DISPLAY_TIME set "DISPLAY_TIME=5"
  set DEBUG=1
  
  set BMA_SYSTEM_DIR=%~dp0
  :: cut last \ NewDir = w:\$SOFTWARE\BMASystem
  set BMA_SYSTEM_DIR=%BMA_SYSTEM_DIR:~0,-1%

  SET "LOCAL_BMA_DIR=%TEMP_RAM%"
  SET "LOCAL_BMA_DIR_LOG=%LOCAL_BMA_DIR%\LOG"
  SET "LOCAL_BMA_DIR_TEMP=%LOCAL_BMA_DIR%\TEMP"
  SET "LOCAL_BMA_DIR_TOOLS=%BMA_SYSTEM_DIR%\TOOLS"
  SET "LOCAL_BMA_DIR_SOFTWARE=%LOCAL_BMA_DIR%\SOFTWARE"
  SET "LOCAL_LOGFILE=%LOCAL_BMA_DIR_LOG%\%ca8%.log"
  if not exist %LOCAL_BMA_DIR%\NUL mkdir %LOCAL_BMA_DIR%
  if not exist %LOCAL_BMA_DIR_LOG%\NUL mkdir %LOCAL_BMA_DIR_LOG%
  if not exist %LOCAL_BMA_DIR_TEMP%\NUL mkdir %LOCAL_BMA_DIR_TEMP%
  if not exist %LOCAL_BMA_DIR_TOOLS%\NUL mkdir %LOCAL_BMA_DIR_TOOLS%
  if not exist %LOCAL_BMA_DIR_SOFTWARE%\NUL mkdir %LOCAL_BMA_DIR_SOFTWARE%

  Set PATH=%LOCAL_BMA_DIR_TOOLS%;%PATH%
  SET BMTOOL=cscript //nologo %LOCAL_BMA_DIR_TOOLS%\bmtool.vbs
  SET BMPATCH=BMPATCH32
  SET BMFDISK=BMFDISK32
  SET BMUTIL=BMUTIL32

  SET "BMNEWPCDIR=W:\$BmNewPC.dir"
  SET "CLIENT_LOGFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.log"
  SET "CLIENT_LOCKFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.lck"
  SET "CLIENT_STATUSFILE=%BMNEWPCDIR%\log\%BMA_MAC8%.sta"
  SET "LOCAL_BLOCKER_PIC=%LOCAL_BMA_DIR_TEMP%\BLOCKER_PIC.JPG"
  SET "LOCAL_BLOCKER_STATUSFILE=%LOCAL_BMA_DIR_TEMP%\%ca8%_BLOCKER_STATUSFILE.TXT"
  SET "LOCAL_BLOCKER_PROGESSFILE=%LOCAL_BMA_DIR_TEMP%\progess.log"

  IF  DEFINED LOCAL_BLOCKFILE  DEL /Q %LOCAL_BLOCKFILE%
 
  SET "LOCAL_BLOCKFILE=%LOCAL_BMA_DIR_TEMP%\%ca8%_KEYBOARD_LOCKED.LCK"
  ECHO Lock > %LOCAL_BLOCKFILE%
  ECHO ... > %LOCAL_BLOCKER_PROGESSFILE%
  ECHO ^<SYSTEMBLOCKER PROGRESSFILE=%LOCAL_BLOCKER_PROGESSFILE%^>^<SYSTEMBLOCKER BLOCKFILE=%LOCAL_BLOCKFILE%^>Checking client settings. Please wait... > %LOCAL_BLOCKER_STATUSFILE%  
  copy %LOCAL_BMA_DIR_TOOLS%\blocker.jpg %LOCAL_BLOCKER_PIC%
  if defined DEBUG (
	START SystemBlocker -MAX -TEST -TEXT Please wait... client ID: %ca8% -WAIT 1 -FILE %LOCAL_BLOCKFILE% -STATUSFILE %LOCAL_BLOCKER_STATUSFILE% -PICTURE %LOCAL_BLOCKER_PIC%
  ) else (
	START SystemBlocker -MAX -TEXT Please wait... client ID: %ca8% -WAIT 1 -FILE %LOCAL_BLOCKFILE% -STATUSFILE %LOCAL_BLOCKER_STATUSFILE% -PICTURE %LOCAL_BLOCKER_PIC%
  )
  
  SET "CLIENT_SERVER_LOG_DIR=%BMNEWPCDIR%\log"
  SET "CLIENT_SERVER_CONFIG_DIR=%BMNEWPCDIR%\config"
  SET "CLIENT_SERVER_RECENT_DIR=%BMNEWPCDIR%\recent"
  SET "CLIENT_SERVER_TEMP_DIR=%BMNEWPCDIR%\temp"
  SET "CLIENT_SERVER_LOG_DIR_MAC8=%CLIENT_SERVER_LOG_DIR%\%ca8%"
  SET "CLIENT_SERVER_LOGFILES_DIR=%CLIENT_SERVER_LOG_DIR_MAC8%\logfiles"
  SET "CLIENT_SERVER_DEBUGFILES_DIR=%CLIENT_SERVER_LOG_DIR_MAC8%\debugfiles"
  SET "BMA_AUTOREG_DIR=%CLIENT_SERVER_LOG_DIR%\autoreg"


  echo.
  echo Checking access to installation server ...
  SET "ERROR=0"
  call :TestStructure "%BMNEWPCDIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_LOG_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_CONFIG_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_RECENT_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_TEMP_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_LOG_DIR_MAC8%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_LOGFILES_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%CLIENT_SERVER_DEBUGFILES_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE
  call :TestStructure "%BMA_AUTOREG_DIR%"
  IF "%ERROR%" NEQ "0" then goto ERR_TESTFILE

  SET "NET_BLOCKFILE=%CLIENT_SERVER_LOG_DIR_MAC8%\KEYBOARD_LOCKED.LCK"
  SET "CLIENT_SERVER_LOGFILE=%CLIENT_SERVER_LOG_DIR%\%ca8%.log"
  SET "CLIENT_LOCKFILE=%CLIENT_SERVER_LOG_DIR%\%ca8%.lck"
  SET "CLIENT_SERVER_STATUSFILE=%CLIENT_SERVER_LOG_DIR%\%ca8%.sta"
  SET "CLIENT_SERVER_RECENT_FILE=%CLIENT_SERVER_RECENT_DIR%\%ca8%.chi"
  SET "CLIENT_SERVER_PROGESSFILE=%CLIENT_SERVER_LOGFILES_DIR%\progess.log"

  rem Switch to network block file
  ECHO Lock > %NET_BLOCKFILE%
  ECHO ^<SYSTEMBLOCKER PROGRESSFILE=%LOCAL_BLOCKER_PROGESSFILE%^>^<SYSTEMBLOCKER BLOCKFILE=%NET_BLOCKFILE%^>Checking client settings. Please wait... > %LOCAL_BLOCKER_STATUSFILE%  
  %BMTOOL% /wait 5
  if exist %LOCAL_BLOCKFILE% del /q %LOCAL_BLOCKFILE%

  %BMTOOL% /log %CLIENT_LOGFILE% /L "Installation server access OK"
  rem *** The TESTFILE environment variable is no longer used
  set TESTFILE=
  if defined DEBUG call :ShowDbGMsg

  
  rem *** If the client's lock file exists (e.g. from a previous failure), delete it
  if exist %CLIENT_LOCKFILE% del %CLIENT_LOCKFILE%

  echo Windows PE booted. > %CLIENT_STATUSFILE%
   

rem ************************************************************************************************
rem *** Write all configuration parameters to a file for analyzing/debugging purposes
rem ************************************************************************************************


if defined DEBUG (
  echo.
  echo Logging configuration parameters ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "Logging configuration parameters ..."
  rem *** Write the in-memory configuration parameters to a file
   if defined CLIENT_VARFILE (
      copy  %CLIENT_VARFILE% %CLIENT_SERVER_DEBUGFILES_DIR%\%BMA_MAC8%.var
   ) else (
   %BMUTIL% -C
   %BMUTIL% -S > %CLIENT_SERVER_DEBUGFILES_DIR%\%BMA_MAC8%.env
   )
)


	
rem ************************************************************************************************
rem *** Check if this client is already registered with the BootManage Administrator. In this case,
rem *** the BMA_PROJECT environment variable must point to the assigned project base directory.
rem ************************************************************************************************

  echo.
  echo Checking client registration status ...
  %BMTOOL% /log %CLIENT_SERVER_LOGFILE% /L "BMA_WINPE_INIT: Checking client registration status ..."
  echo Checking client registration file. client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  %BMTOOL% /wait 10
  if not defined BMA_PROJECT goto NEW_CLIENT

  echo   This client ist already registered!
  %BMTOOL% /log %CLIENT_SERVER_LOGFILE% /L "BMA_WINPE_INIT: This client ist already registered!"
  echo This client is already registered. client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  %BMTOOL% /wait 10

  set PROJECT_BASEDIR=w:\%BMA_PROJECT%

rem ************************************************************************************************
rem *** This client is already registered.
rem *** Copy, patch and execute the project specific batch file
rem ************************************************************************************************
:RUN_PROJECT_SCRIPT
  set PROJECT_SCRIPT=%PROJECT_BASEDIR%\bma_winpe_project.cmd
  echo.
  echo Assigned BMA project is "%BMA_PROJECT%"
  echo   BMA project base directory is "%PROJECT_BASEDIR%"
  echo   Project file is "%PROJECT_SCRIPT%"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Assigned BMA project is '%BMA_PROJECT%'"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: BMA project base directory is '%PROJECT_BASEDIR%'"
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Project file is '%PROJECT_SCRIPT%'"
  if not exist %PROJECT_SCRIPT% goto ERR_NO_PROJECT

  set PATCHED_PROJECT_SCRIPT=%TEMP%\%BMA_MAC12%_project.cmd

  echo.
  echo   Copying and patching project file ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Copying and patching project file ..."
  if exist %PATCHED_PROJECT_SCRIPT% del %PATCHED_PROJECT_SCRIPT%
  copy %PROJECT_SCRIPT% %PATCHED_PROJECT_SCRIPT%
  if defined CLIENT_VARFILE %BMPATCH% %PROJECT_SCRIPT% %PATCHED_PROJECT_SCRIPT% %CLIENT_VARFILE%
  %BMUTIL% -C
  if "%ERRORLEVEL%" equ "0"  %BMUTIL% -a %PATCHED_PROJECT_SCRIPT%
  echo.
  echo   Executing patched project file ...
  if defined DEBUG call :ShowDbGMsg
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Executing patched project file ..."
  echo Executing project script. ^<BR^> Client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  echo Executing project script > %CLIENT_STATUSFILE%
  %PATCHED_PROJECT_SCRIPT%
  goto END



rem ************************************************************************************************
rem *** Register the new client with the BMA
rem ************************************************************************************************

:NEW_CLIENT
  echo.
  echo Registering new client ... > %LOCAL_BLOCKER_STATUSFILE%
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Registering new client ..."
rem  %BMTOOL% /wait %DISPLAY_TIME% /text "Registering new client ..."
  echo Registering new client. ^<BR^> Client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  echo Registering new client > %CLIENT_STATUSFILE%
  set INFOFILE=%TEMP%\%BMA_MAC12%_hwinfo.ini

rem *** Create the client information file in the 'temp' directory on the installation server
  echo   Creating client information file ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Creating client information file ..."
  echo Creating information. ^<BR^> Client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  echo. > %INFOFILE%

rem *** Get the client's device information and store it in the client information file
  echo   Detecting device information ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Detecting device information ..."
  echo Detecting device information. ^<BR^> Client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  %BMTOOL% /devices >> %INFOFILE%
  echo. >> %INFOFILE%

rem *** Store the DHCP reply information in the client information file
  echo   Storing DHCP reply information ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Storing DHCP reply information ..."
  echo Storing DHCP reply information. ^<BR^> Client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  echo [BOOTP-DHCP] >> %INFOFILE%
    %BMUTIL% -C
  if ERRORLEVEL 1 (
     echo set caa=%CAA% >> %INFOFILE%
     echo set ca8=%CA8% >> %INFOFILE%	
     echo set yip=%BMNET_IP_ADDRESS% >> %INFOFILE%	
     echo set smf=%BMNET_IP_MASK% >> %INFOFILE%	
     echo set gip=%BMNET_GATEWAY% >> %INFOFILE%	
     echo set gw0=%BMNET_GATEWAY% >> %INFOFILE%
     echo set typ=0000 >> %INFOFILE%
     echo set sip=%BMA_TFTP_SERVER% >> %INFOFILE%	
  ) else (
   %BMUTIL% -S >> %INFOFILE%
  )
  echo. >> %INFOFILE%


rem *** Now that the client information file is complete, move it to the 'actual' BMA location
rem *** where it will be recognized and processed by the BMA console
  echo   Activating client information file ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Activating client information file ..."
  echo Activating client information file. ^<BR^> Client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  copy %INFOFILE% %BMNEWPCDIR%\%BMA_MAC8%.chi
  if not defined DEBUG del %INFOFILE%

  
rem *** As long as the client hardware information file remains present,
rem *** the administrator has not yet accepted this PC.
rem  del /q %LOCAL_BLOCKFILE%

REM ************************************************************************************************
REM *** Wait until the new client was accepted by the BMA console
REM *** This is the case when the client's information file vanishes
REM *** So, we just wait in a loop while call checking for the file
REM *** As long as the client hardware information file remains present,
REM *** the administrator has not yet accepted this PC.
REM ************************************************************************************************
  COPY %LOCAL_BMA_DIR_TOOLS%\blocker_wait.jpg %LOCAL_BLOCKER_PIC%
  ECHO Waiting for administrator confirmation ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_SYSTEMINIT: Waiting for administrator confirmation ..."
  ECHO Waiting for administrator confirmation > %CLIENT_STATUSFILE%
  ECHO Waiting for administrator confirmation. ^<BR^> Client ID: %ca8%>%LOCAL_BLOCKER_STATUSFILE%
  %BMTOOL% /wait 3

  SET SYSTEMBLOCKER_CMD1=0
  SET SYSTEMBLOCKER_CMD2=0

  IF EXIST %LOCAL_BMA_DIR_TEMP%\dataout.cmd DEL /q %LOCAL_BMA_DIR_TEMP%\dataout.cmd
  ECHO ^<SYSTEMBLOCKER INPUTOUTFILE=%LOCAL_BMA_DIR_TEMP%\dataout.cmd^>^<SYSTEMBLOCKER INPUTCMD1=CONFIG^>^<SYSTEMBLOCKER INPUTCMD2=REBOOT^>^<SYSTEMBLOCKER FONTSIZE=12^>Waiting for administrator confirmation.^<BR^>Press CONFIG to install manually.^<BR^>Client ID: '%BMA_MAC8%'>%LOCAL_BLOCKER_STATUSFILE% 

:NEW_CLIENT_LOOP
  PING 127.0.0.1 -n 3 >NUL
  IF EXIST %LOCAL_BMA_DIR_TEMP%\dataout.cmd GOTO NEW_CLIENT_LOOP_OUT
  IF EXIST %BMNEWPCDIR%\%BMA_MAC8%.chi GOTO NEW_CLIENT_LOOP

:NEW_CLIENT_LOOP_OUT
  COPY %LOCAL_BMA_DIR_TOOLS%\blocker.jpg %LOCAL_BLOCKER_PIC%
  ECHO ^<SYSTEMBLOCKER INPUTOUTFILE= ^>^<SYSTEMBLOCKER INPUTCMD1= ^>^<SYSTEMBLOCKER INPUTCMD2= ^>^<SYSTEMBLOCKER FONTSIZE= ^>OK^<BR^>Client ID: %ca8%>%LOCAL_BLOCKER_STATUSFILE% 
  IF EXIST %LOCAL_BMA_DIR_TEMP%\dataout.cmd CALL %LOCAL_BMA_DIR_TEMP%\dataout.cmd
  IF "%SYSTEMBLOCKER_CMD2%" EQU "1" GOTO PC_SHUTDOWN
  IF "%SYSTEMBLOCKER_CMD1%" EQU "1" GOTO BUILD_MAC_OPT

  COPY %LOCAL_BMA_DIR_TOOLS%\blocker_connect.jpg %LOCAL_BLOCKER_PIC%
  ECHO ^<SYSTEMBLOCKER INPUTOUTFILE= ^>^<SYSTEMBLOCKER INPUTCMD1= ^>^<SYSTEMBLOCKER INPUTCMD2= ^> The computer is enabled.^<BR^>Client ID: %ca8%>%LOCAL_BLOCKER_STATUSFILE%
  ECHO The computer is enabled!
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_SYSTEMINIT: The computer is enabled!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "The computer is enabled!"




rem ************************************************************************************************
rem *** If the PC already has a status partition, set its ID value to f3
rem *** so that the PC is forced to start from the network at the next boot
rem *** Also, make sure that only a single status partition exists
rem ************************************************************************************************

  echo.
  echo Looking for existing status partition ...
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: Looking for existing status partition ..."
  echo Looking for existing status partition. client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%

rem *** In debug mode, display the partition table before alteration
  if defined DEBUG (
    echo   Partition table before alteration:
    %BMFDISK% -p \\.\physicaldrive0
  )
  if defined DEBUG call :ShowDbGMsg



  set COUNT=0

  set PART0=
  set PART1=
  set PART2=
  set PART3=

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 0 %%A
    if ERRORLEVEL 1 set PART0=1 && set /a COUNT += 1
  )

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 1 %%A
    if ERRORLEVEL 1 set PART1=1 && set /a COUNT += 1
  )

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 2 %%A
    if ERRORLEVEL 1 set PART2=1 && set /a COUNT += 1
  )

  for %%A in (e0 e1 e2 e3 f0 f1 f2 f3) do (
    %BMFDISK% -c \\.\physicaldrive0 3 %%A
    if ERRORLEVEL 1 set PART3=1 && set /a COUNT += 1
  )

rem *** If more than one status partition was found, we have an error condition
  if "%COUNT%" gtr "1" goto ERR_MULTI_STATUS_PART

rem *** If we have a status partition, set its ID value to 'f3'
  if defined PART0 %BMFDISK% -o \\.\physicaldrive0 0 f3 -f
  if defined PART1 %BMFDISK% -o \\.\physicaldrive0 1 f3 -f
  if defined PART2 %BMFDISK% -o \\.\physicaldrive0 2 f3 -f
  if defined PART3 %BMFDISK% -o \\.\physicaldrive0 3 f3 -f

rem *** In debug mode, display the partition table after alteration
  if defined DEBUG (
    echo   Partition table after alteration:
    %BMFDISK% -p \\.\physicaldrive0
  )

    if defined DEBUG call :ShowDbGMsg

rem ************************************************************************************************
rem *** We need to reboot the client so that it can fetch its individual configuration
rem *** information from its option file during the TFTP phase
rem ************************************************************************************************

rem  echo.
rem  echo Rebooting ...
rem  if defined DEBUG call :ShowDbGMsg

goto PC_SHUTDOWN
goto :EOF
rem ************************************************************************************************
rem *** This is the function section
rem ************************************************************************************************

REM Register manually
:MANUAL_REG
rem *** Mount TFTP Server for manual installations
  call :MOUNT_TFTP

  
  goto :EOF


rem ****************************
rem BUILD MAC.OPT  
rem ****************************

:BUILD_MAC_OPT
  ECHO Conect registration server... ^<BR^>Please wait... > %LOCAL_BLOCKER_STATUSFILE%
  call :MOUNT_TFTP
  set UpCase_mac=%ca8%
  call :UpCase UpCase_mac

  start /min cmd 
  del /q %NET_BLOCKFILE%
  mkdir %TEMP_RAM%\Register >NUL
  xcopy  %BMA_SYSTEM_DIR%\register\*.* %TEMP_RAM%\Register\. /s /e /Y
  call  %TEMP_RAM%\register\RunConfig.cmd
  if "%CLIENT_OPT%" equ "" goto PC_SHUTDOWN
  
  if exist %TFTP_DIR%\pxboot.opt (
    rem if exist %TFTP_DIR%\%UpCase_mac%.opt goto ERR_OPTEXIST
    copy "%TFTP_DIR%\pxboot.opt" + "%CLIENT_OPT%" "%TFTP_DIR%\%UpCase_mac%.opt"
  )
  copy "%CLIENT_VAR%"  %CLIENT_SERVER_CONFIG_DIR%

  mkdir "%CLIENT_SERVER_LOG_DIR%\AUTOREGISTER"
  copy /Y "%TFTP_DIR%\pxboot.opt" + "%CLIENT_OPT%" %CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.opt
  copy /Y "%CLIENT_VAR%" %CLIENT_SERVER_LOG_DIR%\AUTOREGISTER\%ca8%.var

  copy /Y "%CLIENT_VAR%" %CLIENT_SERVER_CONFIG_DIR%\%ca8%.var

  copy /Y "%CLIENT_VAR%" "%CLIENT_VAR%_FULL"
  if not exist %TFTP_DIR%\%UpCase_mac%.opt goto ERR_TFNET_DRIVE


  for /f "delims=" %%A in ('%BMNET% -n %TFTP_DIR%\%UpCase_mac%.opt -f 2') do set "LINEBUFF=%%A" & call :ConvertLine 
  rem *** Assign "names" to required configuration parameters
  set BMA_MAC12=%BMNET_ADAPTER_CAA%
  set BMA_MAC8=%BMNET_ADAPTER_CA8%
  set caa=%BMNET_ADAPTER_CAA%
  set ca8=%BMNET_ADAPTER_CA8%
  rem redifine t129 
  for /f "delims=" %%A in ('find ^"B129^" %TFTP_DIR%\%UpCase_mac%.opt') do set "LINEBUFF=%%A" & call :GETB129 

  SET "OUTFILE=%CLIENT_VAR%_OPT"
  echo. > "%CLIENT_VAR%_OPT" 
  for /f "delims=" %%A in ('%BMNET% -n %TFTP_DIR%\%UpCase_mac%.opt -f 1') do set "LINEBUFF=%%A"  & call :ConvertLinetoFile %LINEBUFF%

  copy /Y "%CLIENT_VAR%_OPT" + "%CLIENT_VAR%" "%CLIENT_VAR%_FULL"
  if "%ERRORLEVEL%" equ "0" (
    set "CLIENT_VAR=%CLIENT_VAR%_FULL"
    copy /Y "%CLIENT_VAR%_FULL" "%CLIENT_VAR%_ALL"
    set "CLIENT_VARFILE=%CLIENT_VAR%_ALL"
  )

  if not exist "w:\%t156%\BMA_WINPE_PROJECT.cmd" goto ERR_OS
  "w:\%t156%\BMA_WINPE_PROJECT.cmd"

  echo press a key to reboot
  pause



  goto PC_SHUTDOWN 

goto :EOF

rem ***************************
REM TFTP data directory login
rem ***************************
:MOUNT_TFTP
  if defined BMA_DOMAIN if not defined BMA_WORKGROUP goto TFTP_DOMAIN
  if defined BMA_WORKGROUP if not defined BMA_DOMAIN goto TFTP_WORKGROUP

rem *** Connect a network drive while logging on using domain credentials
:TFTP_DOMAIN
  echo.
  echo Performing a DOMAIN logon ...
  echo   Domain name is "%BMA_DOMAIN%"
  echo   Connecting network drive %TFTP_DIR% to "\\%BMA_SERVER%\%TFTPBOOT_SHARE%" ...
rem  %BMTOOL% /wait %DISPLAY_TIME% /text "Performing a DOMAIN logon<BR><BR>Domain name is '%BMA_DOMAIN%'<BR><BR>Connecting network drive %TFTP_DIR% to '\\%BMA_SERVER%\%TFTPBOOT_SHARE%' ..."
  net use %TFTP_DIR% \\%BMA_SERVER%\%TFTPBOOT_SHARE% %BMA_PASSWORD% /user:%BMA_DOMAIN%\%BMA_USERNAME% /persistent:no 
  if ERRORLEVEL 1 goto TNET_DRIVE
  goto :EOF

rem *** Connect a network drive while logging on using workgroup credentials
:TFTP_WORKGROUP
  echo.
  echo Performing a WORKGROUP logon ...
  echo   Workgroup name is "%BMA_WORKGROUP%"
  echo   Connecting network drive %TFTP_DIR% to "\\%BMA_SERVER%\%TFTPBOOT_SHARE%" ...
rem  %BMTOOL% /wait %DISPLAY_TIME% /text "Performing a WORKGROUP logon<BR><BR>Workgroup name is '%BMA_WORKGROUP%'<BR><BR>Connecting network drive %TFTP_DIR% to '\\%BMA_SERVER%\%TFTPBOOT_SHARE%' ..."
  net use %TFTP_DIR% \\%BMA_SERVER%\%TFTPBOOT_SHARE% %BMA_PASSWORD% /user:%BMA_WORKGROUP%\%BMA_USERNAME% /persistent:no 
  dir %TFTP_DIR% >NUL
  if ERRORLEVEL 1 net use %TFTP_DIR% \\%BMA_SERVER%\%TFTPBOOT_SHARE% %BMA_PASSWORD% /user:%COMPUTERNAME%\%BMA_USERNAME% /persistent:no 
  dir %TFTP_DIR% >NUL
  if ERRORLEVEL 1 net use %TFTP_DIR% \\%BMA_SERVER%\%TFTPBOOT_SHARE% %BMA_PASSWORD% /user:%BMA_USERNAME% /persistent:no 
  dir %TFTP_DIR% >NUL
  if ERRORLEVEL 1 goto TNET_DRIVE

  goto :EOF

:TNET_DRIVE
  REM user local alternative 
  echo check local TFTPBOOT configuration files 
  if exist "W:\TFTPBOOT\pxboot.opt" SET "TFTP_DIR=W:\TFTPBOOT"
  if not exist "W:\TFTPBOOT\pxboot.opt" goto ERR_TNET_DRIVE
  goto :EOF

:UpCase
:: Subroutine to convert a variable VALUE to all UPPER CASE.
:: The argument for this subroutine is the variable NAME.
FOR %%i IN ("a=A" "b=B" "c=C" "d=D" "e=E" "f=F" "g=G" "h=H" "i=I" "j=J" "k=K" "l=L" "m=M" "n=N" "o=O" "p=P" "q=Q" "r=R" "s=S" "t=T" "u=U" "v=V" "w=W" "x=X" "y=Y" "z=Z") DO CALL SET "%1=%%%1:%%~i%%"
GOTO:EOF

:ShowDbGMsg
  %BMTOOL% /wait 3 /key /text "Debug Mode<BR><BR>Press ENTER to pause"
  if "%ERRORLEVEL%" equ "100" pause
  goto :EOF

  
:TestStructure
  SET TESTDIR=%~1
  echo   checking %TESTDIR% directory
  if not exist %TESTDIR%\nul mkdir %TESTDIR%
  set TESTFILE=%TESTDIR%\%BMA_MAC12%_testfile.txt
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_STRUCT
  echo Directory test file for client "%BMA_MAC12%" > %TESTFILE%
  if not exist %TESTFILE% goto ERR_STRUCT
  if exist %TESTFILE% del %TESTFILE%
  if exist %TESTFILE% goto ERR_STRUCT
goto :EOF

:ERR_STRUCT
  SET "ERROR=1"
goto :EOF

:: Convert BMNET_OPTION_<number> to t<number>
:Conv2File
set "LINEBUFF=%LINEBUFF:BMNET_OPTION_=t%"
echo %LINEBUFF%  >> %CLIENT_VARFILE%
GOTO:EOF

:GETB129
set StrData=%LINEBUFF:~0,5%
if "%StrData%" neq "B129=" goto :EOF
set StrData=%LINEBUFF:~1%
set t%StrData%
set t129=[9]%t129%
goto :EOF

:: Convert BMNET_OPTION_<number> to t<number>
:ConvertLinetoFile 
set "LINEBUFF=%LINEBUFF:BMNET_OPTION_=t%"
echo %LINEBUFF% >> %OUTFILE%
GOTO:EOF
   
:: Convert BMNET_OPTION_<number> to t<number>
:ConvertLine 
set "LINEBUFF=%LINEBUFF:BMNET_OPTION_=t%"
%LINEBUFF%
GOTO:EOF

rem ************************************************************************************************
rem *** This is the error messages section
rem ************************************************************************************************


:ERR_OS
  SET ERROR_TYPE=SOURCE
  SET ERROR_MSG="ERROR: Unable to find Operating system !"
  echo.
  echo.
  echo %ERROR_MSG%
  echo w:\%t156%\BMA_WINPE_PROJECT.cmd missing
  echo.
  goto FATAL

:ERR_CMD_EXT
  SET ERROR_TYPE=CMD
  SET ERROR_MSG="ERROR: Command processor extensions are not enabled !"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL


:ERR_WINPE_TYPE
  SET ERROR_TYPE=PETYPE
  SET ERROR_MSG="ERROR: The Windows PE type of this boot image could not be detected !"
  echo.
  echo.
  echo %ERROR_MSG%
  goto FATAL


:ERR_TOOLS
  SET ERROR_TYPE=TOOLS
  SET ERROR_MSG="One or more of the BootManage Administrator utilities are missing"
  echo.
  echo.
  echo ERROR: One or more of the BootManage Administrator utilities
  echo        are missing in this Windows PE boot image !
  goto FATAL


:ERR_CONFIG
  SET ERROR_TYPE=CONFIG
  SET ERROR_MSG="ERROR: BMA configuration parameters are not present!"
  echo.
  echo.
  echo ERROR: BootManage Administrator configuration parameters are not present !
  echo.
  echo Possible causes are:
  echo.
  echo        This Windows PE Boot Image was not used within
  echo        the context of the BootManage Administrator.
  echo.
  goto FATAL


:ERR_PARAM
  SET ERROR_TYPE=PARAM
  SET ERROR_MSG="ERROR: At least one required configuration parameter is missing or invalid !"
  echo.
  echo.
  echo ERROR: At least one required configuration parameter is missing or invalid !
  goto FATAL


:ERR_IP
  SET ERROR_TYPE=NET
  SET ERROR_MSG="ERROR: Unable to contact IP driver."
  echo.
  echo.
  echo ERROR: Unable to contact IP driver.
  echo.
  echo Possible causes are:
  echo.
  echo        This Windows PE Boot Image does not contain a driver for the
  echo        network adapter. It may be necessary to add a third party
  echo        network driver to this Windows PE Boot Image.
  echo.
  goto FATAL

:ERR_OPTEXIST
  SET ERROR_TYPE=NET
  SET ERROR_MSG=" %ca8%.opt already exist! Network drive could not create %ca8%.opt on TFTP data depot"
  echo.
  echo.
  echo ERROR: %ca8%.opt already exist! Network drive could not create %ca8%.opt on TFTP data depot!
  echo.
  goto FATAL

:ERR_TFNET_DRIVE
  SET ERROR_TYPE=NET
  SET ERROR_MSG="Network drive could not create %ca8%.opt on TFTP data depot!"
  echo.
  echo.
  echo ERROR: Network drive could not create %ca8%.opt on TFTP data depot!
  echo.
  goto FATAL


:ERR_TNET_DRIVE
  SET ERROR_TYPE=NET
  SET ERROR_MSG="Network drive could not be connected to the TFTP data depot!"
  echo.
  echo.
  echo ERROR: Network drive could not be connected to the TFTP data depot!
  echo.
  echo Possible causes are:
  echo.
  echo        The server name cannot be resolved into an IP address.
  echo.
  echo        The share does not exist on the installation server.
  echo.
  echo        The logon credentials are invalid, or the account does not exist
  echo        on the installation server respectively in the domain.
  echo.
  echo        Permission restrictions do not allow to access the share.
  echo.
  echo        This Windows PE Boot Image does not contain a driver for the
  echo        network adapter. It may be necessary to add a third party
  echo        network driver to this Windows PE Boot Image.
  goto FATAL

:ERR_NET_DRIVE
  SET ERROR_TYPE=NET
  SET ERROR_MSG="Network drive could not be connected to the installation server!"
  echo.
  echo.
  echo ERROR: Network drive could not be connected to the installation server!
  echo.
  echo Possible causes are:
  echo.
  echo        The server name cannot be resolved into an IP address.
  echo.
  echo        The share does not exist on the installation server.
  echo.
  echo        The logon credentials are invalid, or the account does not exist
  echo        on the installation server respectively in the domain.
  echo.
  echo        Permission restrictions do not allow to access the share.
  echo.
  echo        This Windows PE Boot Image does not contain a driver for the
  echo        network adapter. It may be necessary to add a third party
  echo        network driver to this Windows PE Boot Image.
  set /a loopcount=%loopcount%+1
  %bmtool% /wait /text retry in 5 seconds /key
  if "%loopcount%" neq "3" goto :netloop
  goto FATAL


:ERR_TESTFILE
  SET ERROR_TYPE=TESTFILE
  SET ERROR_MSG="ERROR: Cannot create or access %TESTFILE%!"
  echo.
  echo.
  echo ERROR: Cannot create or access "%TESTFILE%"!
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Cannot create or access '%TESTFILE%'"
  goto FATAL


:ERR_NO_PROJECT
  SET ERROR_TYPE=PROJECT
  SET ERROR_MSG="ERROR: Project file %BMA_PROJECT% missing!"
  echo.
  echo.
  echo ERROR: Project file for BMA project "%BMA_PROJECT%" does not exist!
  %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: ERROR Project file for BMA project '%BMA_PROJECT%' does not exist!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Project file for BMA project '%BMA_PROJECT%' does not exist!"
  goto FATAL


:ERR_MULTI_STATUS_PART
  SET ERROR_TYPE=MULTISTATUS
  SET ERROR_MSG="ERROR: Multiple status partitions were detected on this client!"
  if defined DEBUG  %BMFDISK% -p \\.\physicaldrive0
  echo.
  echo.
  echo ERROR: Multiple status partitions were detected on this client!
  if defined CLIENT_LOGFILE %BMTOOL% /log %CLIENT_LOGFILE% /L "BMA_WINPE_INIT: ERROR Multiple status partitions were detected on this client!"
  %BMTOOL% /wait %DISPLAY_TIME% /text "ERROR: Multiple status partitions were detected on this client!"
  goto FATAL


:FATAL
  echo %ERROR_MSG% Please contact your network administrator! > %LOCAL_BLOCKER_STATUSFILE%

  if not defined CLIENT_STATUSFILE set CLIENT_STATUSFILE=NUL
  if not defined CLIENT_LOCKFILE set CLIENT_LOCKFILE=NUL
  color 4f
  echo.
  echo An error has occurred!
  echo This script cannot continue!
  echo Please contact your network administrator!"
  echo.
  echo ERROR - see client log > %CLIENT_STATUSFILE%


rem *** If the CLIENT_LOCKFILE variable is defined, we can use the lock file loop mechanism
rem *** Otherwise, the lock file mechanism is not available, and we must exit to the commandline
  echo ERROR > %CLIENT_LOCKFILE%
  SET DO_RETRY=0
  if "%ERROR_TYPE%" equ "NET" SET DO_RETRY=1
  if "%ERROR_TYPE%" equ "TESTFILE" SET DO_RETRY=1
  if "%ERROR_TYPE%" equ "PROJECT" SET DO_RETRY=1


:FATAL_LOOP
  echo Error installation. Please contact your network administrator. client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  if "%DO_RETRY%" equ "1" (
     %BMTOOL% /wait 20 /key /text %ERROR_MSG%"<BR><BR>Please contact your network administrator!<BR>Press <SPACE> to retry or <ENTER> to reboot"
  ) else (
      %BMTOOL% /wait 20 /key /text %ERROR_MSG%"<BR><BR>This script cannot continue!<BR>Please contact your network administrator!"
  )
  if "%CLIENT_LOCKFILE%" neq "NUL" (
     if not exist %CLIENT_LOCKFILE% goto PC_SHUTDOWN
  ) 
  goto FATAL_LOOP



:PC_SHUTDOWN
  echo Rebooting ...
  if defined DEBUG %BMTOOL% /wait 3 /key /text "Debug Mode<BR><BR>Press ENTER to pause"
  if "%ERRORLEVEL%" equ "100" pause
  %BMTOOL% /log %CLIENT_LOGFILE% /L "****************** BMA_WINPE_INIT END ******************************"
  DEL /Q %LOCAL_BLOCKFILE%
  copy %LOCAL_BMA_DIR_TOOLS%\blocker_connect.jpg %LOCAL_BLOCKER_PIC%
  set "LOCAL_BLOCKFILE=%LOCAL_BLOCKFILE%_1"
  ECHO 1 > %LOCAL_BLOCKFILE%_1
  ECHO ^<SYSTEMBLOCKER PROGRESSFILE=%LOCAL_BLOCKER_PROGESSFILE%^>^<SYSTEMBLOCKER BLOCKFILE=%LOCAL_BLOCKFILE%^> Please wait... > %LOCAL_BLOCKER_STATUSFILE%  

  if defined DEBUG (
	START SystemBlocker -MAX -TEST -TEXT Please wait... -WAIT 2 -FILE %LOCAL_BLOCKFILE% -STATUSFILE %LOCAL_BLOCKER_STATUSFILE% -PICTURE %LOCAL_BLOCKER_PIC%
  ) else (
	START SystemBlocker -MAX -TEXT Please wait... -WAIT 60 -FILE %LOCAL_BLOCKFILE% -STATUSFILE %LOCAL_BLOCKER_STATUSFILE% -PICTURE %LOCAL_BLOCKER_PIC%
  )
  echo Rebooting ... client ID: %BMA_MAC8% > %LOCAL_BLOCKER_STATUSFILE%
  if exist %LOCAL_BLOCKFILE% del /q %LOCAL_BLOCKFILE%
  if exist %NET_BLOCKFILE% del /q %NET_BLOCKFILE%

  %BMTOOL% /wait 20
  %BMTOOL% /shutdown 1 /wait %DISPLAY_TIME% /text "Rebooting ..."
  REM *** An EXIT statement causes WinPE to reboot the machine
  EXIT


:END
  set t141=
  set BMA_PASSWORD=
  echo.
  %BMTOOL% /log %CLIENT_LOGFILE% /L "****************** BMA_WINPE_INIT END ******************************"

:FIN
