'*****************************************************
' This is a sample VBScript to demonstrate the ActiveX
' capabilities of the BootManage Administrator.
'
' Within all functions, the RemoteServer parameter
' specifies the machine on which the component is
' executed. It defaults to "localhost", but can be
' replaced with the computername of a different machine.
'*****************************************************

  Const DEBUG_LEVEL=1
  Const OPEN_FILE_APPENDING = 8
  DIM SCRIPT_NAME
  DIM APP_PATH
  DIM DATA_DIR
  DIM DATA_FILE 
  dim LogFile
  Dim objFSO
  Set objFSO = CreateObject("Scripting.FileSystemObject") 
  APP_PATH = objFSO.GetParentFolderName(wscript.ScriptFullName) 
  LogFile = APP_PATH & "\prestage.log"
  SCRIPT_NAME = ucase(wscript.ScriptName)
  DATA_DIR = APP_PATH & "\REGISTER\"
  DATA_FILE = APP_PATH & "\REGISTER\SYSBLOCK.INI"


'/*******************************************************
'* Function FileExist
'*******************************************************/
Function FileExist(FileName)
 DIM fso    
 Set fso = CreateObject("Scripting.FileSystemObject")
 If (fso.FileExists(FileName)) Then
   FileExist=true
 Else
   FileExist=false
 End If
end Function

'/*******************************************************
'* Function AppendINI
'*******************************************************/
Function AppendINI(strBuffer)
   AppendFile DATA_FILE, strBuffer
End Function


'/*******************************************************
'* Function AppendFile
'*******************************************************/
Function AppendFile(FileName, strBuffer)
  Dim fso, FileOut
  Set fso     = CreateObject("Scripting.FileSystemObject")
  Set FileOut = fso.OpenTextFile (FileName, OPEN_FILE_APPENDING, true)
      FileOut.WriteLine (strBuffer)
      FileOut.Close
  Set FileOut = Nothing
  Set fso     = Nothing
 End Function

'/*******************************************************
'* Function Str2Int
'*******************************************************/
Function Str2Int(strBuffer)
  if IsNumeric(strBuffer) = true then 
     str2Int = clng(strBuffer)
  Else
     str2Int = -1
  End If
End Function 

'/*******************************************************
'* Function MakeDir
'*******************************************************/
Function MakeDir (strPath)
  Dim strParentPath, objFSO
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  On Error Resume Next
  strParentPath = objFSO.GetParentFolderName(strPath)

  If Not objFSO.FolderExists(strParentPath) Then MakeDir strParentPath
        If Not objFSO.FolderExists(strPath) Then objFSO.CreateFolder strPath
        On Error Goto 0
  MakeDir = objFSO.FolderExists(strPath)
End Function


'*****************************************************
Function OSData()
  Dim objVar
  Dim RetBuffer
  Dim RetNumber
  Dim l
  dim lFS 
  Dim lVal
  Dim RemoteServer
  dim SectionName

  RetBuffer=""
  RemoteServer = "localhost"
  Set objVar = CreateObject("BMA_Server.clsDBOS", RemoteServer)
  For l = 1 To objVar.Count
    RetBuffer = RetBuffer & """" & objVar.Item(l).Name & """" & "," 
    RetBuffer = RetBuffer & """" & objVar.Item(l).LocationPath & """" & ","  
  next  
  OsData = RetBuffer

  Set objVar = Nothing
End Function


'*****************************************************
Function VariablesDataCO(VAR_ID)
  Dim objVar
  Dim RetBuffer
  Dim RetNumber
  Dim l
  Dim lVal
  Dim SectionName
  Dim RemoteServer
  RetBuffer=""
  RemoteServer = "localhost"
  Set objVar = CreateObject("BMA_Server.clsDBSetVar", RemoteServer)
  For l = 1 To objVar.Count
  if VAR_ID = objVar.Item(l).Variable then 
    For lVal = 1 To objVar.Item(l).Count
	      RetBuffer = RetBuffer &  """" & objVar.Item(l).Item(lVal).ValueText & """,""" &  objVar.Item(l).Item(lVal).ValueData & """" & ","
	Next 
  end if 
  next
  VariablesDataCO= RetBuffer
  Set objVar = Nothing

End Function


'/*******************************************************
'* Function ConvertSectionName
'*******************************************************/
Function ConvertSectionName(sBuffer)
	Dim strBuff
	strBuff = sBuffer
	strBuff = replace(strBuff," ","_")
    strBuff = replace(strBuff,"(","")
    strBuff = replace(strBuff,")","")
    strBuff = replace(strBuff,"[","")
    strBuff = replace(strBuff,"]","")
    strBuff = replace(strBuff,"*","")
    strBuff = replace(strBuff,"@","")
    strBuff = replace(strBuff,"?","")
    strBuff = replace(strBuff,"""","")
    strBuff = replace(strBuff,"%","")
    strBuff = replace(strBuff,"$","")
	ConvertSectionName = strBuff
End Function

'/*******************************************************
'* Function ConvertTime
'*******************************************************/
Function ConvertTime(DateTimeValue)
	' YYYY-MM-DDTHH:MM:SS 
	Dim strTime
	strTime = year(DateTimeValue) & "-"
	strTime = strTime & Right("0" & Month(DateTimeValue), 2) & "-"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2) & " "
	strTime = strTime & Right("0" & Hour(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Minute(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2)
	ConvertTime = strTime
End Function


'*****************************************************
' Get all Servers
'
' Display the names of all servers that are defined
' within the BootManage Administrator
'
'*****************************************************
Function ShowVariables()
  Dim objVar
  Dim RetBuffer
  Dim RetNumber
  Dim l
  Dim lVal
  Dim RemoteServer
  RemoteServer = "localhost"
    
  Set objVar = CreateObject("BMA_Server.clsDBSetVar", RemoteServer)
  For l = 1 To objVar.Count
    WScript.StdOut.WriteLine  "-- Variable Text: " & objVar.Item(l).VariableText & " Variable: " & objVar.Item(l).Variable & " Variable Type: " & objVar.Item(l).VariableType & " Seperator: " & objVar.Item(l).Seperator & vbcrlf
    WScript.StdOut.WriteLine  "--   Values:" & vbcrlf
     For lVal = 1 To objVar.Item(l).Count
          WScript.StdOut.WriteLine  "--        ID:" & objVar.Item(l).Item(lVal).ValueID & "  Text:" & objVar.Item(l).Item(lVal).ValueText & " Data:" & objVar.Item(l).Item(lVal).ValueData & "" & " Variable:" & objVar.Item(l).Item(lVal).Variable  & Vbcrlf
     Next 
  Next 

  Set objVar = Nothing

End Function



'*****************************************************
' Error Strings
'*****************************************************
Function GetErrorString(ErrorNumber)
  Select Case ErrorNumber
  Case 10
    GetErrorString = "INVALID_TFTPBOOT"
  Case 20
    GetErrorString = "INVALID_MAC"
  Case 21
    GetErrorString = "INVALID_NAME"
  Case 22
    GetErrorString = "INVALID_CLIENT_PARAM"
  Case 25
    GetErrorString = "INVALID_SERVERNAME"
  Case 40
    GetErrorString = "INVALID_OS"
  Case 41
    GetErrorString = "INVALID_OS_PARAM"
  Case 50
    GetErrorString = "INVALID_BMISTRUCT"
  Case 150
    GetErrorString = "INVALID_DATABASE"
  Case 151
    GetErrorString = "NO_DATA_FOUND"
  Case 100
    GetErrorString = "ERROR_WRITE_FILE"
  Case 1000
    GetErrorString = "ERROR_LICENSE"
  Case 1001
    GetErrorString = "ERROR_DEFAULT_PARAM"
  Case Else   ' Andere Werte.
     GetErrorString = CStr(ErrorNumber)
  End Select

End Function


'/*******************************************************
'* Function ConvertTime
'*******************************************************/
Function ConvertTime(DateTimeValue)
	' YYYY-MM-DDTHH:MM:SS 
	Dim strTime
	strTime = year(DateTimeValue) & "-"
	strTime = strTime & Right("0" & Month(DateTimeValue), 2) & "-"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2) & " "
	strTime = strTime & Right("0" & Hour(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Minute(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2)
	ConvertTime = strTime
End Function


'*****************************************************
' Main Routine
'
' Uncomment one or more of the following lines
' to execute the corresponding function
'
'*****************************************************
 dim sBuff
 call MakeDir(DATA_DIR)
 if objFSO.FileExists (DATA_FILE ) then call objFSO.DeleteFile (DATA_FILE , FALSE)
 
AppendINI "[Common]"
AppendINI "Version=1.0.1" 
AppendINI "VersionDate=" & ConvertTime(now())
AppendINI "TITLE=" & chr(34) & "Client Settings" & chr(34) & ""
AppendINI "FORM.SIZE=8200,7200"
AppendINI "INPUT.AREA=0,0,8000,7000"
AppendINI "DATA_TEMP=%app.path%DATATMP.CFG"
AppendINI "DATA_OUT=%app.path%DATAOUT.CFG"
AppendINI "DATA_FILTER=%app.path%DATAFILTER.CFG"
AppendINI "BASE_SCRIPT=%app.path%SYSDATA.CMD"
AppendINI ""
AppendINI "[MSG]"
AppendINI "ERROR_SAVING=" & chr(34) & "Invalid Data can't save" & chr(34) 
AppendINI ""
AppendINI "[Settings]"
AppendINI "SH,10,10,650,-100," & chr(34) & "SH_SHAPE_TOP" & chr(34) & "," & chr(34) & "127,127,127" & chr(34) & "," & chr(34) & "255,255,255" & chr(34) 
AppendINI "SH,5700,100,10,-200," & chr(34) & "SH_SHAPE_BOTTOM" & chr(34) & ""
AppendINI "LB,150,200,330,8000," & chr(34) & "LB_STATUS" & chr(34) & "," & chr(34) & "Konfiguration:" & chr(34) 
AppendINI "LB,800,200,330,3000," & chr(34) & "LB_SW_TYPE" & chr(34) & "," & chr(34) & "Software Typ:" & chr(34) 
AppendINI "LB,1400,200,330,3000," & chr(34) & "LB_HW_TYPE" & chr(34) & "," & chr(34) & "Hardware Typ:" & chr(34)
AppendINI "LB,2000,200,330,3000," & chr(34) & "LB_IPADRESSE" & chr(34) & "," & chr(34) & "IP-Adresse:" & chr(34) 
AppendINI "LB,2600,200,330,2000," & chr(34) & "LB_RECHNERNAME" & chr(34) & "," & chr(34) & "Rechnnername:" & chr(34) 
AppendINI "LB,2600,3000,330,2000," & chr(34) & "LB_NAME_ID" & chr(34) & "," & chr(34) & "" & chr(34) & ""
AppendINI "LB,3200,200,330,3000," & chr(34) & "LB_DEFAULTGW" & chr(34) & "," & chr(34) & "Gateway" & chr(34) 
AppendINI "LB,3800,200,330,3000," & chr(34) & "LB_OPERATINGSYSTEM" & chr(34) & "," & chr(34) & "Betriebssystem" & chr(34) & ""
AppendINI "LB,4400,200,330,3000," & chr(34) & "LB_SUBNETMASK" & chr(34) & "," & chr(34) & "Subnet Maske" & chr(34) & ""
AppendINI "LB,5000,200,330,3000," & chr(34) & "LB_DNS" & chr(34) & "," & chr(34) & "DNS Server" & chr(34) & ""
sBuff =  "CO,800,3000,330,4000," & chr(34) & "SW_TYPE" & chr(34) & ","
sBuff = sBuff & VariablesDataCO("SW_TYPE")
AppendINI sBuff 

sBuff = "CO,1400,3000,330,4000," & chr(34) & "HW_TYPE" & chr(34) & "," 
sBuff = sBuff & VariablesDataCO("HW_TYPE")
AppendINI sBuff 

AppendINI "TX,2000,3000,330,4000," & chr(34) & "IPADRESSE" & chr(34) & ""
AppendINI "TX,2600,5000,330,2000," & chr(34) & "RECHNERNAME" & chr(34) & ""
AppendINI "TX,3200,3000,330,4000," & chr(34) & "DEFAULTGW" & chr(34) & ""
sBuff = "CO,3800,3000,330,4000," & chr(34) & "OPERATINGSYSTEM" & chr(34) & "," 
sBuff  = sBuff  & OSData
AppendINI sBuff

AppendINI "TX,4400,3000,330,4000," & chr(34) & "SUBNETMASK" & chr(34) & ""
AppendINI "TX,5000,3000,330,4000," & chr(34) & "DNS" & chr(34) & ""
AppendINI "CM,6000,400,330,1500," & chr(34) & "CMD_SAVE" & chr(34) & "," & chr(34) & "SAVE" & chr(34) & ""
AppendINI "CM,6000,2900,330,1500," & chr(34) & "CMD_CANCEL" & chr(34) & "," & chr(34) & "END" & chr(34) & ""

