'*****************************************************
' This is a sample VBScript to demonstrate the ActiveX
' capabilities of the BootManage Administrator.
'
' Within all functions, the RemoteServer parameter
' specifies the machine on which the component is
' executed. It defaults to "localhost", but can be
' replaced with the computername of a different machine.
'*****************************************************
option explicit
  Const DEBUG_LEVEL=1
  Const OPEN_FILE_APPENDING = 8
  DIM SCRIPT_NAME
  DIM APP_PATH
  DIM DATA_DIR
  DIM DATA_DIR_SRV
  dim LogFile
  Dim objFSO
  Set objFSO = CreateObject("Scripting.FileSystemObject") 
  APP_PATH = objFSO.GetParentFolderName(wscript.ScriptFullName) 
  LogFile = APP_PATH & "\prestage.log"
  SCRIPT_NAME = ucase(wscript.ScriptName)
  DATA_DIR = APP_PATH & "\REGISTER\VAR_OPT\"
  DATA_DIR_SRV = APP_PATH & "\REGISTER\SERVER\"
  call MakeDir(DATA_DIR)
  call MakeDir(DATA_DIR_SRV)
  
'*****************************************************
Function ExportOSData()
  Dim objVar
  Dim RetBuffer
  Dim RetNumber
  Dim l
  dim lFS 
  Dim lVal
  Dim RemoteServer
  dim SectionName
  RemoteServer = "localhost"
  call MakeDir(DATA_DIR)
  
  Set objVar = CreateObject("BMA_Server.clsDBOS", RemoteServer)
  For l = 1 To objVar.Count
    
    WScript.StdOut.WriteLine "Found Operatingsystem: " & objVar.Item(l).Name 

    if objFSO.FileExists (DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT") then call objFSO.DeleteFile (DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT" , FALSE)
    if objFSO.FileExists (DATA_DIR & "_" & objVar.Item(l).LocationPath & ".VAR") then call objFSO.DeleteFile (DATA_DIR & "_" & objVar.Item(l).LocationPath & ".VAR" , FALSE)
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T144="
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T149="
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T130=BpInS=04,e2,f2;"
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T131=PxInS=04,e2,f2;"
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T162="
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T163="
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T164="
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T165="
    for lFs = 170 to 199 
       AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T" & lFS & "="
    next 
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T156=" &  objVar.Item(l).LocationPath
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T157=" &  objVar.Item(l).SerialNumber
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T158=" &  objVar.Item(l).FirstPartSize
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T160=" &  objVar.Item(l).ExtendOEMPartition
    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T161=" &  objVar.Item(l).SecondPartSize

    if objVar.Item(l).SupportedFileSystem.Count >= 1 then 
        AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T159=" &  objVar.Item(l).SupportedFileSystem.item(clng(1)).Text
    end if

    AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T166=" &  objVar.Item(l).Version

    if objVar.Item(l).SecondSupportedFileSystem.Count >= 1 then 
        AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", "T167=" &  objVar.Item(l).SecondSupportedFileSystem.item(clng(1)).Text
     end if

    objVar.Item(l).Variables.Inherited = true
    for lVal = 1 to objVar.Item(l).Variables.Count
	    if IsOPTVar(objVar.Item(l).Variables.item(lVal).Variable) = true then 
          AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".OPT", objVar.Item(l).Variables.item(lVal).Variable & "=" & objVar.Item(l).Variables.item(lVal).ValueData 
          AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".VAR",  objVar.Item(l).Variables.item(lVal).Variable & " = " & """" & objVar.Item(l).Variables.item(lVal).ValueData & """"
 '         WScript.StdOut.WriteLine  objVar.Item(l).Variables.item(lVal).Variable & "=" & objVar.Item(l).Variables.item(lVal).ValueData 
 		else 
            AppendFile DATA_DIR & "_" & objVar.Item(l).LocationPath & ".VAR",  objVar.Item(l).Variables.item(lVal).Variable & " = " & """" & objVar.Item(l).Variables.item(lVal).ValueData & """"
 		end if
    next 
  next  
	
 
	
WScript.StdOut.WriteLine ""	


  Set objVar = Nothing

End Function


'/*******************************************************
'* Function ExportServerProperties
'*******************************************************/
Function ExportServerProperties()
  Dim objActiveXServer, RemoteServer, OptFile, VarFile
  dim l, n, vCount, lRet
  RemoteServer = "localhost"
  Set objActiveXServer = CreateObject("BMA_Server.clsDBServer", RemoteServer)
  
 l=0
   lRet = objActiveXServer.SeekRecords ("", clng(l), 1, False)
    Do While lRet <> -1
		OptFile=DATA_DIR_SRV & "_" & objActiveXServer.ServerName & ".OPT"
		VarFile=DATA_DIR_SRV & "_" & objActiveXServer.ServerName & ".VAR"
		if objFSO.FileExists (OptFile) then call objFSO.DeleteFile (OptFile, FALSE)
		if objFSO.FileExists (VarFile) then call objFSO.DeleteFile (VarFile , FALSE)
        WScript.StdOut.WriteLine "Checking Server: "  & objActiveXServer.ServerName
		AppendFile VarFile, "T140 = " & """" & objActiveXServer.InstallUsername & """" 
		AppendFile VarFile, "T141 = " & """" & objActiveXServer.InstallPassword & """" 
		AppendFile VarFile, "T144 = " & """" & "" & """" 
		AppendFile VarFile, "T145 = " & """" & objActiveXServer.OSMainPath & """" 
		AppendFile VarFile, "T149 = " & """" & "" & """" 
		AppendFile VarFile, "T152 = " & """" & objActiveXServer.Organisation & """" 
		AppendFile VarFile, "T153 = " & """" & objActiveXServer.RealServerName & """" 
		AppendFile VarFile, "T154 = " & """" & objActiveXServer.Domain & """" 
		AppendFile VarFile, "T155 = " & """" & objActiveXServer.Workgroup & """" 

        ' " ----- Variables ---- " 
		
		objActiveXServer.Variables.Inherited = true
		vCount = objActiveXServer.Variables.Count
		If vCount > 1 Then
           for n = 1 to vCount
		   	    if IsOPTVar(objActiveXServer.Variables.Item(n).Variable) = true then 
					AppendFile OptFile, objActiveXServer.Variables.Item(n).Variable & "=" & objActiveXServer.Variables.Item(n).value
					AppendFile VarFile, objActiveXServer.Variables.Item(n).Variable & " = " & """" & objActiveXServer.Variables.Item(n).value & """"
				else 
					AppendFile VarFile, objActiveXServer.Variables.Item(n).Variable & " = " & """" & objActiveXServer.Variables.Item(n).value & """"
			end if
            Next
        end if
			
            'RetBuffer=" ----- Computer Groups ---- " & vbcrlf
            'For vCount = 1 to objActiveXServer.ComputerGroups.Count
			'RetBuffer= RetBuffer & objActiveXServer.ComputerGroups.Item(cLng(vCount)).name  & VbCrLf
			'	For n = 1 To objActiveXServer.ComputerGroups.Item(vCount).Variables.Count
            '         RetBuffer= RetBuffer & "    " & objActiveXServer.ComputerGroups.Item(vCount).Variables.Item(n).Variable  
            '         RetBuffer= RetBuffer & "=" & objActiveXServer.ComputerGroups.Item(vCount).Variables.Item(n).Value & vbcrlf
			'	Next 
            'Next 
 
 
		l = l + 1
		 objActiveXServer.Clear
      lRet = objActiveXServer.SeekRecords ("", clng(l), 1,False)
    Loop
	
  Set objActiveXServer = Nothing
End Function

'/*******************************************************
'* Function ShowServerProperties
'*******************************************************/
Function ShowServerProperties()
  Dim objActiveXServer, RemoteServer
  dim l, n, vCount, lRet
  RemoteServer = "localhost"
  Set objActiveXServer = CreateObject("BMA_Server.clsDBServer", RemoteServer)
  l=0
   lRet = objActiveXServer.SeekRecords ("", clng(l), 1, False)
    Do While lRet <> -1
		WScript.StdOut.WriteLine "--------------------------------"
        WScript.StdOut.WriteLine "Checking Server: "  & objActiveXServer.ServerName
		WScript.StdOut.WriteLine "ServerName:            " &  objActiveXServer.ServerName
		WScript.StdOut.WriteLine "RealServerName:        " &  objActiveXServer.RealServerName
		WScript.StdOut.WriteLine "NewClientSourceDir:    " &  objActiveXServer.NewClientSourceDir
		WScript.StdOut.WriteLine "TftpDestination:       " &  objActiveXServer.TftpDestination
		WScript.StdOut.WriteLine "InstallUsername:       " &  objActiveXServer.InstallUsername 
		WScript.StdOut.WriteLine "InstallPassword:       " &  objActiveXServer.InstallPassword
		WScript.StdOut.WriteLine "Domain:                " &  objActiveXServer.Domain
		WScript.StdOut.WriteLine "Workgroup:             " &  objActiveXServer.Workgroup
		WScript.StdOut.WriteLine "OSMainPath:            " &  objActiveXServer.OSMainPath 
		WScript.StdOut.WriteLine "FullName:              " &  objActiveXServer.FullName
		WScript.StdOut.WriteLine "Remark:               " &  objActiveXServer.Remark
		WScript.StdOut.WriteLine "Organisation:          " &  objActiveXServer.Organisation
		WScript.StdOut.WriteLine "SecID:                 " &  objActiveXServer.SecID 

        WScript.StdOut.WriteLine  " ----- Variables ---- " 
		
		objActiveXServer.Variables.Inherited = true
		vCount = objActiveXServer.Variables.Count
		If vCount > 1 Then
           for n = 1 to vCount
             WScript.StdOut.WriteLine "Variable: " & objActiveXServer.Variables.Item(n).Variable
             WScript.StdOut.WriteLine "Variable Text: " & objActiveXServer.Variables.Item(n).VariableText 
             WScript.StdOut.WriteLine "Variable Type: " & objActiveXServer.Variables.Item(n).VariableType 
             WScript.StdOut.WriteLine "Value: " & objActiveXServer.Variables.Item(n).value
             WScript.StdOut.WriteLine "Value Text: " & objActiveXServer.Variables.Item(n).valueText
             WScript.StdOut.WriteLine "Value ID: " & objActiveXServer.Variables.Item(n).valueID 
              WScript.StdOut.WriteLine "------------------" 
            Next
        end if
			
            'RetBuffer=" ----- Computer Groups ---- " & vbcrlf
            'For vCount = 1 to objActiveXServer.ComputerGroups.Count
			'RetBuffer= RetBuffer & objActiveXServer.ComputerGroups.Item(cLng(vCount)).name  & VbCrLf
			'	For n = 1 To objActiveXServer.ComputerGroups.Item(vCount).Variables.Count
            '         RetBuffer= RetBuffer & "    " & objActiveXServer.ComputerGroups.Item(vCount).Variables.Item(n).Variable  
            '         RetBuffer= RetBuffer & "=" & objActiveXServer.ComputerGroups.Item(vCount).Variables.Item(n).Value & vbcrlf
			'	Next 
            'Next 
 
 
		l = l + 1
		 objActiveXServer.Clear
      lRet = objActiveXServer.SeekRecords ("", clng(l), 1,False)
    Loop
	
  Set objActiveXServer = Nothing
End Function


'/*******************************************************
'* Function IsOPTVar
'*******************************************************/
Function IsOPTVar(sVarName)
 if len(sVarName) <> 4 then  
   IsOPTVar=false 
   exit function
 end if 

 if left(sVarName,1) <> "T" then  
   IsOPTVar=false 
   exit function
 end if 
 
 if Str2Int(mid(sVarName,2,3)) = -1  then  
   IsOPTVar=false 
   exit function
 end if 
 
   IsOPTVar=true 
end Function


'/*******************************************************
'* Function FileExist
'*******************************************************/
Function FileExist(FileName)
 DIM fso    
 Set fso = CreateObject("Scripting.FileSystemObject")
 If (fso.FileExists(FileName)) Then
   FileExist=true
 Else
   FileExist=false
 End If
end Function

'/*******************************************************
'* Function AppendFile
'*******************************************************/
Function AppendFile(FileName, strBuffer)
  Dim fso, FileOut
  Set fso     = CreateObject("Scripting.FileSystemObject")
  Set FileOut = fso.OpenTextFile (FileName, OPEN_FILE_APPENDING, true)
      FileOut.WriteLine (strBuffer)
      FileOut.Close
  Set FileOut = Nothing
  Set fso     = Nothing
 End Function

'/*******************************************************
'* Function Str2Int
'*******************************************************/
Function Str2Int(strBuffer)
  if IsNumeric(strBuffer) = true then 
     str2Int = clng(strBuffer)
  Else
     str2Int = -1
  End If
End Function 

'/*******************************************************
'* Function MakeDir
'*******************************************************/
Function MakeDir (strPath)
  Dim strParentPath, objFSO
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  On Error Resume Next
  strParentPath = objFSO.GetParentFolderName(strPath)

  If Not objFSO.FolderExists(strParentPath) Then MakeDir strParentPath
        If Not objFSO.FolderExists(strPath) Then objFSO.CreateFolder strPath
        On Error Goto 0
  MakeDir = objFSO.FolderExists(strPath)
End Function

'*****************************************************
' Optional Sort Array
'*****************************************************
Function SortArray(ArrayIn) 
  Dim oArrayList, iElement, oArrayDic
  Set oArrayDic = CreateObject("Scripting.Dictionary")
  Set oArrayList = CreateObject( "System.Collections.ArrayList" )
   For iElement = 0 To UBound(ArrayIn)
    oArrayList.Add ArrayIn(iElement)
   Next
  oArrayList.Sort
  set SortArray = oArrayList
  For iElement = 0 To UBound(ArrayIn)
    ArrayIn(iElement) = oArrayList(iElement)
  Next
 End Function 

'/*******************************************************
'* Function ConvertTime
'*******************************************************/
Function ConvertTime(DateTimeValue)
	' YYYY-MM-DDTHH:MM:SS 
	Dim strTime
	strTime = year(DateTimeValue) & "-"
	strTime = strTime & Right("0" & Month(DateTimeValue), 2) & "-"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2) & " "
	strTime = strTime & Right("0" & Hour(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Minute(DateTimeValue), 2) & ":"
	strTime = strTime & Right("0" & Day(DateTimeValue), 2)
	ConvertTime = strTime
End Function


'/*******************************************************
'* Function Error Out
'*******************************************************/
Function ErrorOut(sBuffer)
    if ERROR_LOG_FILE <> "" then AppendFile ERROR_LOG_FILE, ConvertTime(now()) & " ERROR: " & sBuffer 
	DebugOut "ERROR: " & sBuffer
End Function

'/*******************************************************
'* Function Debug Out
'*******************************************************/
Function DebugOut(sBuffer)
    if LOG_FILE <> "" then AppendFile LOG_FILE, ConvertTime(now()) & " " & sBuffer 
    if DEBUG_LEVEL = 0 then exit Function
    WScript.StdOut.WriteLine ConvertTime(now()) & " " & sBuffer 
End Function

'/*******************************************************
'* #1 Function Split File Name FileFolderAndExtension
'*******************************************************/
Public Function FileFolderAndExtension(ByVal sFilePath , retFolder , retFile , retExtension , retFileWithExtension ) 
  Dim i 
  sFilePath = Trim(sFilePath)
  i = InStrRev(sFilePath, "\")
  If i > 0 Then
    retFolder = Mid(sFilePath, 1, i)
    sFilePath = Mid(sFilePath, i + 1)
  End If
  i = InStrRev(sFilePath, ".")
  If i > 0 Then
     retExtension = Mid(sFilePath, i + 1)
     sFilePath = Mid(sFilePath, 1, i - 1)
  End If
  retFile = sFilePath
  if (retExtension <> "") then
    retFileWithExtension = retFile & "." & retExtension
  else
    retFileWithExtension = retFile
  end if
End Function

'/*******************************************************
'* #2 Function Split File Name FileWithoutExtension
'*******************************************************/
Public Function FileWithoutExtension(sFilePath ) 
   FileFolderAndExtension sFilePath, "", FileWithoutExtension, "", ""
End Function

'/*******************************************************
'* #3 Function Split File Name FileWithExtension
'*******************************************************/
Public Function FileWithExtension(sFilePath ) 
   FileFolderAndExtension sFilePath, "", "", "", FileWithExtension
End Function

'/*******************************************************
'* #4 Function Split File Name FileExtension
'*******************************************************/
Public Function FileExtension(sFilePath ) 
   FileFolderAndExtension sFilePath, "", "", FileExtension, ""
End Function

'/*******************************************************
'* #5 Function Split File Name FileFolder
'*******************************************************/
Public Function FileFolder(ByVal sFilePath ) 
  FileFolderAndExtension sFilePath, FileFolder, "", "", ""
End Function


'/*******************************************************
'* Function ConvertSectionName
'*******************************************************/
Function ConvertSectionName(sBuffer)
	Dim strBuff
	strBuff = sBuffer
	strBuff = replace(strBuff," ","_")
    strBuff = replace(strBuff,"(","")
    strBuff = replace(strBuff,")","")
    strBuff = replace(strBuff,"[","")
    strBuff = replace(strBuff,"]","")
    strBuff = replace(strBuff,"*","")
    strBuff = replace(strBuff,"@","")
    strBuff = replace(strBuff,"?","")
    strBuff = replace(strBuff,"""","")
    strBuff = replace(strBuff,"%","")
    strBuff = replace(strBuff,"$","")
	ConvertSectionName = strBuff
End Function


'*****************************************************
' Error Strings
'*****************************************************
Function GetErrorString(ErrorNumber)
  Select Case ErrorNumber
  Case 10
    GetErrorString = "INVALID_TFTPBOOT"
  Case 20
    GetErrorString = "INVALID_MAC"
  Case 21
    GetErrorString = "INVALID_NAME"
  Case 22
    GetErrorString = "INVALID_CLIENT_PARAM"
  Case 25
    GetErrorString = "INVALID_SERVERNAME"
  Case 40
    GetErrorString = "INVALID_OS"
  Case 41
    GetErrorString = "INVALID_OS_PARAM"
  Case 50
    GetErrorString = "INVALID_BMISTRUCT"
  Case 150
    GetErrorString = "INVALID_DATABASE"
  Case 151
    GetErrorString = "NO_DATA_FOUND"
  Case 100
    GetErrorString = "ERROR_WRITE_FILE"
  Case 1000
    GetErrorString = "ERROR_LICENSE"
  Case 1001
    GetErrorString = "ERROR_DEFAULT_PARAM"
  Case Else   ' Andere Werte.
     GetErrorString = CStr(ErrorNumber)
  End Select

End Function


'*****************************************************
' Main Routine
'
' Uncomment one or more of the following lines
' to execute the corresponding function
'
'*****************************************************
ExportServerProperties
ExportOSData