'*****************************************************
' This is a sample VBScript to demonstrate the ActiveX
' capabilities of the BootManage Administrator.
'
' Within all functions, the RemoteServer parameter
' specifies the machine on which the component is
' executed. It defaults to "localhost", but can be
' replaced with the computername of a different machine.
'*****************************************************


'*****************************************************
' Function GetData
' SelectTable = Name of database table
' ConditionField = seek condition field
' ConditionValue = seek condition Value
' ReturnField = return the value of this field
' 
' GetData("tbUser","Name","Admin","FullName")
'*****************************************************
Function GetData(SelectTable,ConditionField,ConditionValue,ReturnField)
  Dim objActiveXServer
  Dim sBuffer
  Dim l
  Dim RemoteServer
  
  RemoteServer = "localhost"
  
  Set objActiveXServer = CreateObject("BMA_Server.clsGetData", RemoteServer)
  l = objActiveXServer.GetProperty(SelectTable,ConditionField,ConditionValue,ReturnField,sBuffer)
  If l <> 0 Then
     MsgBox "Fehler: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
  GetData = sBuffer
End Function


'*****************************************************
' Error Strings
'*****************************************************
Function GetErrorString(ErrorNumber)
  Select Case ErrorNumber
  Case 10
    GetErrorString = "INVALID_TFTPBOOT"
  Case 20
    GetErrorString = "INVALID_MAC"
  Case 21
    GetErrorString = "INVALID_NAME"
  Case 22
    GetErrorString = "INVALID_CLIENT_PARAM"
  Case 25
    GetErrorString = "INVALID_SERVERNAME"
  Case 40
    GetErrorString = "INVALID_OS"
  Case 41
    GetErrorString = "INVALID_OS_PARAM"
  Case 50
    GetErrorString = "INVALID_BMISTRUCT"
  Case 150
    GetErrorString = "INVALID_DATABASE"
  Case 151
    GetErrorString = "NO_DATA_FOUND"
  Case 100
    GetErrorString = "ERROR_WRITE_FILE"
  Case 1000
    GetErrorString = "ERROR_LICENSE"
  Case 1001
    GetErrorString = "ERROR_DEFAULT_PARAM"
  Case Else   ' Andere Werte.
     GetErrorString = CStr(ErrorNumber)
  End Select

End Function


'*****************************************************
' Main Routine
'*****************************************************

FullNameAdmin= GetData("tbUser","Name","Admin","FullName")
MsgBox  "FullName Admin=" & FullNameAdmin
