'*****************************************************
' This is a sample VBScript to demonstrate the ActiveX
' capabilities of the BootManage Administrator.
'
' Within all functions, the RemoteServer parameter
' specifies the machine on which the component is
' executed. It defaults to "localhost", but can be
' replaced with the computername of a different machine.
'*****************************************************

'*****************************************************
' Get Client Property
'
' Samples:
' Get MAC address of a clinet named "PC22"
' GetClientProperty("Name", "PC22" ,"MAC")
'*****************************************************
Function GetClientProperty(ConditionField,ConditionValue,ReturnField)
  Dim objActiveXServer
  Dim RemoteServer
  Dim sBuffer
  Dim l

  RemoteServer = "localhost"
  Set objActiveXServer = CreateObject("BMA_Server.clsGetData", RemoteServer)
  l = objActiveXServer.GetClientProperty(ConditionField,ConditionValue,ReturnField,sBuffer)
  If l <> 0 Then
     MsgBox "Fehler: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
  GetClientProperty = sBuffer
End Function



'*****************************************************
' Get client data
'
' Get all data of the client that is specified by
' its MAC address. The parameter "strMAC"
' holds the client's MAC address in hex notation.
'
'*****************************************************
Function GetClientData(strMAC)
  Dim objActiveXServer
  Dim RetData
  Dim RetTableNames
  Dim sClientMacAddress
  Dim l
  Dim RemoteServer
  Dim msg
  Dim i
  
  RemoteServer = "localhost"
  
  Set objActiveXServer = CreateObject("BMA_Server.clsGetData", RemoteServer)
  l = objActiveXServer.GetClient(strMAC, retData, retTableNames)
  If l = 0 Then
     retTableNames = Replace(retTableNames,chr(0),VbCrLf)
     retData = Replace(retData,chr(0),VbCrLf)
     MsgBox "--- Tables: ---" & vbCrLf & retTableNames 
     MsgBox "--- Data: ---" & vbCrLf & retData
  Else
     MsgBox "Fehler: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
End Function


'*****************************************************
' Error Strings
'*****************************************************
Function GetErrorString(ErrorNumber)
  Select Case ErrorNumber
  Case 10
    GetErrorString = "INVALID_TFTPBOOT"
  Case 20
    GetErrorString = "INVALID_MAC"
  Case 21
    GetErrorString = "INVALID_NAME"
  Case 22
    GetErrorString = "INVALID_CLIENT_PARAM"
  Case 25
    GetErrorString = "INVALID_SERVERNAME"
  Case 40
    GetErrorString = "INVALID_OS"
  Case 41
    GetErrorString = "INVALID_OS_PARAM"
  Case 50
    GetErrorString = "INVALID_BMISTRUCT"
  Case 150
    GetErrorString = "INVALID_DATABASE"
  Case 151
    GetErrorString = "NO_DATA_FOUND"
  Case 100
    GetErrorString = "ERROR_WRITE_FILE"
  Case 1000
    GetErrorString = "ERROR_LICENSE"
  Case 1001
    GetErrorString = "ERROR_DEFAULT_PARAM"
  Case Else   ' Andere Werte.
     GetErrorString = CStr(ErrorNumber)
  End Select

End Function


'*****************************************************
' Main Routine
'*****************************************************
  
  strClientName="Harry"
  ClientMAC=GetClientProperty("name",strClientName,"mac")
  GetClientData ClientMAC
