'*****************************************************
' This is a sample VBScript to demonstrate the ActiveX
' capabilities of the BootManage Administrator.
'
' Within all functions, the RemoteServer parameter
' specifies the machine on which the component is
' executed. It defaults to "localhost", but can be
' replaced with the computername of a different machine.
'*****************************************************


'*****************************************************
' Get Groups
'
' If the "strSelectedServer" parameter is not set, then
' this function shows all groups.
' If the "strSelectedServer" parameter is set, then this
' function shows only the groups from the given server.
'
'*****************************************************
Function GetGroups(strSelectedServer)
  Dim objActiveXServer
  Dim RetBuffer
  Dim RetNumber
  Dim l
  Dim RemoteServer
  
  RemoteServer = "localhost"
  sSelectedServer = "" 
  
  Set objActiveXServer = CreateObject("BMA_Server.clsGetData", RemoteServer)
  l = objActiveXServer.GetGroups(RetBuffer, RetNumber, strSelectedServer)
  RetBuffer = Replace(RetBuffer,chr(0),VbCrLf)
  If l = 0 Then
     MsgBox "Number of groups:" & RetNumber & vbCrLf & RetBuffer
  Else
     MsgBox "Error: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
End Function


'*****************************************************
' Error Strings
'*****************************************************
Function GetErrorString(ErrorNumber)
  Select Case ErrorNumber
  Case 10
    GetErrorString = "INVALID_TFTPBOOT"
  Case 20
    GetErrorString = "INVALID_MAC"
  Case 21
    GetErrorString = "INVALID_NAME"
  Case 22
    GetErrorString = "INVALID_CLIENT_PARAM"
  Case 25
    GetErrorString = "INVALID_SERVERNAME"
  Case 40
    GetErrorString = "INVALID_OS"
  Case 41
    GetErrorString = "INVALID_OS_PARAM"
  Case 50
    GetErrorString = "INVALID_BMISTRUCT"
  Case 150
    GetErrorString = "INVALID_DATABASE"
  Case 151
    GetErrorString = "NO_DATA_FOUND"
  Case 100
    GetErrorString = "ERROR_WRITE_FILE"
  Case 1000
    GetErrorString = "ERROR_LICENSE"
  Case 1001
    GetErrorString = "ERROR_DEFAULT_PARAM"
  Case Else   ' Andere Werte.
     GetErrorString = CStr(ErrorNumber)
  End Select

End Function


'*****************************************************
' Main Routine
'*****************************************************

 GetGroups "koeln.bootix.com"

 